#ifdef __APPLE__
#include "seaview.h"
#include <Carbon/Carbon.h>

#include "seaview.h"
#include <string.h>
#include <stdio.h>
#include <FL/Fl.H>
#include <FL/x.H>
#include <FL/Fl_Sys_Menu_Bar.H>
#include <FL/filename.H>
#include <sys/stat.h>
#include <unistd.h>

// included functions
char *mac_fname_to_roman(const char *in);
void fl_ringbell(int a);
extern "C" {
int my_system_macho(char *command, char *base_fname, const char *task_name);
void myKillExternalJob(ProcessSerialNumber psn);
char *MG_GetBundleResourcesDir(void);
void PtoC(const void *in, void *out);
void CtoP(const void *in, void *out);
void MGinit_apple_events(void);
void add_apropos(const char *progname, void *data);
void show_apropos(Fl_Widget *, void *);
Boolean AppleEventsInstalled ();
OSErr  MyHandleODoc (const AppleEvent *theAppleEvent, AppleEvent* reply, long handlerRefCon);
OSErr  MyHandlePDoc (const AppleEvent *theAppleEvent, AppleEvent *reply, long handlerRefCon);
OSErr  MyHandleOApp (const AppleEvent *theAppleEvent, AppleEvent *reply, long handlerRefCon);
OSErr MyGotRequiredParams (const AppleEvent *theAppleEvent);
void MG_apple_inits(void);
}
void set_seaview_modified(SEA_VIEW *view, int ismodified);
void cre_sys_menu(void );
void windowmenuitem_callback(Fl_Widget *o, void *data);
int find_windowmenuitem(Fl_Window *w);
int add_windowmenuitem(char *name, Fl_Window *w);
void rename_windowmenuitem(const char *name, int rank);
void delete_windowmenuitem(int rank);
static pascal void MyNavEventProc_Plus (NavEventCallbackMessage callBackSelector,
						NavCBRecPtr callBackParms, NavCallBackUserData callBackUD);
char *mac_GetOutputFName_Plus(const char *dfault, const char *message, int);
extern void use_initial_file(SEA_VIEW *view, char *masename);
extern char *get_next_help_line(void *in, char *line, int lline);
extern int printout_block, printout_fontsize;
extern int printout_vary, printout_black;
extern paperformat printout_pageformat;

#elif defined(WIN32)

#include <FL/Fl.H>
#include <stdarg.h>
#include <Windows.h>
#include <string.h>
#include <direct.h>
#include <stdlib.h>
#include <stdio.h>

/* included functions */
extern "C" {
void my_bell(void);
int mysystem(const char *command);
char *get_prog_dir(void);
}
char **getutf8args(int *pargc);
extern char *wchartoutf8(const wchar_t *in);
#endif


#ifdef __APPLE__

void utf8_Fl_Window::label(const char *l)
{
	Fl_Widget::label(l);
	if(shown()) {
		CFStringRef mlabel = CFStringCreateWithCString(NULL, l, kCFStringEncodingUTF8);
		SetWindowTitleWithCFString(fl_xid(this), mlabel);
		CFRelease(mlabel);
		}
}


void fl_ringbell(int a)
{
AlertSoundPlay();
}


char *mac_fname_to_roman(const char *in)
/* passage codage pathname vers codage MacRoman qui semble ncessaire pour display cran 
*/
{
static char out[250];
CFStringRef mycfs;
Boolean ok;
/* j'ai cru comprendre que les pathnames sont cods en UTF8 */
mycfs = CFStringCreateWithCString(NULL, in, kCFStringEncodingUTF8);
/* et que MacRoman est utilis pour display */
ok = CFStringGetCString(mycfs, out, sizeof(out), kCFStringEncodingMacRoman);
CFRelease(mycfs);
return (ok ? out : (char *)in);
}


int my_system_macho(char *command, char *base_fname, const char *task_name)
{
char comfile[300];
FILE *out;
FSRef myref, myterm;
OSStatus status;
ProcessSerialNumber newpsn, mypsn;
Boolean cankill;

sprintf(comfile, "%s.command", base_fname);
out = fopen(comfile, "w");
fprintf(out, "%s\n", command);
fclose(out);
chmod(comfile, S_IRUSR|S_IXUSR);
status = FSPathMakeRef((const UInt8 *)comfile, &myref, NULL);
LSFindApplicationForInfo(kLSUnknownCreator, CFSTR("com.apple.terminal"), NULL, &myterm, NULL);
GetCurrentProcess(&mypsn); // seaview
if(LSOpenItemsWithRole == NULL) { // before MacOSX 10.4
	LSLaunchFSRefSpec mylaunch;
	Boolean compare;
	FSRef frontproc;
	mylaunch.appRef = &myterm; // FSRef to the Terminal application
	mylaunch.numDocs = 1;
	mylaunch.itemRefs = &myref;
	mylaunch.passThruParams = NULL;
	mylaunch.launchFlags =  kLSLaunchNewInstance ; // run a new Terminal instance
	mylaunch.asyncRefCon = NULL;
	status = LSOpenFromRefSpec(&mylaunch, &frontproc); // frontproc becomes FSRef to newly started Terminal
	GetFrontProcess(&newpsn); // the newly started Terminal
	SameProcess(&newpsn, &mypsn, &compare);
	// try to kill only a newly started Terminal and not something else nor seaview
	cankill = FSCompareFSRefs(&frontproc, &myterm) == noErr && !compare;
	}
else {
	LSApplicationParameters mylsap;
	mylsap.version = 0;
	mylsap.flags = kLSLaunchNewInstance;
	mylsap.application = &myterm;
	mylsap.asyncLaunchRefCon = NULL;
	mylsap.environment = NULL;
	mylsap.argv = NULL;
	mylsap.initialEvent = NULL;
	status = LSOpenItemsWithRole(&myref, 1, kLSRolesAll, NULL, &mylsap, &newpsn, 1);
	cankill = TRUE;
	}
if(status == noErr) {
    sleep(2);
	fl_cursor(FL_CURSOR_DEFAULT, FL_BLACK, FL_BLACK);
	SetFrontProcess(&mypsn);
	status = fl_choice(
		"Wait for %s completion in Terminal window.",
		"Ignore or interrupt task", "Task completed", NULL, task_name) ? 0 : 1 ; 
	if(cankill) myKillExternalJob(newpsn);
	}
unlink(comfile);
return status != noErr;
}


pid_t get_desc_process(pid_t ascend)
//returns the pid of the first descending process from process of pid ascend
//or 0 if no descendant
{
FILE *pipe;
char command[] = "/bin/ps -U $USER -o pid,ppid ";
char line[2000], *p;
long long pid, ppid;

pipe = popen(command, "r");
fgets(line, sizeof(line), pipe); // skip first line
while(TRUE)	{
	p = fgets(line, sizeof(line), pipe);
	pid = 0;
	if(p == NULL) break;
	sscanf(line, "%lld%lld", &pid, &ppid);
	if( (pid_t)ppid == ascend) break;
	}
pclose(pipe);
return (pid_t) pid;
}


void kill_last_desc(pid_t ascend)
//kills the deepest descendant process from process ascend, if any
{
pid_t son, father;

father = ascend;
do {
	son = get_desc_process(father);
	if(son != 0) father = son;
	}
while(son != 0);
if(father != ascend) kill(father, SIGKILL);
}


void myKillExternalJob(ProcessSerialNumber psn)
//kills job psn (and its descendant on 10.5)
{
pid_t pid;
long version;

Gestalt(gestaltSystemVersion, &version);
if(version >= 0x1050) {//on 10.5 must kill separately the job process
	GetProcessPID(&psn, &pid);
	kill_last_desc(pid);
	}
KillProcess(&psn);
}


char *MG_GetBundleResourcesDir(void)
{
ProcessSerialNumber psn;
FSRef fsref;
static char fname[300];

GetCurrentProcess(&psn);
GetProcessBundleLocation(&psn, &fsref);
FSRefMakePath(&fsref, (UInt8 *)fname, sizeof(fname)-1);
strcat(fname, "/Contents/Resources"); 
return fname;
}

static pascal void MyNavEventProc_Plus (NavEventCallbackMessage callBackSelector,
										NavCBRecPtr callBackParms,
										NavCallBackUserData callBackUD)
{
	OSErr err;
	static Handle gDitlList = NULL;
	static DialogItemIndex index;
	static DialogRef ref;
	static ControlRef var_control = NULL;
	Rect rect; Handle h; DialogItemType dtype; Str255 text; ControlRef control;
	char text2[256];
	
	if(callBackSelector == kNavCBCustomize) {
		if(callBackParms->customRect.bottom == 0) 
			callBackParms->customRect.bottom = callBackParms->customRect.top + 58;
		if(callBackParms->customRect.right == 0) 
			callBackParms->customRect.right = callBackParms->customRect.left + 425;
	}
	else if(callBackSelector == kNavCBStart) {
		gDitlList = GetResource ('DITL', 128);
		if(gDitlList != NULL) err = NavCustomControl(callBackParms->context, 
													 kNavCtlAddControlList, gDitlList);
		err = NavCustomControl(callBackParms->context, kNavCtlGetFirstControlID, &index);
		index++;
		ref = GetDialogFromWindow(callBackParms->window);
		sprintf(text2,"%2d", printout_block);
		CtoP(text2, text);
		GetDialogItem(ref, index + 1, &dtype, &h, &rect);
		SetDialogItemText(h, text);
		sprintf(text2,"%2d", printout_fontsize);
		CtoP(text2, text);
		GetDialogItem(ref, index + 3, &dtype, &h, &rect);
		SetDialogItemText(h, text);
		if(printout_black == PDF_COLOR) {
			err = GetDialogItemAsControl(ref, index + 4, &control);
			if(err == 0) SetControl32BitValue(control, 1);
		}
		else if(printout_black == PDF_BW) {
			err = GetDialogItemAsControl(ref, index + 8, &control);
			if(err == 0) SetControl32BitValue(control, 1);
		}
		else if(printout_black == TEXT_ONLY) {
			err = GetDialogItemAsControl(ref, index + 9, &control);
			if(err == 0) SetControl32BitValue(control, 1);
		}
		
		err = GetDialogItemAsControl(ref, index + 5, &control);
		if(err == 0) SetControl32BitValue(control, printout_pageformat == 0);
		err = GetDialogItemAsControl(ref, index + 6, &control);
		if(err == 0) SetControl32BitValue(control, printout_pageformat == 1);
		
		err = GetDialogItemAsControl(ref, index + 7, &var_control);
		if(err == 0) SetControl32BitValue(var_control, printout_vary);
		if(*(int *)callBackUD) ActivateControl(var_control);
		else DeactivateControl(var_control);
	}
	else if(callBackSelector == kNavCBTerminate) {
		if(gDitlList != NULL) {
			GetDialogItem(ref, index + 1, &dtype, &h, &rect);
			GetDialogItemText(h, text);
			PtoC(text, text2);
			sscanf(text2,"%d", &printout_block);
			GetDialogItem(ref, index + 3, &dtype, &h, &rect);
			GetDialogItemText(h, text);
			PtoC(text, text2);
			sscanf(text2,"%d", &printout_fontsize);
			ReleaseResource( gDitlList );
		}
		var_control = NULL;
	}
	else if(callBackSelector == kNavCBEvent ) {
		if(var_control != NULL && callBackParms->eventData.itemHit == index + 7) {
			printout_vary = (printout_vary + 1) % 2;
			SetControl32BitValue(var_control, printout_vary);
		}
		else if(callBackParms->eventData.itemHit == index + 4) {
			if(printout_black != PDF_COLOR) {
				printout_black = PDF_COLOR;
				GetDialogItemAsControl(ref, index + 4, &control);
				SetControl32BitValue(control, 1);
				GetDialogItemAsControl(ref, index + 8, &control);
				SetControl32BitValue(control, 0);
				GetDialogItemAsControl(ref, index + 9, &control);
				SetControl32BitValue(control, 0);
			}
		}
		else if(callBackParms->eventData.itemHit == index + 8) {
			if(printout_black != PDF_BW) {
				printout_black = PDF_BW;
				GetDialogItemAsControl(ref, index + 4, &control);
				SetControl32BitValue(control, 0);
				GetDialogItemAsControl(ref, index + 8, &control);
				SetControl32BitValue(control, 1);
				GetDialogItemAsControl(ref, index + 9, &control);
				SetControl32BitValue(control, 0);
			}
		}
		else if(callBackParms->eventData.itemHit == index + 9) {
			if(printout_black != TEXT_ONLY) {
				printout_black = TEXT_ONLY;
				GetDialogItemAsControl(ref, index + 4, &control);
				SetControl32BitValue(control, 0);
				GetDialogItemAsControl(ref, index + 8, &control);
				SetControl32BitValue(control, 0);
				GetDialogItemAsControl(ref, index + 9, &control);
				SetControl32BitValue(control, 1);
			}
		}
		else if(callBackParms->eventData.itemHit == index + 5) {
			if(printout_pageformat == LETTER) {
				GetDialogItemAsControl(ref, index + 5, &control);
				SetControl32BitValue(control, 1);
				GetDialogItemAsControl(ref, index + 6, &control);
				SetControl32BitValue(control, 0);
				printout_pageformat = A4;
			}
		}
		else if(callBackParms->eventData.itemHit == index + 6) {
			if(printout_pageformat == A4) {
				GetDialogItemAsControl(ref, index + 6, &control);
				SetControl32BitValue(control, 1);
				GetDialogItemAsControl(ref, index + 5, &control);
				SetControl32BitValue(control, 0);
				printout_pageformat = LETTER;
			}
		}
	}
	return;
}


char *mac_GetOutputFName_Plus(const char *dfault, const char *message, int use_only_button)
{
    OSErr               anErr = noErr;
    NavReplyRecord      reply;
    NavDialogRef        navDialog;
    NavDialogCreationOptions    dialogOptions;
    OSType              fileTypeToSave = 'TEXT';
    OSType              creatorType;
    NavEventUPP         eventProc = NewNavEventUPP (MyNavEventProc_Plus);
	char *rsult = NULL;
	static int *p_use;
    Boolean ok;
	static char pathname[FL_PATH_MAX];
	
    anErr = NavGetDefaultDialogCreationOptions (&dialogOptions);
	if(anErr != noErr) return FALSE;
    dialogOptions.windowTitle = CFStringCreateWithCString(NULL, message, kCFStringEncodingMacRoman);
    dialogOptions.optionFlags |= kNavNoTypePopup;
    dialogOptions.optionFlags &= ~ kNavAllowStationery;
    dialogOptions.saveFileName = CFStringCreateWithCString(NULL, dfault, kCFStringEncodingUTF8); 
	
	creatorType = kNavGenericSignature;
	p_use = &use_only_button;
	anErr = NavCreatePutFileDialog( &dialogOptions, fileTypeToSave, creatorType, eventProc, p_use, &navDialog );
	CFRelease(dialogOptions.saveFileName);
	if(anErr != noErr) return NULL;
	
	anErr = NavDialogRun( navDialog );
	if(anErr != noErr) return NULL;
	
	anErr = NavDialogGetReply( navDialog, &reply );
	
	if (anErr == noErr && reply.validRecord) {
		FSRef fileRef;
		CFURLRef directoryURL, fileURL;
		
		anErr = AEGetNthPtr( &reply.selection, 1, typeFSRef, NULL, NULL, &fileRef, sizeof( FSRef ), NULL );
		if (anErr == noErr)
		{
			directoryURL = CFURLCreateFromFSRef( kCFAllocatorDefault, &fileRef );
			// append new filename to this path
			fileURL = CFURLCreateCopyAppendingPathComponent( kCFAllocatorDefault, directoryURL, reply.saveFileName, false );
			ok = CFURLGetFileSystemRepresentation(fileURL, true, (UInt8 *)pathname, FL_PATH_MAX);
			CFRelease(fileURL); CFRelease(directoryURL);
			if(ok) rsult = pathname;
		}
	}
	DisposeNavEventUPP(eventProc);
	NavDisposeReply( &reply );
	NavDialogDispose( navDialog );
	return rsult;
}


void PtoC(const void *in, void *out)
{
char *vin = (char *)in;
char *vout = (char *)out;
int l = *vin;

if(l > 0) memcpy(vout, vin + 1, l);
vout[l] = 0;
}


void CtoP(const void *in, void *out)
{
char *vout = (char *)out;
int l;
if(in == NULL) l = 0;
else	{
	l = strlen( (char *)in );
	memcpy(vout + 1, in, l);
	}
vout[0] = l;
}


void MGinit_apple_events(void)
{
	OSErr err;
	AEEventHandlerUPP	gAEEventHandlerUPPODoc;
	AEEventHandlerUPP	gAEEventHandlerUPPOApp;
	AEEventHandlerUPP	gAEEventHandlerUPPPDoc;
    Boolean aEvents;
	aEvents = AppleEventsInstalled();
	if (aEvents) {
		gAEEventHandlerUPPODoc = NewAEEventHandlerUPP(MyHandleODoc);
		gAEEventHandlerUPPOApp = NewAEEventHandlerUPP(MyHandleOApp);
		gAEEventHandlerUPPPDoc = NewAEEventHandlerUPP(MyHandlePDoc);
		err = AEInstallEventHandler (kCoreEventClass, kAEOpenDocuments, gAEEventHandlerUPPODoc,0, 0);
		err = AEInstallEventHandler (kCoreEventClass, kAEOpenApplication, gAEEventHandlerUPPOApp,0, 0);
		err = AEInstallEventHandler (kCoreEventClass, kAEPrintDocuments, gAEEventHandlerUPPPDoc,0, 0);
	}
}


void add_apropos(const char *progname, void *data)
{  
	static Fl_Menu_Item item = {"", 0, show_apropos, 0, 0};
	OSStatus err;
	MenuRef mr;
	const  char apple_glyph[2] = "\024";

	Fl_Sys_Menu_Bar *smb = new Fl_Sys_Menu_Bar(0,0,0,0);
	Fl_Menu_Item empty = {0, 0, NULL, 0, 0};
	smb->menu( &empty ); // indispensable pour initialiser fl_sys_menu_bar
	err = CreateNewMenu(1, 0, &mr);
	CFStringRef cftitle = CFStringCreateWithCString(NULL, apple_glyph, kCFStringEncodingMacRoman);
	err = SetMenuTitleWithCFString(mr, cftitle);
	CFRelease(cftitle);
	InsertMenu(mr, 0);
	CFStringRef format = CFStringCreateWithCString(NULL, "About %s", kCFStringEncodingMacRoman);
	cftitle = CFStringCreateWithFormat(NULL, NULL, format, progname);
	CFRelease(format);
	err = InsertMenuItemTextWithCFString(mr, cftitle, 0, 0,0);
	CFRelease(cftitle);
	err = SetMenuItemRefCon(mr, 1, (UInt32) (&item));
	item.user_data_ = data;
}


extern Fl_Sys_Menu_Bar *fl_sys_menu_bar;
void cre_sys_menu(void)
{
static const Fl_Menu_Item items[] = {
	{"Window", 0, NULL, 0, FL_SUBMENU} ,
	{0},
	{0}
	};

fl_sys_menu_bar->menu(items);
}

void windowmenuitem_callback(Fl_Widget *o, void *data)
{
((Fl_Window *)data)->show();
SEA_VIEW *view = (SEA_VIEW *)((Fl_Window *)data)->user_data();
view->DNA_obj->take_focus();
}

int find_windowmenuitem(Fl_Window *w)
{
MenuRef ref = GetMenuRef(2);
UInt32 p;
Fl_Menu_Item *pitem;
int i, count = CountMenuItems(ref);
for(i = 1; i <= count; i++) {
	GetMenuItemRefCon(ref, i, &p);
	pitem = (Fl_Menu_Item *)p;
	if(pitem->user_data_ == w) return i;
	}
return 0;
}

int add_windowmenuitem(char *name, Fl_Window *w)
{
MenuRef ref = GetMenuRef(2);
MenuItemIndex rank;
CFStringRef mycfs = CFStringCreateWithCString(NULL, (name == NULL ? "<empty>" : name), kCFStringEncodingUTF8);
AppendMenuItemTextWithCFString(ref, mycfs, 0, 0, &rank);
CFRelease(mycfs);
Fl_Menu_Item *item = (Fl_Menu_Item *)calloc(1, sizeof(Fl_Menu_Item));
item->user_data_ = w;
item->callback_ = windowmenuitem_callback;
SetMenuItemRefCon(ref, rank, (UInt32)item);
return rank;
}

void rename_windowmenuitem(const char *name, int rank)
{
MenuRef ref = GetMenuRef(2);
CFStringRef mycfs = CFStringCreateWithCString(NULL, name, kCFStringEncodingUTF8);
SetMenuItemTextWithCFString(ref, rank, mycfs);
CFRelease(mycfs);
}

void delete_windowmenuitem(int rank)
{
UInt32 p;
GetMenuItemRefCon(GetMenuRef(2), rank, &p);
free((void *)p);
DeleteMenuItem( GetMenuRef(2) , rank);
}

void show_apropos(Fl_Widget *w, void *data)
{
static Fl_Window *about = NULL;
char line[100], *p;

if(about == NULL) {
	about = new Fl_Window(600, 400, "About seaview");
	Fl_Browser *br = new Fl_Browser(1, 1, about->w() - 2, about->h() - 2);
	about->end();
	br->add("");
	p = get_full_path((char *)data);
	data = (void *)fopen(p, "r");
	if(data == NULL) return;
	get_next_help_line(data, line, sizeof(line));
	if(strncmp(line, ">>>", 3) != 0) br->add(line);
	while(TRUE) {
		get_next_help_line(data, line, sizeof(line));
		if(strncmp(line, ">>>", 3) == 0) break;
		while( (p=strchr(line,'\r')) != NULL) *p = 0;
		while( (p=strchr(line,'\n')) != NULL) *p = 0;
		br->add(line);
		}
	fclose((FILE*)data);
	}
about->show();
}



/***********************************************************************/
Boolean AppleEventsInstalled ()
{
	OSErr err;
	long  result;

	err = Gestalt (gestaltAppleEventsAttr, &result);
	return (!err && ((result >> gestaltAppleEventsPresent) & 0x0001));
											// return TRUE if there is no
											// error and the proper bit of
											// result is set
}

/***********************************************************************/
pascal OSErr  MyHandleODoc (const AppleEvent *theAppleEvent, AppleEvent* reply, long handlerRefCon)
{
	FSRef myFSRef;	
	AEDescList	docList;
	OSErr	err;
	long	itemsInList;
	char masename[300];

	err = AEGetParamDesc (theAppleEvent, keyDirectObject, typeAEList,
			&docList);
	if (err) return err;

	err = MyGotRequiredParams (theAppleEvent);
	if (err) return err;

	err = AECountItems (&docList, &itemsInList);

	err = AEGetNthPtr (&docList, 1, typeFSRef, NULL,
		NULL,  &myFSRef, sizeof(FSRef), NULL);
	if (err) return err;
	
	err = FSRefMakePath(&myFSRef, (UInt8 *)masename, sizeof(masename));
	Fl_Window *w = Fl::first_window();
	if(w != NULL) {
		while(w->window() != NULL) w = w->window();
		SEA_VIEW *view = (SEA_VIEW *)w->user_data();
		use_initial_file(view, masename);
		}
	err = AEDisposeDesc (&docList);
	return noErr;
}

/***********************************************************************/
pascal OSErr  MyHandlePDoc (const AppleEvent *theAppleEvent, AppleEvent *reply, long handlerRefCon)
{
	AEDescList	docList;
	OSErr	err;
	long	itemsInList;
	
	// get the direct parameter--a descriptor list--and put it into a docList
	err = AEGetParamDesc (theAppleEvent, keyDirectObject, typeAEList,
									&docList);
	if (err)
			return err;

	// check for missing parameters
	err = MyGotRequiredParams (theAppleEvent);
	if (err)
			return err;

	// count the number of descriptor records in the list
	err = AECountItems (&docList, &itemsInList);

	// now get each descriptor record from the list, coerce the returned
	// data to an FSSpec record, and open the associated file
	
	return noErr;

}

/***********************************************************************/
pascal OSErr  MyHandleOApp (const AppleEvent *theAppleEvent, AppleEvent *reply, long handlerRefCon)
{
	// Ouverture de l'appli
	return noErr;
}


/***********************************************************************/
OSErr MyGotRequiredParams (const AppleEvent *theAppleEvent)
{
	DescType	returnedType;
	Size	actualSize;
	OSErr	err;

	err = AEGetAttributePtr (theAppleEvent, keyMissedKeywordAttr,
									typeWildCard, &returnedType, nil, 0,
									&actualSize);
	if (err == errAEDescNotFound)	// you got all the required parameters
			return noErr;
	else if (!err)				// you missed a required parameter
			return errAEEventNotHandled;
	else						// the call to AEGetAttributePtr failed
			return err;
}


void MG_apple_inits(void)
{
#ifdef __APPLE_QUARTZ__
Fl::set_font(FL_COURIER,"Courier");
Fl::set_font(FL_COURIER_BOLD,"Courier Bold");
Fl::set_font(FL_COURIER_ITALIC,"Courier Oblique");
Fl::set_font(FL_COURIER_BOLD_ITALIC,"Courier Bold Oblique");
#elif defined(__APPLE_QD__)
Fl::set_font(FL_COURIER," Courier");
Fl::set_font(FL_COURIER_BOLD,"BCourier");
Fl::set_font(FL_COURIER_ITALIC,"ICourier");
Fl::set_font(FL_COURIER_BOLD_ITALIC,"PCourier");
#else
error
#endif
}


void set_seaview_modified(SEA_VIEW *view, int ismodified)
{
view->modif_but_not_saved = ismodified;
SetWindowModified(fl_xid(view->dnawin), (Boolean)ismodified);
}
#endif



#ifdef WIN32

int mysystem(const char *command)
/*
command contains "cmd.exe /c prog.exe args"  or  "prog.exe args"
the first form is compulsory if args contain "> outfile"
prog is searched in dir where calling program was launched, current dir,
windows system dir, windows dir, dirs in PATH.
returns 0 iff OK
*/
{
static char buf[100];
STARTUPINFO info;
PROCESS_INFORMATION pi;
int retval;

GetStartupInfo(&info);
retval = CreateProcess(NULL, (char *)command,0,0,0,0,0,_getcwd(buf,sizeof(buf)),&info,&pi);
if(retval == 0) return 1;
do	{
	Fl::check();
	retval = WaitForSingleObject(pi.hProcess, 500);
	}
while(retval == WAIT_TIMEOUT);
return 0;
}

char *get_prog_dir(void)
/* returns path of dir where calling program was launched */
{
static char *dir = NULL;
char *line, *p;
int l;
	
if(dir == NULL) {
	line = wchartoutf8(GetCommandLineW());
	//fprintf(OUT,"retour GetCommandLine line=%s\n",line);fflush(OUT);
	/* extract 1st word of line or first group delimited by " " */
	if(*line == '"') { line++; p = strchr(line, '"'); }
	else p = strchr(line, ' '); 
	if(p == NULL) p = line + strlen(line);
	l = p - line;
	while( l > 0 && line[l - 1] != '\\' ) l--;
	if(l > 0) {
		dir = (char *)malloc(l + 1);
		memcpy(dir, line, l); dir[l] = 0;
		}
	}
return dir;
}


void my_bell(void)
{
Beep(0,0);
} 


char **getutf8args(int *pargc)
{
int argc;
wchar_t **wargv = CommandLineToArgvW(GetCommandLineW(), &argc);
char **argv = (char **)malloc(argc * sizeof(char *));
for (int count = 0; count < argc; count++) {
	argv[count] = strdup(wchartoutf8(wargv[count]));
	}
*pargc = argc;
return argv;
}

/*
 void add_to_path(char *dir)
 /* ajoute a la variable PATH la directory dir
 teste si deja dedans ou si vide *
{
char *buffer;
int l;

if(dir == NULL || strlen(dir) == 0) return;
buffer = (char *)malloc(10000);
l = GetEnvironmentVariable("PATH", buffer, 10000);
if(l == 0) *buffer = 0;
if(strstr(buffer, dir) != NULL) return;
if(*buffer != 0) strcat(buffer, ";");
strcat(buffer, dir);
SetEnvironmentVariable("PATH", buffer);
free(buffer);
}


char **split_args(char *all, int *pargc)
{
char *p, *q, **argv;
int l, argc = 0;

// compter les arguments
p = all;
while(*p != 0) {
	argc++;
	if(*p == '"') p = strchr(p+1, '"');
	else p = strchr(p, ' ');
	if(p == NULL) break;
	p++;
	while(*p == ' ') p++;
	}
argv = (char **)malloc(argc * sizeof(char *));
*pargc = argc;
// separer les arguments, enlever les "" encadrantes si presentes
p = all; argc = 0;
while(*p != 0) {
	if(*p == '"') { p++; q = strchr(p, '"'); }
	else q = strchr(p, ' ');
	if(q == NULL) q = p + strlen(p);
	l = q - p; 
	argv[argc] = (char *)malloc(l + 1);
	memcpy(argv[argc], p, l); argv[argc][l] = 0;
	if(*q == 0) break;
	p = q + 1;
	while(*p == ' ') p++;
	argc++;
	}
return argv;
}
*/

#endif
