/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.List;

public class ExifIFD
extends IFD {
    private static final int EXPOSURETIME = 33434;
    private static final int FNUMBER = 33437;
    private static final int EXPOSUREPROGRAM = 34850;
    private static final int SPECTRALSENSITIVITY = 34852;
    private static final int ISOSPEEDRATINGS = 34855;
    private static final int OECF = 34856;
    private static final int EXIFVERSION = 36864;
    private static final int DATETIMEORIGINAL = 36867;
    private static final int DATETIMEDIGITIZED = 36868;
    private static final int COMPONENTSCONFIGURATION = 37121;
    private static final int COMPRESSEDBITSPERPIXEL = 37122;
    private static final int SHUTTERSPEEDVALUE = 37377;
    private static final int APERTUREVALUE = 37378;
    private static final int BRIGHTNESSVALUE = 37379;
    private static final int EXPOSUREBIASVALUE = 37380;
    private static final int MAXAPERTUREVALUE = 37381;
    private static final int SUBJECTDISTANCE = 37382;
    private static final int METERINGMODE = 37383;
    private static final int LIGHTSOURCE = 37384;
    private static final int FLASH = 37385;
    private static final int FOCALLENGTH = 37386;
    private static final int SUBJECTAREA = 37396;
    private static final int MAKERNOTE = 37500;
    private static final int USERCOMMENT = 37510;
    private static final int SUBSECTIME = 37520;
    private static final int SUBSECTIMEORIGINAL = 37521;
    private static final int SUBSECTIMEDIGITIZED = 37522;
    private static final int FLASHPIXVERSION = 40960;
    private static final int COLORSPACE = 40961;
    private static final int PIXELXDIMENSION = 40962;
    private static final int PIXELYDIMENSION = 40963;
    private static final int RELATEDSOUNDFILE = 40964;
    private static final int FLASHENERGY = 41483;
    private static final int SPATIALFREQUENCYRESPONSE = 41484;
    private static final int FOCALPLANEXRESOLUTION = 41486;
    private static final int FOCALPLANEYRESOLUTION = 41487;
    private static final int FOCALPLANERESOLUTIONUNIT = 41488;
    private static final int SUBJECTLOCATION = 41492;
    private static final int EXPOSUREINDEX = 41493;
    private static final int SENSINGMETHOD = 41495;
    private static final int FILESOURCE = 41728;
    private static final int SCENETYPE = 41729;
    private static final int CFAPATTERN = 41730;
    private static final int CUSTOMRENDERED = 41985;
    private static final int EXPOSUREMODE = 41986;
    private static final int WHITEBALANCE = 41987;
    private static final int DIGITALZOOMRATIO = 41988;
    private static final int FOCALLENGTHIN35MMFILM = 41989;
    private static final int SCENECAPTURETYPE = 41990;
    private static final int GAINCONTROL = 41991;
    private static final int CONTRAST = 41992;
    private static final int SATURATION = 41993;
    private static final int SHARPNESS = 41994;
    private static final int DEVICESETTINGDESCRIPTION = 41995;
    private static final int SUBJECTDISTANCERANGE = 41996;
    private static final int IMAGEUNIQUEID = 42016;
    private static final String[] COLORSPACE_L = new String[]{"sRGB", "uncalibrated"};
    private static final int[] COLORSPACE_INDEX = new int[]{1, 65535};
    public static final String[] COMPONENTSCONFIGURATION_L = new String[]{"Does not exist", "Y", "Cb", "Cr", "R", "G", "B"};
    public static final String[] CONTRAST_L = new String[]{"normal", "soft", "hard"};
    public static final String[] CUSTOMRENDERED_L = new String[]{"normal", "custom"};
    public static final String[] EXPOSUREMODE_L = new String[]{"auto", "manual", "auto bracket"};
    public static final String[] EXPOSUREPROGRAM_L = new String[]{"unidentified", "manual", "program normal", "aperture priority", "shutter priority", "program creative", "program action", "portrait mode", "landscape mode"};
    public static final String[] FILESOURCE_L = new String[]{"", "", "", "DSC"};
    public static final String[] FLASH_L = new String[]{"did not fire", "fired", "strobe return light not detected", "strobe return light detected", "fired, compulsory flash mode", "fired, compulsory flash mode, return light not detected", "fired, compulsory flash mode, return light detected", "did not fire, compulsory flash mode", "did not fire, auto mode", "fired, auto mode", "fired, auto mode, return light not detected", "fired, auto mode, return light detected", "no flash function", "fired, red-eye reduction mode", "fired, red-eye reduction mode, return light not detected", "fired, red-eye reduction mode, return light detected", "fired, compulsory mode", "fired, compulsory mode, return light not detected", "fired, compulsory flash mode, return light detected", "fired, auto mode, red-eye reduction mode", "fired, auto mode, red-eye reduction mode, return light not detected", "fired, auto mode, red-eye reduction mode, return light detected"};
    public static final int[] FLASH_INDEX = new int[]{0, 1, 5, 7, 9, 13, 15, 16, 24, 25, 29, 31, 32, 65, 69, 71, 73, 77, 79, 89, 93, 95};
    public static final String[] FOCALPLANERESOLUTIONUNIT_L = new String[]{"", "", "inches", "centimeters"};
    public static final String[] GAINCONTROL_L = new String[]{"none", "low gain up", "high gain up", "low gain down", "high gain down"};
    public static final String[] LIGHTSOURCE_L = new String[]{"unknown", "daylight", "fluorescent", "tungsten", "flash", "fine weather", "cloudy weather", "shade", "daylight flourescent (D 5700 - 7100K)", "day white flourescent (N 4600 - 5400K)", "cool white flourescent (W 3900 - 4500K)", "white flourescent (WW 3200 - 3700K)", "standard light A", "standard light B", "standard light C", "D55", "D65", "D75", "D50", "ISO studio tungsten", "other"};
    public static final int[] LIGHTSOURCE_INDEX = new int[]{0, 1, 2, 3, 4, 9, 10, 11, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23, 24, 255};
    public static final String[] METERINGMODE_L = new String[]{"unidentified", "average", "centre weighted average", "spot", "multispot", "pattern", "partial", "other"};
    public static final int[] METERINGMODE_INDEX = new int[]{0, 1, 2, 3, 4, 5, 6, 255};
    public static final String[] SATURATION_L = new String[]{"normal", "soft", "hard"};
    public static final String[] SCENECAPTURETYPE_L = new String[]{"standard", "landscape", "portrait", "night"};
    public static final String[] SCENETYPE_L = new String[]{"", "directly photographed image"};
    public static final String[] SENSINGMETHOD_L = new String[]{"", "not defined", "one-chip color area", "two-chip color area", "three-chip color area", "color sequential area", "", "trilinear", "colour sequential linear"};
    public static final String[] SHARPNESS_L = new String[]{"normal", "soft", "hard"};
    public static final String[] SUBJECTDISTANCERANGE_L = new String[]{"unknown", "macro", "close", "distant"};
    public static final String[] WHITEBALANCE_L = new String[]{"auto", "manual"};
    private Rational _apertureValue;
    private Rational _brightnessValue;
    private int[] _cfaPattern;
    private int _colorSpace = -1;
    private int[] _componentsConfiguration;
    private Rational _compressedBitsPerPixel;
    private int _contrast = 0;
    private int _customRendered = -1;
    private String _dateTimeDigitized;
    private String _dateTimeOriginal;
    private int[] _deviceSettingDescription;
    private Rational _digitalZoomRatio;
    private String _exifVersion = "0220";
    private Rational _exposureBiasValue;
    private Rational _exposureIndex;
    private int _exposureMode = -1;
    private int _exposureProgram = -1;
    private Rational _exposureTime;
    private int _fileSource = -1;
    private int _flash = -1;
    private Rational _flashEnergy;
    private String _flashpixVersion = "0100";
    private Rational _fNumber;
    private Rational _focalLength;
    private int _focalLengthIn35mmFilm = -1;
    private Rational _focalPlaneXResolution;
    private Rational _focalPlaneYResolution;
    private int _focalPlaneResolutionUnit = 2;
    private int _gainControl = -1;
    private String _imageUniqueID;
    private int[] _isoSpeedRatings;
    private int _lightSource = -1;
    private int[] _makerNote;
    private Rational _maxApertureValue;
    private int _meteringMode = -1;
    private int[] _oecf;
    private long _pixelXDimension = -1L;
    private long _pixelYDimension = -1L;
    private String _relatedSoundFile;
    private int _saturation = -1;
    private int _sceneCaptureType = -1;
    private int _sceneType = -1;
    private int _sensingMethod = -1;
    private int _sharpness = -1;
    private Rational _shutterSpeedValue;
    private int[] _spatialFrequencyResponse;
    private String _spectralSensitivity;
    private int[] _subjectArea;
    private Rational _subjectDistance;
    private int _subjectDistanceRange = -1;
    private int[] _subjectLocation;
    private String _subSecTime;
    private String _subSecTimeDigitized;
    private String _subSecTimeOriginal;
    private int[] _userComment;
    private int _whiteBalance = -1;
    private String _manufacturer;
    private String _model;
    private String _software;
    private String _artist;
    private int _orientation;
    private NisoImageMetadata _niso = new NisoImageMetadata();

    public ExifIFD(long l, RepInfo repInfo, RandomAccessFile randomAccessFile, boolean bl) {
        super(l, repInfo, randomAccessFile, bl);
    }

    @Override
    public Property getProperty(boolean bl) {
        Property property;
        LinkedList<Property> linkedList = new LinkedList<Property>();
        linkedList.add(new Property("ExifVersion", PropertyType.STRING, (Object)this._exifVersion));
        linkedList.add(new Property("FlashpixVersion", PropertyType.STRING, (Object)this._flashpixVersion));
        if (this._colorSpace != -1) {
            linkedList.add(this.addIntegerProperty("ColorSpace", this._colorSpace, COLORSPACE_L, COLORSPACE_INDEX, bl));
        }
        if (this._componentsConfiguration != null) {
            linkedList.add(new Property("ComponentsConfiguration", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._componentsConfiguration));
        }
        if (this._compressedBitsPerPixel != null) {
            linkedList.add(this.addRationalProperty("CompressedBitsPerPixel", this._compressedBitsPerPixel, bl));
        }
        if (this._pixelXDimension != -1L) {
            linkedList.add(new Property("PixelXDimension", PropertyType.LONG, (Object)new Long(this._pixelXDimension)));
        }
        if (this._pixelYDimension != -1L) {
            linkedList.add(new Property("PixelYDimension", PropertyType.LONG, (Object)new Long(this._pixelYDimension)));
        }
        if (this._makerNote != null) {
            linkedList.add(new Property("MakerNote", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._makerNote));
        }
        if (this._userComment != null && (property = this.makeUserCommentProperty(this._userComment, bl)) != null) {
            linkedList.add(property);
        }
        if (this._relatedSoundFile != null) {
            linkedList.add(new Property("RelatedSoundFile", PropertyType.STRING, (Object)this._relatedSoundFile));
        }
        if (this._dateTimeOriginal != null) {
            linkedList.add(new Property("DateTimeOriginal", PropertyType.STRING, (Object)this._dateTimeOriginal));
        }
        if (this._dateTimeDigitized != null) {
            linkedList.add(new Property("DateTimeDigitized", PropertyType.STRING, (Object)this._dateTimeDigitized));
        }
        if (this._subSecTime != null) {
            linkedList.add(new Property("SubSecTime", PropertyType.STRING, (Object)this._subSecTime));
        }
        if (this._subSecTimeOriginal != null) {
            linkedList.add(new Property("SubSecTimeOriginal", PropertyType.STRING, (Object)this._subSecTimeOriginal));
        }
        if (this._subSecTimeDigitized != null) {
            linkedList.add(new Property("SubSecTimeDigitized", PropertyType.STRING, (Object)this._subSecTimeDigitized));
        }
        if (this._imageUniqueID != null) {
            linkedList.add(new Property("ImageUniqueID", PropertyType.STRING, (Object)this._imageUniqueID));
        }
        if (this._exposureTime != null) {
            linkedList.add(this.addRationalProperty("ExposureTime", this._exposureTime, bl));
        }
        if (this._fNumber != null) {
            linkedList.add(this.addRationalProperty("FNumber", this._fNumber, bl));
        }
        if (this._exposureProgram != -1) {
            linkedList.add(this.addIntegerProperty("ExposureProgram", this._exposureProgram, EXPOSUREPROGRAM_L, bl));
        }
        if (this._spectralSensitivity != null) {
            linkedList.add(new Property("SpectralSensitivity", PropertyType.STRING, (Object)this._spectralSensitivity));
        }
        if (this._isoSpeedRatings != null) {
            linkedList.add(new Property("ISOSpeedRatings", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._isoSpeedRatings));
        }
        if (this._oecf != null) {
            linkedList.add(new Property("OECF", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._oecf));
        }
        if (this._shutterSpeedValue != null) {
            linkedList.add(this.addRationalProperty("ShutterSpeedValue", this._shutterSpeedValue, bl));
        }
        if (this._apertureValue != null) {
            linkedList.add(this.addRationalProperty("ApertureValue", this._apertureValue, bl));
        }
        if (this._brightnessValue != null) {
            linkedList.add(this.addRationalProperty("BrightnessValue", this._brightnessValue, bl));
        }
        if (this._exposureBiasValue != null) {
            linkedList.add(this.addRationalProperty("ExposureBiasValue", this._exposureBiasValue, bl));
        }
        if (this._maxApertureValue != null) {
            linkedList.add(this.addRationalProperty("MaxApertureValue", this._maxApertureValue, bl));
        }
        if (this._subjectDistance != null) {
            linkedList.add(this.addRationalProperty("SubjectDistance", this._subjectDistance, bl));
        }
        if (this._meteringMode != -1) {
            linkedList.add(this.addIntegerProperty("MeteringMode", this._meteringMode, METERINGMODE_L, METERINGMODE_INDEX, bl));
        }
        if (this._lightSource != -1) {
            linkedList.add(this.addIntegerProperty("LightSource", this._lightSource, LIGHTSOURCE_L, LIGHTSOURCE_INDEX, bl));
        }
        if (this._flash != -1) {
            linkedList.add(this.addIntegerProperty("Flash", this._flash, FLASH_L, FLASH_INDEX, bl));
        }
        if (this._focalLength != null) {
            linkedList.add(this.addRationalProperty("FocalLength", this._focalLength, bl));
        }
        if (this._subjectArea != null) {
            linkedList.add(new Property("SubjectArea", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._subjectArea));
        }
        if (this._flashEnergy != null) {
            linkedList.add(this.addRationalProperty("FlashEnergy", this._flashEnergy, bl));
        }
        if (this._spatialFrequencyResponse != null) {
            linkedList.add(new Property("SubjectArea", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._subjectArea));
        }
        if (this._focalPlaneXResolution != null) {
            linkedList.add(this.addRationalProperty("FocalPlaneXResolution", this._focalPlaneXResolution, bl));
        }
        if (this._focalPlaneYResolution != null) {
            linkedList.add(this.addRationalProperty("FocalPlaneYResolution", this._focalPlaneYResolution, bl));
        }
        if (this._focalPlaneResolutionUnit != -1) {
            linkedList.add(this.addIntegerProperty("FocalPlaneResolutionUnit", this._focalPlaneResolutionUnit, FOCALPLANERESOLUTIONUNIT_L, bl));
        }
        if (this._subjectLocation != null) {
            linkedList.add(new Property("SubjectLocation", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._subjectLocation));
        }
        if (this._exposureIndex != null) {
            linkedList.add(this.addRationalProperty("ExposureIndex", this._exposureIndex, bl));
        }
        if (this._sensingMethod != -1) {
            linkedList.add(this.addIntegerProperty("SensingMethod", this._sensingMethod, SENSINGMETHOD_L, bl));
        }
        if (this._fileSource != -1) {
            linkedList.add(this.addIntegerProperty("FileSource", this._fileSource, FILESOURCE_L, bl));
        }
        if (this._sceneType != -1) {
            linkedList.add(this.addIntegerProperty("SceneType", this._sceneType, SCENETYPE_L, bl));
        }
        if (this._cfaPattern != null) {
            linkedList.add(new Property("CFAPattern", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._cfaPattern));
        }
        if (this._customRendered != -1) {
            linkedList.add(this.addIntegerProperty("CustomRendered", this._customRendered, CUSTOMRENDERED_L, bl));
        }
        if (this._exposureMode != -1) {
            linkedList.add(this.addIntegerProperty("ExposureMode", this._exposureMode, EXPOSUREMODE_L, bl));
        }
        if (this._whiteBalance != -1) {
            linkedList.add(this.addIntegerProperty("WhiteBalance", this._whiteBalance, WHITEBALANCE_L, bl));
        }
        if (this._digitalZoomRatio != null) {
            linkedList.add(this.addRationalProperty("DigitalZoomRatio", this._digitalZoomRatio, bl));
        }
        if (this._focalLengthIn35mmFilm != -1) {
            linkedList.add(new Property("FocalLengthIn35mmFilm", PropertyType.INTEGER, (Object)new Integer(this._focalLengthIn35mmFilm)));
        }
        if (this._sceneCaptureType != -1) {
            linkedList.add(this.addIntegerProperty("SceneCaptureType", this._sceneCaptureType, SCENECAPTURETYPE_L, bl));
        }
        if (this._gainControl != -1) {
            linkedList.add(this.addIntegerProperty("GainControl", this._gainControl, GAINCONTROL_L, bl));
        }
        if (this._saturation != -1) {
            linkedList.add(this.addIntegerProperty("Saturation", this._saturation, SATURATION_L, bl));
        }
        if (this._sharpness != -1) {
            linkedList.add(this.addIntegerProperty("Sharpness", this._sharpness, SHARPNESS_L, bl));
        }
        if (this._deviceSettingDescription != null) {
            linkedList.add(new Property("DeviceSettingDescription", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._deviceSettingDescription));
        }
        if (this._subjectDistanceRange != -1) {
            linkedList.add(this.addIntegerProperty("SubjectDistanceRange", this._subjectDistanceRange, SUBJECTDISTANCERANGE_L, bl));
        }
        if (this._manufacturer != null) {
            linkedList.add(new Property("Make", PropertyType.STRING, (Object)this._manufacturer));
        }
        if (this._model != null) {
            linkedList.add(new Property("Model", PropertyType.STRING, (Object)this._model));
        }
        if (this._software != null) {
            linkedList.add(new Property("Software", PropertyType.STRING, (Object)this._software));
        }
        if (this._artist != null) {
            linkedList.add(new Property("Artist", PropertyType.STRING, (Object)this._artist));
        }
        return this.propertyHeader("Exif", linkedList);
    }

    public String getExifVersion() {
        return this._exifVersion;
    }

    public NisoImageMetadata getNisoImageMetadata() {
        return this._niso;
    }

    public String getFlashpixVersion() {
        return this._flashpixVersion;
    }

    public int getColorspace() {
        return this._colorSpace;
    }

    public List exifProps(Property property) {
        try {
            Property[] propertyArray = (Property[])property.getValue();
            Property property2 = propertyArray[2];
            return (List)property2.getValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void lookupTag(int n, int n2, long l, long l2) throws TiffException {
        try {
            if (n == 37378) {
                ExifIFD.checkType(n, n2, 5);
                ExifIFD.checkCount(n, l, 1);
                this._apertureValue = this.readRational(l, l2);
            } else if (n == 37379) {
                ExifIFD.checkType(n, n2, 10);
                ExifIFD.checkCount(n, l, 1);
                this._brightnessValue = this.readRational(l, l2);
            } else if (n == 41730) {
                ExifIFD.checkType(n, n2, 7);
                this._cfaPattern = this.readByteArray(n2, l, l2);
            } else if (n == 40961) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._colorSpace = this.readShort(n2, l, l2);
            } else if (n == 40961) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._colorSpace = this.readShort(n2, l, l2);
            } else if (n == 37121) {
                ExifIFD.checkType(n, n2, 7);
                this._componentsConfiguration = this.readByteArray(n2, l, l2);
            } else if (n == 37122) {
                ExifIFD.checkType(n, n2, 5);
                ExifIFD.checkCount(n, l, 1);
                this._compressedBitsPerPixel = this.readRational(l, l2);
            } else if (n == 41992) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._contrast = this.readShort(n2, l, l2);
            } else if (n == 41985) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._customRendered = this.readShort(n2, l, l2);
            } else if (n == 36868) {
                ExifIFD.checkType(n, n2, 2);
                ExifIFD.checkCount(n, l, 20);
                this._dateTimeDigitized = this.readASCII(l, l2);
            } else if (n == 36867) {
                ExifIFD.checkType(n, n2, 2);
                ExifIFD.checkCount(n, l, 20);
                this._dateTimeOriginal = this.readASCII(l, l2);
            } else if (n == 41995) {
                ExifIFD.checkType(n, n2, 7);
                this._deviceSettingDescription = this.readByteArray(n2, l, l2);
            } else if (n == 41988) {
                ExifIFD.checkType(n, n2, 5);
                ExifIFD.checkCount(n, l, 1);
                this._digitalZoomRatio = this.readRational(l, l2);
            } else if (n == 36864) {
                ExifIFD.checkType(n, n2, 7);
                ExifIFD.checkCount(n, l, 4);
                int[] nArray = this.readShortArray(n2, l, l2);
                char[] cArray = new char[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    cArray[i] = (char)nArray[i];
                }
                this._exifVersion = new String(cArray);
            } else if (n == 37380) {
                ExifIFD.checkType(n, n2, 10);
                ExifIFD.checkCount(n, l, 1);
                this._exposureBiasValue = this.readRational(l, l2);
            } else if (n == 41493) {
                ExifIFD.checkType(n, n2, 5);
                ExifIFD.checkCount(n, l, 1);
                this._exposureIndex = this.readRational(l, l2);
            } else if (n == 41986) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._exposureMode = this.readShort(n2, l, l2);
            } else if (n == 34850) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._exposureProgram = this.readShort(n2, l, l2);
            } else if (n == 33434) {
                ExifIFD.checkType(n, n2, 5);
                ExifIFD.checkCount(n, l, 1);
                this._exposureTime = this.readRational(l, l2);
            } else if (n == 41728) {
                ExifIFD.checkType(n, n2, 7);
                ExifIFD.checkCount(n, l, 1);
                this._fileSource = this.readByte(n2, l, l2);
            } else if (n == 37385) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._flash = this.readShort(n2, l, l2);
            } else if (n == 41483) {
                ExifIFD.checkType(n, n2, 5);
                ExifIFD.checkCount(n, l, 1);
                this._flashEnergy = this.readRational(l, l2);
            } else if (n == 40960) {
                ExifIFD.checkType(n, n2, 7);
                ExifIFD.checkCount(n, l, 4);
                int[] nArray = this.readShortArray(n2, l, l2);
                char[] cArray = new char[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    cArray[i] = (char)nArray[i];
                }
                this._flashpixVersion = new String(cArray);
            } else if (n == 33437) {
                ExifIFD.checkType(n, n2, 5);
                ExifIFD.checkCount(n, l, 1);
                this._fNumber = this.readRational(l, l2);
            } else if (n == 37386) {
                ExifIFD.checkType(n, n2, 5);
                ExifIFD.checkCount(n, l, 1);
                this._focalLength = this.readRational(l, l2);
            } else if (n == 41989) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._focalLengthIn35mmFilm = this.readShort(n2, l, l2);
            } else if (n == 41486) {
                ExifIFD.checkType(n, n2, 5);
                ExifIFD.checkCount(n, l, 1);
                this._focalPlaneXResolution = this.readRational(l, l2);
            } else if (n == 41487) {
                ExifIFD.checkType(n, n2, 5);
                ExifIFD.checkCount(n, l, 1);
                this._focalPlaneYResolution = this.readRational(l, l2);
            } else if (n == 41488) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._focalPlaneResolutionUnit = this.readShort(n2, l, l2);
            } else if (n == 41991) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._gainControl = this.readShort(n2, l, l2);
            } else if (n == 42016) {
                ExifIFD.checkType(n, n2, 2);
                ExifIFD.checkCount(n, l, 33);
                this._imageUniqueID = this.readASCII(l, l2);
            } else if (n == 34855) {
                ExifIFD.checkType(n, n2, 3);
                this._isoSpeedRatings = this.readShortArray(n2, l, l2);
            } else if (n == 37384) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._lightSource = this.readShort(n2, l, l2);
            } else if (n == 37500) {
                ExifIFD.checkType(n, n2, 7);
                this._makerNote = this.readShortArray(n2, l, l2);
            } else if (n == 37381) {
                ExifIFD.checkType(n, n2, 5);
                ExifIFD.checkCount(n, l, 1);
                this._maxApertureValue = this.readRational(l, l2);
            } else if (n == 37383) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._meteringMode = this.readShort(n2, l, l2);
            } else if (n == 34856) {
                ExifIFD.checkType(n, n2, 3);
                this._oecf = this.readShortArray(n2, l, l2);
            } else if (n == 40962) {
                ExifIFD.checkType(n, n2, 4);
                ExifIFD.checkCount(n, l, 1);
                this._pixelXDimension = this.readLong(n2, l, l2);
            } else if (n == 40963) {
                ExifIFD.checkType(n, n2, 4);
                ExifIFD.checkCount(n, l, 1);
                this._pixelYDimension = this.readLong(n2, l, l2);
            } else if (n == 40964) {
                ExifIFD.checkType(n, n2, 2);
                ExifIFD.checkCount(n, l, 13);
                this._relatedSoundFile = this.readASCII(l, l2);
            } else if (n == 41993) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._saturation = this.readShort(n2, l, l2);
            } else if (n == 41990) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._sceneCaptureType = this.readShort(n2, l, l2);
            } else if (n == 41729) {
                ExifIFD.checkType(n, n2, 7);
                ExifIFD.checkCount(n, l, 1);
                this._sceneType = this.readShort(n2, l, l2);
            } else if (n == 41495) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._sensingMethod = this.readShort(n2, l, l2);
            } else if (n == 41994) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._sharpness = this.readShort(n2, l, l2);
            } else if (n == 37377) {
                ExifIFD.checkType(n, n2, 10);
                ExifIFD.checkCount(n, l, 1);
                this._shutterSpeedValue = this.readRational(l, l2);
            } else if (n == 41484) {
                ExifIFD.checkType(n, n2, 7);
                this._spatialFrequencyResponse = this.readShortArray(n2, l, l2);
            } else if (n == 34852) {
                ExifIFD.checkType(n, n2, 2);
                this._spectralSensitivity = this.readASCII(l, l2);
            } else if (n == 37396) {
                ExifIFD.checkType(n, n2, 3);
                this._subjectArea = this.readShortArray(n2, l, l2);
            } else if (n == 37382) {
                ExifIFD.checkType(n, n2, 5);
                ExifIFD.checkCount(n, l, 1);
                this._subjectDistance = this.readRational(l, l2);
            } else if (n == 41996) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                this._subjectDistanceRange = this.readShort(n2, l, l2);
            } else if (n == 41492) {
                ExifIFD.checkType(n, n2, 3);
                this._subjectLocation = this.readShortArray(n2, l, l2);
            } else if (n == 37520) {
                ExifIFD.checkType(n, n2, 2);
                this._subSecTime = this.readASCII(l, l2);
            } else if (n == 37522) {
                ExifIFD.checkType(n, n2, 2);
                this._subSecTimeDigitized = this.readASCII(l, l2);
            } else if (n == 37521) {
                ExifIFD.checkType(n, n2, 2);
                this._subSecTimeOriginal = this.readASCII(l, l2);
            } else if (n == 37510) {
                ExifIFD.checkType(n, n2, 7);
                this._userComment = this.readByteArray(n2, l, l2);
            } else if (n == 271) {
                ExifIFD.checkType(n, n2, 2);
                String string = this.readASCII(l, l2);
                this._niso.setScannerManufacturer(string);
                this._manufacturer = string;
            } else if (n == 272) {
                ExifIFD.checkType(n, n2, 2);
                String string = this.readASCII(l, l2);
                this._niso.setScannerModelName(string);
                this._model = string;
            } else if (n == 274) {
                ExifIFD.checkType(n, n2, 3);
                ExifIFD.checkCount(n, l, 1);
                int n3 = this.readShort(n2, l, l2);
                this._niso.setOrientation(n3);
                this._orientation = n3;
            } else if (n == 282) {
                ExifIFD.checkType(n, n2, 5);
                ExifIFD.checkCount(n, l, 1);
                this._niso.setXSamplingFrequency(this.readRational(l, l2));
            } else if (n == 283) {
                ExifIFD.checkType(n, n2, 5);
                ExifIFD.checkCount(n, l, 1);
                this._niso.setYSamplingFrequency(this.readRational(l, l2));
            }
        }
        catch (IOException iOException) {
            throw new TiffException("Read error for tag " + n, l2);
        }
    }

    private Property makeUserCommentProperty(int[] nArray, boolean bl) {
        String string = "Undefined";
        String string2 = null;
        try {
            StringBuffer stringBuffer = new StringBuffer(8);
            int n = 8;
            if (nArray.length < 8) {
                n = nArray.length;
            }
            if (nArray[0] != 0) {
                for (int i = 0; i < n && nArray[i] != 0; ++i) {
                    stringBuffer.append((char)nArray[i]);
                }
                string = stringBuffer.toString();
            }
            if ("ASCII".equals(string) || "UNICODE".equals(string)) {
                byte[] byArray = new byte[nArray.length - 8];
                for (int i = 0; i < nArray.length - 8; ++i) {
                    byArray[i] = (byte)nArray[i + 8];
                }
                String string3 = "ASCII".equals(string) ? "ASCII" : "UTF8";
                string2 = new String(byArray, string3);
            }
            Property[] propertyArray = nArray != null && string2 != null ? new Property[3] : new Property[2];
            propertyArray[0] = new Property("IDCode", PropertyType.STRING, (Object)string);
            int n2 = 1;
            if (string2 != null) {
                propertyArray[n2++] = new Property("Value", PropertyType.STRING, (Object)string);
            }
            if (nArray != null) {
                propertyArray[n2++] = new Property("RawValue", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)nArray);
            }
            return new Property("UserComment", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

