/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.vcf;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFilterHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFNamedHeaderLine;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VCFUtils {
    private VCFUtils() {
    }

    public static Map<String, VCFHeader> getVCFHeadersFromRods(GenomeAnalysisEngine toolkit, Collection<String> rodNames) {
        HashMap<String, VCFHeader> data = new HashMap<String, VCFHeader>();
        List dataSources = toolkit.getRodDataSources();
        for (ReferenceOrderedDataSource source : dataSources) {
            if (rodNames != null && !rodNames.contains(source.getName()) || source.getHeader() == null || !(source.getHeader() instanceof VCFHeader)) continue;
            data.put(source.getName(), (VCFHeader)source.getHeader());
        }
        return data;
    }

    public static Map<String, VCFHeader> getVCFHeadersFromRodPrefix(GenomeAnalysisEngine toolkit, String prefix) {
        HashMap<String, VCFHeader> data = new HashMap<String, VCFHeader>();
        List dataSources = toolkit.getRodDataSources();
        for (ReferenceOrderedDataSource source : dataSources) {
            if (!source.getName().startsWith(prefix) || source.getHeader() == null || !(source.getHeader() instanceof VCFHeader)) continue;
            data.put(source.getName(), (VCFHeader)source.getHeader());
        }
        return data;
    }

    public static Set<VCFHeaderLine> getHeaderFields(GenomeAnalysisEngine toolkit) {
        return VCFUtils.getHeaderFields(toolkit, null);
    }

    public static Set<VCFHeaderLine> getHeaderFields(GenomeAnalysisEngine toolkit, Collection<String> rodNames) {
        TreeSet<VCFHeaderLine> fields = new TreeSet<VCFHeaderLine>();
        List dataSources = toolkit.getRodDataSources();
        for (ReferenceOrderedDataSource source : dataSources) {
            VCFHeader header;
            if (rodNames != null && !rodNames.contains(source.getName()) || !source.getRecordType().equals(VariantContext.class) || (header = (VCFHeader)source.getHeader()) == null) continue;
            fields.addAll(header.getMetaData());
        }
        return fields;
    }

    public static Set<VCFHeaderLine> smartMergeHeaders(Collection<VCFHeader> headers, Logger logger) throws IllegalStateException {
        HashMap<String, VCFHeaderLine> map = new HashMap<String, VCFHeaderLine>();
        for (VCFHeader source : headers) {
            for (VCFHeaderLine line : source.getMetaData()) {
                String key = line.getKey();
                if (line instanceof VCFNamedHeaderLine) {
                    key = key + "" + ((VCFNamedHeaderLine)((Object)line)).getName();
                }
                if (map.containsKey(key)) {
                    VCFHeaderLine other = (VCFHeaderLine)map.get(key);
                    if (line.equals(other)) continue;
                    if (!line.getClass().equals(other.getClass())) {
                        throw new IllegalStateException("Incompatible header types: " + line + " " + other);
                    }
                    if (line instanceof VCFFilterHeaderLine) {
                        String otherName;
                        String lineName = ((VCFFilterHeaderLine)line).getName();
                        if (lineName.equals(otherName = ((VCFFilterHeaderLine)other).getName())) continue;
                        throw new IllegalStateException("Incompatible header types: " + line + " " + other);
                    }
                    if (line instanceof VCFCompoundHeaderLine) {
                        VCFCompoundHeaderLine compLine = (VCFCompoundHeaderLine)line;
                        VCFCompoundHeaderLine compOther = (VCFCompoundHeaderLine)other;
                        if (!compLine.equalsExcludingDescription(compOther)) {
                            if (compLine.getType().equals((Object)compOther.getType())) {
                                if (logger != null) {
                                    logger.warn((Object)("Promoting header field Number to . due to number differences in header lines: " + line + " " + other));
                                }
                                compOther.setNumberToUnbounded();
                            } else if (compLine.getType() == VCFHeaderLineType.Integer && compOther.getType() == VCFHeaderLineType.Float) {
                                if (logger != null) {
                                    logger.warn((Object)("Promoting Integer to Float in header: " + compOther));
                                }
                                map.put(key, compOther);
                            } else if (compLine.getType() == VCFHeaderLineType.Float && compOther.getType() == VCFHeaderLineType.Integer) {
                                if (logger != null) {
                                    logger.warn((Object)("Promoting Integer to Float in header: " + compOther));
                                }
                            } else {
                                throw new IllegalStateException("Incompatible header types, collision between these two types: " + line + " " + other);
                            }
                        }
                        if (compLine.getDescription().equals(compOther) || logger == null) continue;
                        logger.warn((Object)("Allowing unequal description fields through: keeping " + compOther + " excluding " + compLine));
                        continue;
                    }
                    if (logger == null) continue;
                    logger.warn((Object)("Ignoring header line already in map: this header line = " + line + " already present header = " + other));
                    continue;
                }
                map.put(key, line);
            }
        }
        return new HashSet<VCFHeaderLine>(map.values());
    }

    public static Set<VCFFormatHeaderLine> getSupportedHeaderStrings() {
        HashSet<VCFFormatHeaderLine> result = new HashSet<VCFFormatHeaderLine>();
        result.add(new VCFFormatHeaderLine("GT", 1, VCFHeaderLineType.String, "Genotype"));
        result.add(new VCFFormatHeaderLine("GQ", 1, VCFHeaderLineType.Float, "Genotype Quality"));
        result.add(new VCFFormatHeaderLine("DP", 1, VCFHeaderLineType.Integer, "Read Depth (only filtered reads used for calling)"));
        result.add(new VCFFormatHeaderLine("PL", 3, VCFHeaderLineType.Float, "Normalized, Phred-scaled likelihoods for AA,AB,BB genotypes where A=ref and B=alt; not applicable if site is not biallelic"));
        return result;
    }
}

