/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.broad.tribble.Feature;
import org.broad.tribble.TribbleException;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFParser;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.InferredGeneticContext;

public class VariantContext
implements Feature {
    protected InferredGeneticContext commonInfo = null;
    public static final double NO_NEG_LOG_10PERROR = -1.0;
    public static final String UNPARSED_GENOTYPE_MAP_KEY = "_UNPARSED_GENOTYPE_MAP_";
    public static final String UNPARSED_GENOTYPE_PARSER_KEY = "_UNPARSED_GENOTYPE_PARSER_";
    public static final String ID_KEY = "ID";
    private final Byte REFERENCE_BASE_FOR_INDEL;
    public static final Set<String> PASSES_FILTERS = Collections.unmodifiableSet(new LinkedHashSet());
    protected String contig;
    protected long start;
    protected long stop;
    protected Type type = null;
    protected LinkedHashSet<Allele> alleles = null;
    protected Map<String, Genotype> genotypes = null;
    protected int[] genotypeCounts = null;
    public static final Map<String, Genotype> NO_GENOTYPES = Collections.unmodifiableMap(new HashMap());
    private Allele REF = null;
    private Allele ALT = null;
    private boolean filtersWereAppliedToContext;

    public VariantContext(String source, String contig, long start, long stop, Collection<Allele> alleles, Map<String, Genotype> genotypes, double negLog10PError, Set<String> filters, Map<String, ?> attributes, Byte referenceBaseForIndel) {
        this(source, contig, start, stop, alleles, genotypes, negLog10PError, filters, attributes, referenceBaseForIndel, false);
    }

    public VariantContext(String source, String contig, long start, long stop, Collection<Allele> alleles, Map<String, Genotype> genotypes, double negLog10PError, Set<String> filters, Map<String, ?> attributes) {
        this(source, contig, start, stop, alleles, genotypes, negLog10PError, filters, attributes, null, false);
    }

    public VariantContext(String source, String contig, long start, long stop, Collection<Allele> alleles, double negLog10PError, Set<String> filters, Map<String, ?> attributes, Byte referenceBaseForIndel) {
        this(source, contig, start, stop, alleles, NO_GENOTYPES, negLog10PError, filters, attributes, referenceBaseForIndel, true);
    }

    public VariantContext(String source, String contig, long start, long stop, Collection<Allele> alleles, Collection<Genotype> genotypes, double negLog10PError, Set<String> filters, Map<String, ?> attributes) {
        this(source, contig, start, stop, alleles, genotypes != null ? VariantContext.genotypeCollectionToMap(new TreeMap<String, Genotype>(), genotypes) : null, negLog10PError, filters, attributes, null, false);
    }

    public VariantContext(String source, String contig, long start, long stop, Collection<Allele> alleles) {
        this(source, contig, start, stop, alleles, NO_GENOTYPES, -1.0, null, null, null, false);
    }

    public VariantContext(String source, String contig, long start, long stop, Collection<Allele> alleles, Collection<Genotype> genotypes) {
        this(source, contig, start, stop, alleles, genotypes, -1.0, null, null);
    }

    public VariantContext(VariantContext other) {
        this(other.getSource(), other.getChr(), other.getStart(), other.getEnd(), other.getAlleles(), other.getGenotypes(), other.getNegLog10PError(), other.filtersWereApplied() ? other.getFilters() : null, other.getAttributes(), other.REFERENCE_BASE_FOR_INDEL, false);
    }

    private VariantContext(String source, String contig, long start, long stop, Collection<Allele> alleles, Map<String, Genotype> genotypes, double negLog10PError, Set<String> filters, Map<String, ?> attributes, Byte referenceBaseForIndel, boolean genotypesAreUnparsed) {
        if (contig == null) {
            throw new IllegalArgumentException("Contig cannot be null");
        }
        this.contig = contig;
        this.start = start;
        this.stop = stop;
        if (!genotypesAreUnparsed && attributes != null) {
            if (attributes.containsKey(UNPARSED_GENOTYPE_MAP_KEY)) {
                attributes.remove(UNPARSED_GENOTYPE_MAP_KEY);
            }
            if (attributes.containsKey(UNPARSED_GENOTYPE_PARSER_KEY)) {
                attributes.remove(UNPARSED_GENOTYPE_PARSER_KEY);
            }
        }
        this.commonInfo = new InferredGeneticContext(source, negLog10PError, filters, attributes);
        this.filtersWereAppliedToContext = filters != null;
        this.REFERENCE_BASE_FOR_INDEL = referenceBaseForIndel;
        if (alleles == null) {
            throw new IllegalArgumentException("Alleles cannot be null");
        }
        this.alleles = VariantContext.alleleCollectionToSet(new LinkedHashSet<Allele>(), alleles);
        if (genotypes == null) {
            genotypes = NO_GENOTYPES;
        }
        this.genotypes = Collections.unmodifiableMap(genotypes);
        int nAlleles = alleles.size();
        for (Allele a : alleles) {
            if (a.isReference()) {
                this.REF = a;
                continue;
            }
            if (nAlleles != 2) continue;
            this.ALT = a;
        }
        this.validate();
    }

    public static VariantContext modifyGenotypes(VariantContext vc, Map<String, Genotype> genotypes) {
        return new VariantContext(vc.getSource(), vc.getChr(), vc.getStart(), vc.getEnd(), vc.getAlleles(), genotypes, vc.getNegLog10PError(), vc.filtersWereApplied() ? vc.getFilters() : null, new HashMap<String, Object>(vc.getAttributes()), vc.getReferenceBaseForIndel(), false);
    }

    public static VariantContext modifyLocation(VariantContext vc, String chr, int start, int end) {
        return new VariantContext(vc.getSource(), chr, start, end, vc.getAlleles(), vc.genotypes, vc.getNegLog10PError(), vc.filtersWereApplied() ? vc.getFilters() : null, new HashMap<String, Object>(vc.getAttributes()), vc.getReferenceBaseForIndel(), true);
    }

    public static VariantContext modifyFilters(VariantContext vc, Set<String> filters) {
        return new VariantContext(vc.getSource(), vc.getChr(), vc.getStart(), vc.getEnd(), vc.getAlleles(), vc.genotypes, vc.getNegLog10PError(), filters, new HashMap<String, Object>(vc.getAttributes()), vc.getReferenceBaseForIndel(), true);
    }

    public static VariantContext modifyAttributes(VariantContext vc, Map<String, Object> attributes) {
        return new VariantContext(vc.getSource(), vc.getChr(), vc.getStart(), vc.getEnd(), vc.getAlleles(), vc.genotypes, vc.getNegLog10PError(), vc.filtersWereApplied() ? vc.getFilters() : null, attributes, vc.getReferenceBaseForIndel(), true);
    }

    public static VariantContext modifyReferencePadding(VariantContext vc, Byte b) {
        return new VariantContext(vc.getSource(), vc.getChr(), vc.getStart(), vc.getEnd(), vc.getAlleles(), vc.genotypes, vc.getNegLog10PError(), vc.filtersWereApplied() ? vc.getFilters() : null, vc.getAttributes(), b, true);
    }

    public static VariantContext modifyPErrorFiltersAndAttributes(VariantContext vc, double negLog10PError, Set<String> filters, Map<String, Object> attributes) {
        return new VariantContext(vc.getSource(), vc.getChr(), vc.getStart(), vc.getEnd(), vc.getAlleles(), vc.genotypes, negLog10PError, filters, attributes, vc.getReferenceBaseForIndel(), true);
    }

    public VariantContext subContextFromGenotypes(Genotype genotype) {
        return this.subContextFromGenotypes(Arrays.asList(genotype));
    }

    public VariantContext subContextFromGenotypes(Collection<Genotype> genotypes) {
        return this.subContextFromGenotypes(genotypes, this.allelesOfGenotypes(genotypes));
    }

    public VariantContext subContextFromGenotypes(Collection<Genotype> genotypes, Set<Allele> alleles) {
        return new VariantContext(this.getSource(), this.contig, this.start, this.stop, alleles, genotypes != null ? VariantContext.genotypeCollectionToMap(new TreeMap<String, Genotype>(), genotypes) : null, this.getNegLog10PError(), this.filtersWereApplied() ? this.getFilters() : null, this.getAttributes(), this.getReferenceBaseForIndel());
    }

    private Set<Allele> allelesOfGenotypes(Collection<Genotype> genotypes) {
        HashSet<Allele> alleles = new HashSet<Allele>();
        boolean addedref = false;
        for (Genotype g : genotypes) {
            for (Allele a : g.getAlleles()) {
                boolean bl = addedref = addedref || a.isReference();
                if (!a.isCalled()) continue;
                alleles.add(a);
            }
        }
        if (!addedref) {
            alleles.add(this.getReference());
        }
        return alleles;
    }

    public Type getType() {
        if (this.type == null) {
            this.determineType();
        }
        return this.type;
    }

    public boolean isSNP() {
        return this.getType() == Type.SNP;
    }

    public boolean isVariant() {
        return this.getType() != Type.NO_VARIATION;
    }

    public boolean isPointEvent() {
        return this.isSNP() || !this.isVariant();
    }

    public boolean isIndel() {
        return this.getType() == Type.INDEL;
    }

    public boolean isSimpleInsertion() {
        return this.getType() == Type.INDEL && this.getReference().isNull() && this.isBiallelic();
    }

    public boolean isSimpleDeletion() {
        return this.getType() == Type.INDEL && this.getAlternateAllele(0).isNull() && this.isBiallelic();
    }

    public boolean isComplexIndel() {
        return this.isIndel() && !this.isSimpleDeletion() && !this.isSimpleInsertion();
    }

    public boolean isSymbolic() {
        return this.getType() == Type.SYMBOLIC;
    }

    public boolean isMNP() {
        return this.getType() == Type.MNP;
    }

    public boolean isMixed() {
        return this.getType() == Type.MIXED;
    }

    public boolean hasID() {
        return this.commonInfo.hasAttribute(ID_KEY);
    }

    public String getID() {
        return (String)this.commonInfo.getAttribute(ID_KEY);
    }

    public boolean hasReferenceBaseForIndel() {
        return this.REFERENCE_BASE_FOR_INDEL != null;
    }

    public Byte getReferenceBaseForIndel() {
        return this.REFERENCE_BASE_FOR_INDEL;
    }

    public String getSource() {
        return this.commonInfo.getName();
    }

    public Set<String> getFilters() {
        return this.commonInfo.getFilters();
    }

    public boolean isFiltered() {
        return this.commonInfo.isFiltered();
    }

    public boolean isNotFiltered() {
        return this.commonInfo.isNotFiltered();
    }

    public boolean filtersWereApplied() {
        return this.filtersWereAppliedToContext;
    }

    public boolean hasNegLog10PError() {
        return this.commonInfo.hasNegLog10PError();
    }

    public double getNegLog10PError() {
        return this.commonInfo.getNegLog10PError();
    }

    public double getPhredScaledQual() {
        return this.commonInfo.getPhredScaledQual();
    }

    public Map<String, Object> getAttributes() {
        return this.commonInfo.getAttributes();
    }

    public boolean hasAttribute(String key) {
        return this.commonInfo.hasAttribute(key);
    }

    public Object getAttribute(String key) {
        return this.commonInfo.getAttribute(key);
    }

    public Object getAttribute(String key, Object defaultValue) {
        return this.commonInfo.getAttribute(key, defaultValue);
    }

    public String getAttributeAsString(String key) {
        return this.commonInfo.getAttributeAsString(key);
    }

    public String getAttributeAsString(String key, String defaultValue) {
        return this.commonInfo.getAttributeAsString(key, defaultValue);
    }

    public int getAttributeAsInt(String key) {
        return this.commonInfo.getAttributeAsInt(key);
    }

    public int getAttributeAsInt(String key, int defaultValue) {
        return this.commonInfo.getAttributeAsInt(key, defaultValue);
    }

    public double getAttributeAsDouble(String key) {
        return this.commonInfo.getAttributeAsDouble(key);
    }

    public double getAttributeAsDouble(String key, double defaultValue) {
        return this.commonInfo.getAttributeAsDouble(key, defaultValue);
    }

    public boolean getAttributeAsBoolean(String key) {
        return this.commonInfo.getAttributeAsBoolean(key);
    }

    public boolean getAttributeAsBoolean(String key, boolean defaultValue) {
        return this.commonInfo.getAttributeAsBoolean(key, defaultValue);
    }

    public Integer getAttributeAsIntegerNoException(String key) {
        return this.commonInfo.getAttributeAsIntegerNoException(key);
    }

    public Double getAttributeAsDoubleNoException(String key) {
        return this.commonInfo.getAttributeAsDoubleNoException(key);
    }

    public String getAttributeAsStringNoException(String key) {
        return this.commonInfo.getAttributeAsStringNoException(key);
    }

    public Boolean getAttributeAsBooleanNoException(String key) {
        return this.commonInfo.getAttributeAsBooleanNoException(key);
    }

    public Allele getReference() {
        Allele ref = this.REF;
        if (ref == null) {
            throw new IllegalStateException("BUG: no reference allele found at " + this);
        }
        return ref;
    }

    public boolean isBiallelic() {
        return this.getNAlleles() == 2;
    }

    public int getNAlleles() {
        return this.alleles.size();
    }

    public Allele getAllele(String allele) {
        return this.getAllele(allele.getBytes());
    }

    public Allele getAllele(byte[] allele) {
        return Allele.getMatchingAllele(this.getAlleles(), allele);
    }

    public boolean hasAllele(Allele allele) {
        return this.hasAllele(allele, false);
    }

    public boolean hasAllele(Allele allele, boolean ignoreRefState) {
        if (allele == this.REF || allele == this.ALT) {
            return true;
        }
        for (Allele a : this.getAlleles()) {
            if (!a.equals(allele, ignoreRefState)) continue;
            return true;
        }
        return false;
    }

    public Set<Allele> getAlleles() {
        return this.alleles;
    }

    public Set<Allele> getAlternateAlleles() {
        LinkedHashSet<Allele> altAlleles = new LinkedHashSet<Allele>();
        for (Allele allele : this.alleles) {
            if (!allele.isNonReference()) continue;
            altAlleles.add(allele);
        }
        return Collections.unmodifiableSet(altAlleles);
    }

    public List<Integer> getIndelLengths() {
        if (this.getType() != Type.INDEL && this.getType() != Type.MIXED) {
            return null;
        }
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        for (Allele a : this.getAlternateAlleles()) {
            lengths.add(a.length() - this.getReference().length());
        }
        return lengths;
    }

    public Allele getAlternateAllele(int i) {
        int n = 0;
        for (Allele allele : this.alleles) {
            if (!allele.isNonReference() || n++ != i) continue;
            return allele;
        }
        throw new IllegalArgumentException("Requested " + i + " alternative allele but there are only " + n + " alternative alleles " + this);
    }

    public boolean hasSameAlternateAllelesAs(VariantContext other) {
        Set<Allele> thisAlternateAlleles = this.getAlternateAlleles();
        Set<Allele> otherAlternateAlleles = other.getAlternateAlleles();
        if (thisAlternateAlleles.size() != otherAlternateAlleles.size()) {
            return false;
        }
        for (Allele allele : thisAlternateAlleles) {
            if (otherAlternateAlleles.contains(allele)) continue;
            return false;
        }
        return true;
    }

    private void loadGenotypes() {
        if (!this.hasAttribute(UNPARSED_GENOTYPE_MAP_KEY)) {
            if (this.genotypes == null) {
                this.genotypes = NO_GENOTYPES;
            }
            return;
        }
        Object parserObj = this.getAttribute(UNPARSED_GENOTYPE_PARSER_KEY);
        if (parserObj == null || !(parserObj instanceof VCFParser)) {
            throw new IllegalStateException("There is no VCF parser stored to unparse the genotype data");
        }
        VCFParser parser = (VCFParser)parserObj;
        Object mapObj = this.getAttribute(UNPARSED_GENOTYPE_MAP_KEY);
        if (mapObj == null) {
            throw new IllegalStateException("There is no mapping string stored to unparse the genotype data");
        }
        this.genotypes = parser.createGenotypeMap(mapObj.toString(), new ArrayList<Allele>(this.alleles), this.getChr(), this.getStart());
        this.commonInfo.removeAttribute(UNPARSED_GENOTYPE_MAP_KEY);
        this.commonInfo.removeAttribute(UNPARSED_GENOTYPE_PARSER_KEY);
        this.validateGenotypes();
    }

    public int getNSamples() {
        this.loadGenotypes();
        return this.genotypes.size();
    }

    public boolean hasGenotypes() {
        this.loadGenotypes();
        return this.genotypes.size() > 0;
    }

    public boolean hasGenotypes(Collection<String> sampleNames) {
        this.loadGenotypes();
        for (String name : sampleNames) {
            if (this.genotypes.containsKey(name)) continue;
            return false;
        }
        return true;
    }

    public Map<String, Genotype> getGenotypes() {
        this.loadGenotypes();
        return this.genotypes;
    }

    public List<Genotype> getGenotypesSortedByName() {
        this.loadGenotypes();
        Collection<Genotype> types = new TreeMap<String, Genotype>(this.genotypes).values();
        return new ArrayList<Genotype>(types);
    }

    public Map<String, Genotype> getGenotypes(String sampleName) {
        return this.getGenotypes(Arrays.asList(sampleName));
    }

    public Map<String, Genotype> getGenotypes(Collection<String> sampleNames) {
        HashMap<String, Genotype> map = new HashMap<String, Genotype>();
        for (String name : sampleNames) {
            if (map.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate names detected in requested samples " + sampleNames);
            }
            Genotype g = this.getGenotype(name);
            if (g == null) continue;
            map.put(name, g);
        }
        return map;
    }

    public Set<String> getSampleNames() {
        return this.getGenotypes().keySet();
    }

    public Genotype getGenotype(String sample) {
        return this.getGenotypes().get(sample);
    }

    public boolean hasGenotype(String sample) {
        return this.getGenotypes().containsKey(sample);
    }

    public Genotype getGenotype(int ith) {
        return this.getGenotypesSortedByName().get(ith);
    }

    public int getChromosomeCount() {
        int n = 0;
        for (Genotype g : this.getGenotypes().values()) {
            n += g.isNoCall() ? 0 : g.getPloidy();
        }
        return n;
    }

    public int getChromosomeCount(Allele a) {
        int n = 0;
        for (Genotype g : this.getGenotypes().values()) {
            n += g.getAlleles(a).size();
        }
        return n;
    }

    public boolean isMonomorphic() {
        return !this.isVariant() || this.hasGenotypes() && this.getHomRefCount() + this.getNoCallCount() == this.getNSamples();
    }

    public boolean isPolymorphic() {
        return !this.isMonomorphic();
    }

    private void calculateGenotypeCounts() {
        if (this.genotypeCounts == null) {
            this.genotypeCounts = new int[Genotype.Type.values().length];
            for (Genotype g : this.getGenotypes().values()) {
                if (g.isNoCall()) {
                    int n = Genotype.Type.NO_CALL.ordinal();
                    this.genotypeCounts[n] = this.genotypeCounts[n] + 1;
                    continue;
                }
                if (g.isHomRef()) {
                    int n = Genotype.Type.HOM_REF.ordinal();
                    this.genotypeCounts[n] = this.genotypeCounts[n] + 1;
                    continue;
                }
                if (g.isHet()) {
                    int n = Genotype.Type.HET.ordinal();
                    this.genotypeCounts[n] = this.genotypeCounts[n] + 1;
                    continue;
                }
                if (g.isHomVar()) {
                    int n = Genotype.Type.HOM_VAR.ordinal();
                    this.genotypeCounts[n] = this.genotypeCounts[n] + 1;
                    continue;
                }
                throw new IllegalStateException("Genotype of unknown type: " + g);
            }
        }
    }

    public int getNoCallCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[Genotype.Type.NO_CALL.ordinal()];
    }

    public int getHomRefCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[Genotype.Type.HOM_REF.ordinal()];
    }

    public int getHetCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[Genotype.Type.HET.ordinal()];
    }

    public int getHomVarCount() {
        return this.genotypeCounts[Genotype.Type.HOM_VAR.ordinal()];
    }

    public void extraStrictValidation(Allele reference, Byte paddedRefBase, Set<String> rsIDs) {
        this.validateReferenceBases(reference, paddedRefBase);
        this.validateRSIDs(rsIDs);
        this.validateAlternateAlleles();
        this.validateChromosomeCounts();
    }

    public void validateReferenceBases(Allele reference, Byte paddedRefBase) {
        if (!(this.isComplexIndel() || reference.isNull() || reference.basesMatch(this.getReference()))) {
            throw new TribbleException.InternalCodecException(String.format("the REF allele is incorrect for the record at position %s:%d, fasta says %s vs. VCF says %s", this.getChr(), this.getStart(), reference.getBaseString(), this.getReference().getBaseString()));
        }
        if (this.hasReferenceBaseForIndel() && !this.getReferenceBaseForIndel().equals(paddedRefBase)) {
            throw new TribbleException.InternalCodecException(String.format("the padded REF base is incorrect for the record at position %s:%d, fasta says %s vs. VCF says %s", this.getChr(), this.getStart(), Character.valueOf((char)paddedRefBase.byteValue()), Character.valueOf((char)this.getReferenceBaseForIndel().byteValue())));
        }
    }

    public void validateRSIDs(Set<String> rsIDs) {
        if (rsIDs != null && this.hasAttribute(ID_KEY)) {
            for (String id : this.getID().split(";")) {
                if (!id.startsWith("rs") || rsIDs.contains(id)) continue;
                throw new TribbleException.InternalCodecException(String.format("the rsID %s for the record at position %s:%d is not in dbSNP", id, this.getChr(), this.getStart()));
            }
        }
    }

    public void validateAlternateAlleles() {
        if (!this.hasGenotypes()) {
            return;
        }
        Set<Allele> reportedAlleles = this.getAlleles();
        HashSet<Allele> observedAlleles = new HashSet<Allele>();
        observedAlleles.add(this.getReference());
        for (Genotype g : this.getGenotypes().values()) {
            if (!g.isCalled()) continue;
            observedAlleles.addAll(g.getAlleles());
        }
        if (reportedAlleles.size() != observedAlleles.size()) {
            throw new TribbleException.InternalCodecException(String.format("the ALT allele(s) for the record at position %s:%d do not match what is observed in the per-sample genotypes", this.getChr(), this.getStart()));
        }
        int originalSize = reportedAlleles.size();
        observedAlleles.retainAll(reportedAlleles);
        if (observedAlleles.size() != originalSize) {
            throw new TribbleException.InternalCodecException(String.format("the ALT allele(s) for the record at position %s:%d do not match what is observed in the per-sample genotypes", this.getChr(), this.getStart()));
        }
    }

    public void validateChromosomeCounts() {
        int observedAN;
        int reportedAN;
        Map<String, Object> observedAttrs = this.calculateChromosomeCounts();
        if (this.hasAttribute("AN") && (reportedAN = Integer.valueOf(this.getAttribute("AN").toString()).intValue()) != (observedAN = ((Integer)observedAttrs.get("AN")).intValue())) {
            throw new TribbleException.InternalCodecException(String.format("the Allele Number (AN) tag is incorrect for the record at position %s:%d, %d vs. %d", this.getChr(), this.getStart(), reportedAN, observedAN));
        }
        if (this.hasAttribute("AC")) {
            List observedACs = (List)observedAttrs.get("AC");
            if (this.getAttribute("AC") instanceof List) {
                Collections.sort(observedACs);
                List reportedACs = (List)this.getAttribute("AC");
                Collections.sort(reportedACs);
                if (observedACs.size() != reportedACs.size()) {
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag doesn't have the correct number of values for the record at position %s:%d, %d vs. %d", this.getChr(), this.getStart(), reportedACs.size(), observedACs.size()));
                }
                for (int i = 0; i < observedACs.size(); ++i) {
                    if (Integer.valueOf(reportedACs.get(i).toString()) == observedACs.get(i)) continue;
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag is incorrect for the record at position %s:%d, %d vs. %d", this.getChr(), this.getStart(), reportedACs.get(i), observedACs.get(i)));
                }
            } else {
                if (observedACs.size() != 1) {
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag doesn't have enough values for the record at position %s:%d", this.getChr(), this.getStart()));
                }
                int reportedAC = Integer.valueOf(this.getAttribute("AC").toString());
                if (reportedAC != (Integer)observedACs.get(0)) {
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag is incorrect for the record at position %s:%d, %d vs. %d", this.getChr(), this.getStart(), reportedAC, observedACs.get(0)));
                }
            }
        }
    }

    private Map<String, Object> calculateChromosomeCounts() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("AN", this.getChromosomeCount());
        ArrayList<Double> alleleFreqs = new ArrayList<Double>();
        ArrayList<Integer> alleleCounts = new ArrayList<Integer>();
        if (this.getAlternateAlleles().size() > 0) {
            for (Allele allele : this.getAlternateAlleles()) {
                alleleCounts.add(this.getChromosomeCount(allele));
                alleleFreqs.add((double)this.getChromosomeCount(allele) / (double)this.getChromosomeCount());
            }
        } else {
            alleleCounts.add(0);
            alleleFreqs.add(0.0);
        }
        attributes.put("AC", alleleCounts);
        attributes.put("AF", alleleFreqs);
        return attributes;
    }

    private boolean validate() {
        return this.validate(true);
    }

    private boolean validate(boolean throwException) {
        try {
            this.validateReferencePadding();
            this.validateAlleles();
            this.validateGenotypes();
        }
        catch (IllegalArgumentException e) {
            if (throwException) {
                throw e;
            }
            return false;
        }
        return true;
    }

    private void validateReferencePadding() {
        boolean needsPadding;
        if (this.hasSymbolicAlleles()) {
            return;
        }
        boolean bl = needsPadding = this.getReference().length() == this.getEnd() - this.getStart();
        if (needsPadding && !this.hasReferenceBaseForIndel()) {
            throw new ReviewedStingException("Badly formed variant context at location " + this.getChr() + ":" + this.getStart() + "; no padded reference base was provided.");
        }
    }

    private void validateAlleles() {
        boolean alreadySeenRef = false;
        boolean alreadySeenNull = false;
        for (Allele allele : this.alleles) {
            if (allele.isReference()) {
                if (alreadySeenRef) {
                    throw new IllegalArgumentException("BUG: Received two reference tagged alleles in VariantContext " + this.alleles + " this=" + this);
                }
                alreadySeenRef = true;
            }
            if (allele.isNoCall()) {
                throw new IllegalArgumentException("BUG: Cannot add a no call allele to a variant context " + this.alleles + " this=" + this);
            }
            if (!allele.isNull()) continue;
            if (alreadySeenNull) {
                throw new IllegalArgumentException("BUG: Received two null alleles in VariantContext " + this.alleles + " this=" + this);
            }
            alreadySeenNull = true;
        }
        if (!alreadySeenRef) {
            throw new IllegalArgumentException("No reference allele found in VariantContext");
        }
        long length = this.stop - this.start + 1L;
        if (this.getReference().isNull() && length != 1L || this.getReference().isNonNull() && length - (long)this.getReference().length() > 1L) {
            throw new IllegalStateException("BUG: GenomeLoc " + this.contig + ":" + this.start + "-" + this.stop + " has a size == " + length + " but the variation reference allele has length " + this.getReference().length() + " this = " + this);
        }
    }

    private void validateGenotypes() {
        if (this.genotypes == null) {
            throw new IllegalStateException("Genotypes is null");
        }
        for (Map.Entry<String, Genotype> elt : this.genotypes.entrySet()) {
            Genotype g;
            String name = elt.getKey();
            if (!name.equals((g = elt.getValue()).getSampleName())) {
                throw new IllegalStateException("Bound sample name " + name + " does not equal the name of the genotype " + g.getSampleName());
            }
            if (!g.isAvailable()) continue;
            for (Allele gAllele : g.getAlleles()) {
                if (this.hasAllele(gAllele) || !gAllele.isCalled()) continue;
                throw new IllegalStateException("Allele in genotype " + gAllele + " not in the variant context " + this.alleles);
            }
        }
    }

    private void determineType() {
        if (this.type == null) {
            switch (this.getNAlleles()) {
                case 0: {
                    throw new IllegalStateException("Unexpected error: requested type of VariantContext with no alleles!" + this);
                }
                case 1: {
                    this.type = Type.NO_VARIATION;
                    break;
                }
                default: {
                    this.determinePolymorphicType();
                }
            }
        }
    }

    private void determinePolymorphicType() {
        this.type = null;
        for (Allele allele : this.alleles) {
            if (allele == this.REF) continue;
            Type biallelicType = VariantContext.typeOfBiallelicVariant(this.REF, allele);
            if (this.type == null) {
                this.type = biallelicType;
                continue;
            }
            if (biallelicType == this.type) continue;
            this.type = Type.MIXED;
            return;
        }
    }

    private static Type typeOfBiallelicVariant(Allele ref, Allele allele) {
        if (ref.isSymbolic()) {
            throw new IllegalStateException("Unexpected error: encountered a record with a symbolic reference allele");
        }
        if (allele.isSymbolic()) {
            return Type.SYMBOLIC;
        }
        if (ref.length() == allele.length()) {
            if (allele.length() == 1) {
                return Type.SNP;
            }
            return Type.MNP;
        }
        return Type.INDEL;
    }

    public String toString() {
        return String.format("[VC %s @ %s of type=%s alleles=%s attr=%s GT=%s", new Object[]{this.getSource(), this.contig + ":" + (this.start - this.stop == 0L ? Long.valueOf(this.start) : this.start + "-" + this.stop), this.getType(), ParsingUtils.sortList(this.getAlleles()), ParsingUtils.sortedString(this.getAttributes()), this.getGenotypesSortedByName()});
    }

    private static LinkedHashSet<Allele> alleleCollectionToSet(LinkedHashSet<Allele> dest, Collection<Allele> alleles) {
        for (Allele a : alleles) {
            for (Allele b : dest) {
                if (!a.equals(b, true)) continue;
                throw new IllegalArgumentException("Duplicate allele added to VariantContext: " + a);
            }
            dest.add(a);
        }
        return dest;
    }

    public static Map<String, Genotype> genotypeCollectionToMap(Map<String, Genotype> dest, Collection<Genotype> genotypes) {
        for (Genotype g : genotypes) {
            if (dest.containsKey(g.getSampleName())) {
                throw new IllegalArgumentException("Duplicate genotype added to VariantContext: " + g);
            }
            dest.put(g.getSampleName(), g);
        }
        return dest;
    }

    public String getChr() {
        return this.contig;
    }

    public int getStart() {
        return (int)this.start;
    }

    public int getEnd() {
        return (int)this.stop;
    }

    private boolean hasSymbolicAlleles() {
        for (Allele a : this.getAlleles()) {
            if (!a.isSymbolic()) continue;
            return true;
        }
        return false;
    }

    public static VariantContext createVariantContextWithPaddedAlleles(VariantContext inputVC, boolean refBaseShouldBeAppliedToEndOfAlleles) {
        boolean padVC;
        long locLength = inputVC.getEnd() - inputVC.getStart() + 1;
        if (inputVC.hasSymbolicAlleles()) {
            padVC = true;
        } else if ((long)inputVC.getReference().length() == locLength) {
            padVC = false;
        } else if ((long)inputVC.getReference().length() == locLength - 1L) {
            padVC = true;
        } else {
            throw new IllegalArgumentException("Badly formed variant context at location " + String.valueOf(inputVC.getStart()) + " in contig " + inputVC.getChr() + ". Reference length must be at most one base shorter than location size");
        }
        if (padVC) {
            if (!inputVC.hasReferenceBaseForIndel()) {
                throw new ReviewedStingException("Badly formed variant context at location " + inputVC.getChr() + ":" + inputVC.getStart() + "; no padded reference base is available.");
            }
            Byte refByte = inputVC.getReferenceBaseForIndel();
            ArrayList<Allele> alleles = new ArrayList<Allele>();
            TreeMap<String, Genotype> genotypes = new TreeMap<String, Genotype>();
            Map<String, Genotype> inputGenotypes = inputVC.getGenotypes();
            for (Allele a : inputVC.getAlleles()) {
                if (a.isSymbolic()) {
                    alleles.add(a);
                    continue;
                }
                String newBases = refBaseShouldBeAppliedToEndOfAlleles ? a.getBaseString() + new String(new byte[]{refByte}) : new String(new byte[]{refByte}) + a.getBaseString();
                alleles.add(Allele.create(newBases, a.isReference()));
            }
            for (String sample : inputVC.getSampleNames()) {
                Genotype g = inputGenotypes.get(sample);
                List<Allele> inAlleles = g.getAlleles();
                ArrayList<Allele> newGenotypeAlleles = new ArrayList<Allele>();
                for (Allele a : inAlleles) {
                    if (a.isCalled()) {
                        if (a.isSymbolic()) {
                            newGenotypeAlleles.add(a);
                            continue;
                        }
                        String newBases = refBaseShouldBeAppliedToEndOfAlleles ? a.getBaseString() + new String(new byte[]{refByte}) : new String(new byte[]{refByte}) + a.getBaseString();
                        newGenotypeAlleles.add(Allele.create(newBases, a.isReference()));
                        continue;
                    }
                    newGenotypeAlleles.add(Allele.NO_CALL);
                }
                genotypes.put(sample, new Genotype(sample, newGenotypeAlleles, g.getNegLog10PError(), g.getFilters(), g.getAttributes(), g.isPhased()));
            }
            Set<String> inputVCFilters = inputVC.filtersWereAppliedToContext ? inputVC.getFilters() : null;
            return new VariantContext(inputVC.getSource(), inputVC.getChr(), (long)inputVC.getStart(), (long)inputVC.getEnd(), alleles, genotypes, inputVC.getNegLog10PError(), inputVCFilters, inputVC.getAttributes());
        }
        return inputVC;
    }

    public ArrayList<Allele> getTwoAllelesWithHighestAlleleCounts() {
        Allele alleleB;
        Allele alleleA;
        int maxAC1 = 0;
        int maxAC2 = 0;
        int maxAC1ind = 0;
        int maxAC2ind = 0;
        int i = 0;
        int[] alleleCounts = new int[this.getAlleles().size()];
        ArrayList<Allele> alleleArray = new ArrayList<Allele>();
        for (Allele a : this.getAlleles()) {
            int ac = this.getChromosomeCount(a);
            if (ac >= maxAC1) {
                maxAC1 = ac;
                maxAC1ind = i;
            }
            alleleArray.add(a);
            alleleCounts[i++] = ac;
        }
        for (i = 0; i < alleleCounts.length; ++i) {
            if (i == maxAC1ind || alleleCounts[i] < maxAC2) continue;
            maxAC2 = alleleCounts[i];
            maxAC2ind = i;
        }
        if (((Allele)alleleArray.get(maxAC1ind)).isReference()) {
            alleleA = (Allele)alleleArray.get(maxAC1ind);
            alleleB = (Allele)alleleArray.get(maxAC2ind);
        } else if (((Allele)alleleArray.get(maxAC2ind)).isReference()) {
            alleleA = (Allele)alleleArray.get(maxAC2ind);
            alleleB = (Allele)alleleArray.get(maxAC1ind);
        } else {
            alleleA = (Allele)alleleArray.get(maxAC1ind);
            alleleB = (Allele)alleleArray.get(maxAC2ind);
        }
        ArrayList<Allele> a = new ArrayList<Allele>();
        a.add(alleleA);
        a.add(alleleB);
        return a;
    }

    public Allele getAltAlleleWithHighestAlleleCount() {
        Allele best = null;
        int maxAC1 = 0;
        for (Allele a : this.getAlternateAlleles()) {
            int ac = this.getChromosomeCount(a);
            if (ac < maxAC1) continue;
            maxAC1 = ac;
            best = a;
        }
        return best;
    }

    public int[] getGLIndecesOfAllele(Allele inputAllele) {
        int numAlleles;
        int[] idxVector = new int[3];
        int idxDiag = numAlleles = this.getAlleles().size();
        int incr = numAlleles - 1;
        int k = 1;
        for (Allele a : this.getAlternateAlleles()) {
            int idxAA = 0;
            int idxAB = k++;
            int idxBB = idxDiag;
            if (a.equals(inputAllele)) {
                idxVector[0] = idxAA;
                idxVector[1] = idxAB;
                idxVector[2] = idxBB;
                break;
            }
            idxDiag += incr--;
        }
        return idxVector;
    }

    public static enum Type {
        NO_VARIATION,
        SNP,
        MNP,
        INDEL,
        SYMBOLIC,
        MIXED;

    }
}

