/*  ranopts.h

    Tim Behrens & Steve Smith (FMRIB) & Tom Nichols (UMich)

    Copyright (C) 2004 University of Oxford  */

/*  Part of FSL - FMRIB's Software Library
    http://www.fmrib.ox.ac.uk/fsl
    fsl@fmrib.ox.ac.uk
    
    Developed at FMRIB (Oxford Centre for Functional Magnetic Resonance
    Imaging of the Brain), Department of Clinical Neurology, Oxford
    University, Oxford, UK
    
    
    LICENCE
    
    FMRIB Software Library, Release 4.0 (c) 2007, The University of
    Oxford (the "Software")
    
    The Software remains the property of the University of Oxford ("the
    University").
    
    The Software is distributed "AS IS" under this Licence solely for
    non-commercial use in the hope that it will be useful, but in order
    that the University as a charitable foundation protects its assets for
    the benefit of its educational and research purposes, the University
    makes clear that no condition is made or to be implied, nor is any
    warranty given or to be implied, as to the accuracy of the Software,
    or that it will be suitable for any particular purpose or for use
    under any specific conditions. Furthermore, the University disclaims
    all responsibility for the use which is made of the Software. It
    further disclaims any liability for the outcomes arising from using
    the Software.
    
    The Licensee agrees to indemnify the University and hold the
    University harmless from and against any and all claims, damages and
    liabilities asserted by third parties (including claims for
    negligence) which arise directly or indirectly from the use of the
    Software or the sale of any products based on the Software.
    
    No part of the Software may be reproduced, modified, transmitted or
    transferred in any form or by any means, electronic or mechanical,
    without the express permission of the University. The permission of
    the University is not required if the said reproduction, modification,
    transmission or transference is done without financial return, the
    conditions of this Licence are imposed upon the receiver of the
    product, and all original and amended source code is included in any
    transmitted product. You may be held legally responsible for any
    copyright infringement that is caused or encouraged by your failure to
    abide by these terms and conditions.
    
    You are not permitted under this Licence to use this Software
    commercially. Use for which any financial return is received shall be
    defined as commercial use, and includes (1) integration of all or part
    of the source code or the Software into a product for sale or license
    by or on behalf of Licensee to third parties or (2) use of the
    Software or any derivative of it for research with the final aim of
    developing software products for sale or license to a third party or
    (3) use of the Software or any derivative of it for research with the
    final aim of developing non-software products for sale or license to a
    third party, or (4) use of the Software to provide any service to an
    external organisation for which payment is received. If you are
    interested in using the Software commercially, please contact Isis
    Innovation Limited ("Isis"), the technology transfer company of the
    University, to negotiate a licence. Contact details are:
    innovation@isis.ox.ac.uk quoting reference DE/1112. */

#if !defined(ranopts_h)
#define ranopts_h

#include <string>
#include <iostream>
#include <fstream>
#include <stdlib.h>
#include <stdio.h>
#include "utils/options.h"
#include "utils/log.h"


using namespace Utilities;

namespace RANDOMISE {

class ranopts {
 public:
  static ranopts& getInstance();
  ~ranopts() { delete gopt; }
  
  Option<bool> demean_data;
  Option<bool> one_samp;
  Option<bool> low_ram;
  Option<string> in_fileroot;
  Option<string> maskname;
  Option<string> out_fileroot;
  Option<string> dm_file;
  Option<string> tc_file;
  Option<string> fc_file;
  Option<string> gp_file;
  Option<bool> how_many_perms;
  Option<int> n_perm;
  Option<float> cluster_thresh;
  Option<float> clustermass_thresh;
  Option<float> f_thresh;
  Option<float> fmass_thresh;
  Option<bool> tfce;
  Option<float> tfce_height;
  Option<float> tfce_size;
  Option<int> tfce_connectivity;
  Option<float> var_sm_sig;
  Option<bool> help;
  Option<bool> verbose;
  Option<bool> cluster_norm;
  Option<string> logdir;
  Option<string> confound_file;
  void parse_command_line(int argc, char** argv,Log& logger);
  
 private:
  ranopts();  
  const ranopts& operator=(ranopts&);
  ranopts(ranopts&);

  OptionParser options; 
      
  static ranopts* gopt;
  
};

 inline ranopts& ranopts::getInstance(){
   if(gopt == NULL)
     gopt = new ranopts();
   
   return *gopt;
 }

 inline ranopts::ranopts() :
   demean_data(string("-D"), false,
	string("\tdemean data temporally before model fitting"),
	false, no_argument),
   one_samp(string("-1"), false,
	    string("\tperform 1-sample group-mean test instead of generic permutation test"),
	    false, no_argument),
   low_ram(string("-M"), false,
	string("\tminimise memory usage during load (uses less total RAM but is slower)"),
	false, no_argument),
   in_fileroot(string("-i"), "",
       string("~<in_root>\t4D input image"),
       true, requires_argument),
   maskname(string("-m"), "",
       string("~<mask>\tmask image"),
       false, requires_argument),
   out_fileroot(string("-o"), string(""),
	    string("~<out_root>\toutput file root"),
	    true, requires_argument),  
   dm_file(string("-d"), string(""),
	    string("~<design.mat>\tdesign matrix file"),
	    false, requires_argument),  
   tc_file(string("-t"), string(""),
	    string("~<design.con>\tt contrasts file"),
	    false, requires_argument),  
   fc_file(string("-f"), string(""),
            string("~<design.fts>\tf contrasts file"),
	   false, requires_argument),  
   gp_file(string("-g"), string(""),
            string("~<design.grp>\tgroup labels file"),
	   false, requires_argument),  
   how_many_perms(string("-q"), false,
	    string("\tprint out how many unique permutations would be generated and exit"),
	    false, no_argument),  
   n_perm(string("-n"), 5000,
	    string("~<n_perm>\tnumber of permutations (default 5000, set to 0 for exhaustive)"),
	    false, requires_argument),  
   cluster_thresh(string("-c"), -1,
	  string("~<thresh>\tcarry out cluster-based thresholding (as well as max and voxelwise)"),
	  false, requires_argument),
   clustermass_thresh(string("-C"), -1,
	  string("~<thresh>\tcarry out cluster-mass-based thresholding (as well as max and voxelwise)"),
	  false, requires_argument),
   f_thresh(string("-F"), -1,
	  string("~<thresh>\tcarry out f cluster thresholding (as well as max and voxelwise)"),
	  false, requires_argument),
   fmass_thresh(string("-S"), -1,
	  string("~<thresh>\tcarry out f cluster-mass thresholding (as well as max and voxelwise)"),
	  false, requires_argument),
   tfce(string("-T"), false, 
	   string("\tcarry out Threshold-Free Cluster Enhancement"), 
	   false, no_argument),
   tfce_height(string("--tfce_H"), 2, string("~<H>\tTFCE height parameter (default=2)"), false, requires_argument),
   tfce_size(string("--tfce_E"), 0.5, string("~<E>\tTFCE extent parameter (default=0.5)"), false, requires_argument),
   tfce_connectivity(string("--tfce_C"), 26, string("~<C>\tTFCE connectivity (6 or 26; default=26)"), false, requires_argument),
   var_sm_sig(string("-v"), 0,
	    string("~<std>\tuse variance smoothing (std is in mm)"),
	     false, requires_argument),
   help(string("-h,--help"), false,
	string("display this message"),
	false, no_argument),
   verbose(string("-V"), false, 
	   string("\tswitch on diagnostic messages and null distribution text files"),
	   false, no_argument),
   cluster_norm(string("-N"), false, 
	   string("carry out cluster normalisation thresholding"), 
		false, no_argument,false),
   logdir(string("-l"), string("logdir"),
	    string("~<logdir>\tlog directory"),
	  false, requires_argument,false),  
   confound_file(string("-x"), string(""),
	    string("~<xdesign.mat>\tconfound matrix file"),
		 false, requires_argument,false),  



   options("randomise v2.0", "randomise -i <input> -o <output> -d <design.mat> -t <design.con> [options]")
     {
    
     try {
       options.add(demean_data);
       options.add(one_samp);
       options.add(low_ram);
       options.add(in_fileroot);
       options.add(maskname);
       options.add(out_fileroot);
       options.add(dm_file);
       options.add(tc_file);
       options.add(fc_file);
       options.add(gp_file);
       options.add(how_many_perms);
       options.add(n_perm);    
       options.add(cluster_thresh);
       options.add(clustermass_thresh);
       options.add(f_thresh);     
       options.add(fmass_thresh);     
       options.add(tfce);
       options.add(tfce_height);     
       options.add(tfce_size);     
       options.add(tfce_connectivity);  
       options.add(var_sm_sig);
       options.add(help);
       options.add(verbose);
       options.add(cluster_norm);
       options.add(logdir);
       options.add(confound_file);
     }
     catch(X_OptionError& e) {
       options.usage();
       cerr << endl << e.what() << endl;
     } 
     catch(std::exception &e) {
       cerr << e.what() << endl;
     }    
     
   }
}

#endif

