/*
 * Decompiled with CFR 0.152.
 */
package apollo.util;

import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import apollo.util.HTMLUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class FastaHeader {
    private StringBuffer description;
    private String seq_id;
    private String db;
    private String organism;
    private HashMap xrefs;

    public FastaHeader(String fasta_header) {
        try {
            this.parseHeader(fasta_header);
        }
        catch (Exception e) {
            System.err.println("Error parsing " + fasta_header);
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.seq_id == null) {
                this.seq_id = "unknown";
            }
            this.db = "";
        }
    }

    public String getSeqId() {
        return this.seq_id;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description.toString();
        }
        return "";
    }

    public String getDatabase() {
        return this.db;
    }

    public HashMap getDbXrefs() {
        return this.xrefs;
    }

    public String getOrganism() {
        return this.organism;
    }

    public SequenceI generateSequence() {
        Sequence sequence = new Sequence(this.getSeqId(), "");
        sequence.setDescription(this.getDescription());
        sequence.setOrganism(this.getOrganism());
        if (!this.getDatabase().equals("")) {
            sequence.addDbXref(this.getDatabase(), this.getSeqId());
        }
        if (this.xrefs != null) {
            Iterator keys = this.xrefs.keySet().iterator();
            while (keys.hasNext()) {
                String xref_db = (String)keys.next();
                String acc = (String)this.xrefs.get(xref_db);
                sequence.addDbXref(xref_db, acc);
            }
        }
        return sequence;
    }

    private void parseHeader(String fasta_header) {
        int index_last;
        String info;
        int index_first;
        if (fasta_header == null) {
            return;
        }
        boolean debug = false;
        if (fasta_header.length() > 1 && fasta_header.charAt(0) == '>') {
            fasta_header = fasta_header.substring(1);
        }
        this.description = new StringBuffer();
        this.seq_id = "";
        this.db = "";
        this.organism = null;
        this.xrefs = null;
        int index = fasta_header.indexOf(32);
        if (index > 0) {
            this.description.append(fasta_header.substring(index).trim());
            fasta_header = fasta_header.substring(0, index);
        }
        while (fasta_header.lastIndexOf(124) == fasta_header.length() - 1) {
            fasta_header = fasta_header.substring(0, fasta_header.length() - 1);
        }
        Vector words = new Vector();
        while (fasta_header.length() > 0) {
            index = fasta_header.indexOf(124);
            if (index < 0) {
                if (debug) {
                    System.out.println("FastaHeader: Pushing last word " + fasta_header);
                }
                FastaHeader.addWord(fasta_header, words);
                fasta_header = "";
                continue;
            }
            if (index > 0) {
                if (debug) {
                    System.out.println("FastaHeader: Pushing next word " + fasta_header.substring(0, index));
                }
                FastaHeader.addWord(fasta_header.substring(0, index), words);
            }
            if (fasta_header.length() <= ++index) continue;
            fasta_header = fasta_header.substring(index);
        }
        if (debug) {
            System.out.println("FastaHeader: found " + words.size() + " words");
        }
        if (words.size() == 1) {
            this.seq_id = (String)words.elementAt(0);
            if (this.seq_id.startsWith("BcDNA:")) {
                this.seq_id = this.seq_id.substring("BcDNA:".length());
            }
        } else if (words.size() == 2) {
            this.db = (String)words.elementAt(0);
            this.seq_id = (String)words.elementAt(1);
        } else {
            int i;
            index = 0;
            int word_count = words.size();
            for (i = 0; i < word_count; ++i) {
                String word_2;
                String word_1 = (String)words.elementAt(i);
                String string = word_2 = i + 1 < word_count ? (String)words.elementAt(i + 1) : null;
                if (debug) {
                    System.out.println("FastaHeader: word_1 = " + word_1 + ", word_2 = " + word_2);
                }
                if (!this.isDatabaseName(word_1) || word_2 == null || this.isDatabaseName(word_2)) continue;
                if (this.seq_id.equals("")) {
                    if (!word_1.equalsIgnoreCase("bdgp")) {
                        this.db = word_1.equalsIgnoreCase("embl") ? "emb" : word_1;
                    }
                    index = i + 1;
                    this.seq_id = word_2;
                } else if (!word_1.equalsIgnoreCase("bdgp")) {
                    String xref_db = word_1.equalsIgnoreCase("embl") ? "emb" : word_1;
                    index = i + 1;
                    String acc = word_2;
                    if (this.xrefs == null) {
                        this.xrefs = new HashMap(1);
                    }
                    this.xrefs.put(xref_db, acc);
                } else {
                    if (this.xrefs == null) {
                        this.xrefs = new HashMap(1);
                    }
                    this.xrefs.put(this.db, this.seq_id);
                    this.db = "";
                    index = i + 1;
                    this.seq_id = word_2;
                }
                if (!debug) continue;
                System.out.println("FastaHeader: seq_id is " + this.seq_id + " for db " + this.db);
            }
            if (this.seq_id.equals("")) {
                index = 0;
                if (word_count % 2 == 0) {
                    this.db = (String)words.elementAt(index++);
                    this.seq_id = (String)words.elementAt(index);
                } else {
                    this.seq_id = (String)words.elementAt(index);
                }
            }
            for (i = index + 1; i < word_count; ++i) {
                this.description.append(" " + (String)words.elementAt(i));
            }
        }
        this.seq_id = HTMLUtil.replaceSGMLWithGreekLetter(this.seq_id);
        String prior_desc = this.description.toString();
        String cleaned_up = HTMLUtil.replaceSGMLWithGreekLetter(prior_desc);
        boolean changed = false;
        while (!cleaned_up.equals(prior_desc)) {
            prior_desc = cleaned_up;
            cleaned_up = HTMLUtil.replaceSGMLWithGreekLetter(prior_desc);
            changed = true;
        }
        if (changed) {
            this.description = new StringBuffer(cleaned_up);
        }
        if ((index_first = (info = this.description.toString()).toLowerCase().indexOf("organism:\"")) >= 0 && (index_last = info.indexOf("\"", index_first += "organism:\"".length())) > index_first) {
            this.organism = info.substring(index_first, index_last);
        }
    }

    private boolean isDatabaseName(String word) {
        return word != null && (word.equalsIgnoreCase("bdgp") || word.equalsIgnoreCase("gb") || word.equalsIgnoreCase("ref") || word.equalsIgnoreCase("emb") || word.equalsIgnoreCase("embl") || word.equalsIgnoreCase("ug") || word.equalsIgnoreCase("sptr") || word.equalsIgnoreCase("sp") || word.equalsIgnoreCase("sreal") || word.equalsIgnoreCase("fb"));
    }

    private static void addWord(String word, Vector words) {
        if (!word.equalsIgnoreCase("gi") && !word.equalsIgnoreCase("gnl")) {
            if (word.charAt(word.length() - 1) == ';') {
                word = word.substring(0, word.length() - 1);
            }
            words.addElement(word);
        }
    }
}

