/*
 * Decompiled with CFR 0.152.
 */
package apollo.seq.io;

import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.io.FileParse;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class GFFFile
extends FileParse {
    int noSeqs;
    int maxLength = 0;
    public Vector seqs = new Vector();
    long start;
    long end;

    public GFFFile(DataInputStream in) {
        this.lineArray = new Vector();
        try {
            String data;
            while ((data = in.readLine()) != null) {
                this.lineArray.addElement(data);
            }
        }
        catch (IOException ioex) {
            System.out.println("Exception " + ioex);
        }
        this.parse();
    }

    public GFFFile(String inStr) {
        this.readLines(inStr);
        this.parse();
    }

    public FeatureSetI getFeatures() {
        FeatureSet fset = new FeatureSet();
        for (int i = 0; i < this.seqs.size(); ++i) {
            fset.addFeature((SeqFeatureI)this.seqs.elementAt(i));
        }
        return fset;
    }

    public GFFFile(String inFile, String type) throws IOException {
        super(inFile, type);
        System.out.println("Reading Ensembl-style GFF file " + inFile + "....");
        this.start = System.currentTimeMillis();
        this.readLines();
        this.end = System.currentTimeMillis();
        this.start = System.currentTimeMillis();
        this.parse();
    }

    public void parse() {
        for (int i = 0; i < this.lineArray.size(); ++i) {
            StringTokenizer st;
            String line = (String)this.lineArray.elementAt(i);
            if (line.indexOf("#") != -1 || (st = new StringTokenizer(line, "\t")).countTokens() < 8) continue;
            try {
                String s = st.nextToken();
                String type = st.nextToken();
                String prim = st.nextToken();
                int qstart = Integer.parseInt(st.nextToken());
                int qend = Integer.parseInt(st.nextToken());
                double score = 0.0;
                try {
                    score = Double.valueOf(st.nextToken());
                }
                catch (Exception e) {
                    System.out.println("Error parsing score : " + e);
                }
                String strand = st.nextToken();
                String frame = st.nextToken();
                String id = prim;
                SeqFeature se = new SeqFeature(qstart, qend, id);
                if (strand.equals("-")) {
                    se.setStrand(-1);
                } else {
                    se.setStrand(1);
                }
                se.setFeatureType(type);
                se.setScore(score);
                se.setName(s);
                se.setId(s);
                if (!frame.equals(".")) {
                    se.setPhase(Integer.parseInt(frame));
                }
                if (st.hasMoreTokens() && prim.equals("similarity")) {
                    try {
                        String htok = st.nextToken("");
                        StringTokenizer sth = new StringTokenizer(htok);
                        String hid = sth.nextToken();
                        int hstart = Integer.parseInt(sth.nextToken());
                        int hend = Integer.parseInt(sth.nextToken());
                        int hitStrand = 0;
                        SeqFeature f2 = null;
                        if (hstart < hend) {
                            hitStrand = 1;
                            f2 = new SeqFeature(hstart, hend, hid, hitStrand);
                        } else {
                            hitStrand = -1;
                            f2 = new SeqFeature(hend, hstart, hid, hitStrand);
                        }
                        f2.setName(hid);
                        f2.setId(hid);
                        se.setId(hid);
                        FeaturePair fp = new FeaturePair(se, f2);
                        this.seqs.addElement(fp);
                    }
                    catch (Exception e) {
                        System.out.println("Can't add line - " + line + " " + e);
                    }
                    continue;
                }
                if (st.hasMoreTokens() && prim.equals("exon")) {
                    String hid = st.nextToken("\t");
                    se.setName(hid);
                    se.setId(hid);
                    this.seqs.addElement(se);
                    continue;
                }
                if (prim.equals("intron") || prim.equals("sequence") || prim.equals("coding_exon")) continue;
                this.seqs.addElement(se);
                continue;
            }
            catch (NumberFormatException nfe) {
                System.out.println("NumberFormatException " + nfe);
                System.out.println("ERROR: parsing line " + line);
            }
        }
        this.noSeqs = this.seqs.size();
    }

    public static String print(FeatureSetI set) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < set.size(); ++i) {
            SeqFeatureI sf = set.getFeatureAt(i);
            if (sf.canHaveChildren()) {
                FeatureSetI fs = (FeatureSetI)sf;
                out.append(GFFFile.print(fs));
                continue;
            }
            if (sf instanceof FeaturePair) {
                FeaturePair fp = (FeaturePair)sf;
                String strand = ".";
                if (fp.getStrand() == 1) {
                    strand = "+";
                } else if (fp.getStrand() == -1) {
                    strand = "-";
                }
                out.append(fp.getId() + "\t" + fp.getFeatureType() + "\tsimilarity\t" + fp.getLow() + "\t" + fp.getHigh() + "\t" + fp.getScore() + "\t" + strand + "\t.\t" + fp.getHname() + "\t" + fp.getHstart() + "\t" + fp.getHend() + "\n");
                continue;
            }
            String strand = ".";
            if (sf.getStrand() == 1) {
                strand = "+";
            } else if (sf.getStrand() == -1) {
                strand = "-";
            }
            String type = sf.getFeatureType();
            if (type.equals("")) {
                type = "unknown_type";
            }
            out.append(sf.getId() + "\t" + type + "\texon\t" + sf.getLow() + "\t" + sf.getHigh() + "\t" + sf.getScore() + "\t" + strand + "\t.");
            if (sf.getRefId() != null) {
                out.append("\t" + sf.getRefId() + "\n");
                continue;
            }
            out.append("\n");
        }
        return out.toString();
    }
}

