/*
 * Decompiled with CFR 0.152.
 */
package apollo.main;

import apollo.config.Config;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInput;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.chado.ChadoAdapter;
import com.townleyenterprises.command.CommandListener;
import com.townleyenterprises.command.CommandOption;
import com.townleyenterprises.command.CommandParser;
import com.townleyenterprises.command.DefaultCommandListener;
import com.townleyenterprises.command.OptionConstraint;
import com.townleyenterprises.command.RequiresAnyOptionConstraint;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bdgp.io.DataAdapterRegistry;

public class CommandLine {
    private static final String GAME = (class$apollo$dataadapter$gamexml$GAMEAdapter == null ? (class$apollo$dataadapter$gamexml$GAMEAdapter = CommandLine.class$("apollo.dataadapter.gamexml.GAMEAdapter")) : class$apollo$dataadapter$gamexml$GAMEAdapter).getName();
    private static final String CHADOXML = (class$apollo$dataadapter$chadoxml$ChadoXmlAdapter == null ? (class$apollo$dataadapter$chadoxml$ChadoXmlAdapter = CommandLine.class$("apollo.dataadapter.chadoxml.ChadoXmlAdapter")) : class$apollo$dataadapter$chadoxml$ChadoXmlAdapter).getName();
    private static final String CHADO_JDBC = (class$apollo$dataadapter$chado$ChadoAdapter == null ? (class$apollo$dataadapter$chado$ChadoAdapter = CommandLine.class$("apollo.dataadapter.chado.ChadoAdapter")) : class$apollo$dataadapter$chado$ChadoAdapter).getName();
    private static final String SERIALIZED = (class$apollo$dataadapter$SerialDiskAdapter == null ? (class$apollo$dataadapter$SerialDiskAdapter = CommandLine.class$("apollo.dataadapter.SerialDiskAdapter")) : class$apollo$dataadapter$SerialDiskAdapter).getName();
    private static final String GFF = (class$apollo$dataadapter$GFFAdapter == null ? (class$apollo$dataadapter$GFFAdapter = CommandLine.class$("apollo.dataadapter.GFFAdapter")) : class$apollo$dataadapter$GFFAdapter).getName();
    private static final String GENBANK = (class$apollo$dataadapter$genbank$GenbankAdapter == null ? (class$apollo$dataadapter$genbank$GenbankAdapter = CommandLine.class$("apollo.dataadapter.genbank.GenbankAdapter")) : class$apollo$dataadapter$genbank$GenbankAdapter).getName();
    private static final String DAS2 = (class$apollo$dataadapter$das2$DAS2Adapter == null ? (class$apollo$dataadapter$das2$DAS2Adapter = CommandLine.class$("apollo.dataadapter.das2.DAS2Adapter")) : class$apollo$dataadapter$das2$DAS2Adapter).getName();
    private IOOptions readOptions;
    private IOOptions writeOptions;
    private CommandParser parser;
    private InputFormatCommandOption inputFmtOption = new InputFormatCommandOption();
    private OutputFormatCommandOption outputFmtOption = new OutputFormatCommandOption();
    private CommandOption locationOption = new LocationCommandOption();
    private CommandOption inputFileOption = new InputFileCommandOption();
    private CommandOption gameFileOption = new GameFileCommandOption();
    private CommandOption backupFileOption = new BackupFileCommandOption();
    private CommandOption writeFile = new WriteFileCommandOption();
    private CommandOption inputListFileOption = new InputListFileCommandOption();
    private CommandOption skipExistBatchEntry = new SkipExistBatchEntryCommandOption();
    private InputTypeCommandOption inputTypeOption = new InputTypeCommandOption();
    private CommandOption dbPassOption = new DbPassCommandOption();
    private CommandOption inputFilesList = new InputFilesListCommandOption();
    private boolean isBatchMode = false;
    private BatchFile batchFile;
    private static final String seqHelp = "Specify FASTA sequence file to load with gff file";
    CommandOption seqFileOption = new CommandOption("sequenceFile", 's', true, "sequence_file", "Specify FASTA sequence file to load with gff file");
    CommandOption[] options = new CommandOption[]{this.inputFmtOption, this.inputFileOption, this.locationOption, this.gameFileOption, this.backupFileOption, this.seqFileOption, this.outputFmtOption, this.writeFile, this.inputListFileOption, this.skipExistBatchEntry, this.inputTypeOption, this.dbPassOption, this.inputFilesList};
    private static CommandLine commandLineSingleton;
    static /* synthetic */ Class class$apollo$dataadapter$gamexml$GAMEAdapter;
    static /* synthetic */ Class class$apollo$dataadapter$chadoxml$ChadoXmlAdapter;
    static /* synthetic */ Class class$apollo$dataadapter$chado$ChadoAdapter;
    static /* synthetic */ Class class$apollo$dataadapter$SerialDiskAdapter;
    static /* synthetic */ Class class$apollo$dataadapter$GFFAdapter;
    static /* synthetic */ Class class$apollo$dataadapter$genbank$GenbankAdapter;
    static /* synthetic */ Class class$apollo$dataadapter$das2$DAS2Adapter;

    public static CommandLine getCommandLine() {
        if (commandLineSingleton == null) {
            commandLineSingleton = new CommandLine();
        }
        return commandLineSingleton;
    }

    private CommandLine() {
    }

    public void setArgs(String[] args) throws ApolloAdapterException {
        if (args.length == 0) {
            return;
        }
        this.processArgs(args);
    }

    private void processArgs(String[] args) throws ApolloAdapterException {
        this.parser = new CommandParser("Apollo");
        this.parser.addCommandListener((CommandListener)new DefaultCommandListener("Options", this.options));
        this.parser.parse(args);
        this.addConstraints(this.parser);
        try {
            this.parser.executeCommands();
        }
        catch (Exception e) {
            throw new ApolloAdapterException(e);
        }
    }

    private void addConstraints(CommandParser parser) {
        CommandOption[] inFmtDep = new CommandOption[]{this.inputFmtOption};
        parser.addConstraint((OptionConstraint)new RequiresAnyOptionConstraint(-2, this.locationOption, inFmtDep));
    }

    private IOOptions getReadOptions() {
        if (this.readOptions == null) {
            this.readOptions = new IOOptions(true);
        }
        return this.readOptions;
    }

    private IOOptions getWriteOptions() {
        if (this.writeOptions == null) {
            this.writeOptions = new IOOptions(false);
        }
        return this.writeOptions;
    }

    boolean readIsSpecified() {
        return this.getReadOptions().getSpecifiedState();
    }

    boolean writeIsSpecified() {
        return this.getWriteOptions().getSpecifiedState();
    }

    public static boolean isInCommandLineMode() {
        CommandLine cl = CommandLine.getCommandLine();
        return cl.writeIsSpecified() || cl.isBatchMode();
    }

    private boolean haveReadAdapter() throws Exception {
        return this.getReadAdapter() != null;
    }

    private boolean haveInputType() throws Exception {
        return this.inputTypeOption.haveType();
    }

    ApolloDataAdapterI getReadAdapter() throws Exception {
        return this.getReadOptions().getAdapter();
    }

    ApolloDataAdapterI getWriteAdapter() throws ApolloAdapterException {
        try {
            return this.getWriteOptions().getAdapter();
        }
        catch (Exception e) {
            throw new ApolloAdapterException(e);
        }
    }

    private ApolloDataAdapterI getDataAdapter(String classString) {
        DataAdapterRegistry dar = Config.getAdapterRegistry();
        ApolloDataAdapterI a = (ApolloDataAdapterI)dar.getAdapter(classString);
        if (a == null) {
            String e = classString + " is not in adapterRegistry. check apollo.cfg";
            throw new RuntimeException(e);
        }
        return a;
    }

    protected void printHelp() {
        this.parser.help();
    }

    private void error(String m) throws Exception {
        System.out.println(m);
        this.printHelp();
        throw new Exception(m);
    }

    private boolean haveSequenceFilename() {
        return this.seqFileOption.getMatched();
    }

    private String getSequenceFilename() {
        return this.seqFileOption.getArg();
    }

    private void setAdapterForFile(IOOptions options) throws Exception {
        ApolloDataAdapterI adapter = this.getAdapterForFile(options);
        if (!options.hasAdapter()) {
            options.setAdapter(adapter);
        }
        String inputFile = options.getFilename();
        DataInputType inputType = DataInputType.FILE;
        if (inputFile.startsWith("http:") || inputFile.startsWith("file:")) {
            inputType = DataInputType.URL;
        }
        DataInput di = new DataInput(inputType, inputFile);
        if (this.haveSequenceFilename()) {
            di.setSequenceFilename(this.getSequenceFilename());
        }
        adapter.setDataInput(di);
        options.setDataInput(di);
        options.setSpecifiedState(true);
    }

    private IOOptions getDbIOOptions() throws Exception {
        if (!this.getReadOptions().hasAdapter()) {
            this.getReadOptions().setAdapter(this.inputFmtOption.getAdapter());
        }
        if (!this.getWriteOptions().hasAdapter()) {
            this.getWriteOptions().setAdapter(this.outputFmtOption.getAdapter());
        }
        if (this.getReadAdapter() instanceof ChadoAdapter) {
            return this.getReadOptions();
        }
        if (this.getWriteAdapter() instanceof ChadoAdapter) {
            return this.getWriteOptions();
        }
        throw new Exception("Unable to find a database (ie chadoDB) for either input or output");
    }

    private ApolloDataAdapterI getAdapterForFile(IOOptions options) throws Exception {
        if (options.hasAdapter()) {
            return options.getAdapter();
        }
        ApolloDataAdapterI adapter = this.getDataAdapterFromSuffix(options.getFilename());
        if (adapter == null) {
            this.error("\nNo input format specified and can't determine it from suffix " + this.getFileSuffix(options.getFilename()));
        }
        return adapter;
    }

    private ApolloDataAdapterI getDataAdapterFromSuffix(String filename) {
        String suffix = this.getFileSuffix(filename);
        if (suffix.matches(".*game.*")) {
            return this.getDataAdapter(GAME);
        }
        if (suffix.matches(".*chado.*") || filename.matches(".*chado.*")) {
            return this.getDataAdapter(CHADOXML);
        }
        if (suffix.equalsIgnoreCase("gff")) {
            return this.getDataAdapter(GFF);
        }
        if (suffix.matches("gbk?|genbank")) {
            return this.getDataAdapter(GENBANK);
        }
        if (suffix.matches("backup|ser")) {
            return this.getDataAdapter(SERIALIZED);
        }
        if (suffix.matches(".*das2.*")) {
            return this.getDataAdapter(DAS2);
        }
        if (suffix.equals("xml") && this.xmlSuffixIsConfigged()) {
            return this.getConfiggedXmlDataAdapter();
        }
        return null;
    }

    private ApolloDataAdapterI getAdapterForString(String adapString) throws Exception {
        if ((adapString = adapString.toLowerCase()).equalsIgnoreCase("chadoDB")) {
            return this.getDataAdapter(CHADO_JDBC);
        }
        if (adapString.matches("game|gamexml|gameXML")) {
            return this.getDataAdapter(GAME);
        }
        if (adapString.matches("chado|chadoxml|chadoXML")) {
            return this.getDataAdapter(CHADOXML);
        }
        if (adapString.matches("backup|serialized|serial")) {
            return this.getDataAdapter(SERIALIZED);
        }
        if (adapString.equalsIgnoreCase("gff")) {
            return this.getDataAdapter(GFF);
        }
        if (adapString.matches("genbank|gb")) {
            return this.getDataAdapter(GENBANK);
        }
        if (adapString.toLowerCase().startsWith("das")) {
            return this.getDataAdapter(DAS2);
        }
        this.error("Don't recognize input/output format " + adapString);
        return null;
    }

    private String getFileSuffix(String filename) {
        int index = filename.lastIndexOf(46);
        return filename.substring(index + 1);
    }

    private boolean xmlSuffixIsConfigged() {
        return Config.commandLineXmlFileFormatIsConfigged();
    }

    private ApolloDataAdapterI getConfiggedXmlDataAdapter() {
        String config = Config.getCommandLineXmlFileFormat();
        if (config.equalsIgnoreCase("game")) {
            return this.getDataAdapter(GAME);
        }
        if (config.equalsIgnoreCase("chado")) {
            return this.getDataAdapter(CHADOXML);
        }
        return null;
    }

    private void setReadFileAdapter(String adapterClass, String filename) {
        ApolloDataAdapterI adapter = this.getDataAdapter(adapterClass);
        this.getReadOptions().setAdapter(adapter);
        DataInput di = new DataInput(DataInputType.FILE, filename);
        adapter.setDataInput(di);
        this.getReadOptions().setDataInput(di);
        this.getReadOptions().setSpecifiedState(true);
    }

    boolean isBatchMode() {
        return this.isBatchMode;
    }

    boolean hasMoreBatchEntries() {
        if (this.batchFile == null) {
            return false;
        }
        return this.batchFile.hasMoreBatchEntries();
    }

    void setToNextBatchEntry() throws Exception {
        this.batchFile.setToNextBatchEntry();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class BatchInputFile
    extends BatchFile {
        private BatchInputFile(String batchFilename) throws FileNotFoundException, IOException {
            super(batchFilename);
        }

        void parseBatchFile() throws FileNotFoundException, IOException {
            String line = this.getReader().readLine();
            while (line != null) {
                BatchEntry entry = new BatchEntry(line);
                if (entry.isValid()) {
                    this.getEntryList().add(entry);
                }
                line = this.getReader().readLine();
            }
        }

        void setToNextBatchEntry() throws Exception {
            BatchEntry entry = (BatchEntry)this.getNextBatchEntry();
            System.out.println("Loading " + entry.getEntry());
            CommandLine.this.getReadAdapter().setDataInput(entry.makeDataInput(DataInputType.FILE));
            CommandLine.this.getReadOptions().setFilename(entry.getFilename());
            CommandLine.this.setAdapterForFile(CommandLine.this.getReadOptions());
        }

        private class BatchEntry
        extends BatchFile.BatchEntry {
            private BatchEntry(String line) {
                this.parseLine(line);
            }

            private BatchEntry() {
            }

            void parseLine(String line) {
                String[] splitLine = line.split("\\s+");
                if (splitLine.length == 0) {
                    System.out.println("Ignoring line " + BatchInputFile.this.getLineNumber() + " failed to parse " + line);
                    return;
                }
                String s1 = splitLine[0].trim();
                if (s1 != null && !s1.equals("")) {
                    this.setFilename(this.addCurrentDirIfNoDir(s1));
                    this.setValid(true);
                }
            }

            DataInput makeDataInput(DataInputType dt) {
                return new DataInput(dt, this.getEntry());
            }
        }
    }

    private class BatchFile {
        private List entryList;
        private Iterator batchFileIterator = null;
        private LineNumberReader reader;

        private BatchFile(String batchFilename) throws FileNotFoundException, IOException {
            this.init(batchFilename);
        }

        private void init(String filename) throws FileNotFoundException, IOException {
            this.reader = new LineNumberReader(new FileReader(filename));
            this.parseBatchFile();
        }

        void parseBatchFile() throws FileNotFoundException, IOException {
            String line = this.reader.readLine();
            while (line != null) {
                BatchEntry entry = new BatchEntry(line);
                if (entry.isValid()) {
                    this.getEntryList().add(entry);
                }
                line = this.reader.readLine();
            }
        }

        List getEntryList() {
            if (this.entryList == null) {
                this.entryList = new ArrayList();
            }
            return this.entryList;
        }

        private boolean hasMoreBatchEntries() {
            if (this.entryList == null) {
                return false;
            }
            if (this.batchFileIterator == null) {
                this.batchFileIterator = this.entryList.iterator();
            }
            if (!this.batchFileIterator.hasNext()) {
                this.batchFileIterator = null;
                return false;
            }
            return this.batchFileIterator.hasNext();
        }

        void setToNextBatchEntry() throws Exception {
            BatchEntry entry = this.getNextBatchEntry();
            System.out.println("Loading " + entry.getEntry());
            CommandLine.this.getReadAdapter().setDataInput(entry.makeDataInput());
            CommandLine.this.getWriteOptions().setFilename(entry.getFilename());
            CommandLine.this.setAdapterForFile(CommandLine.this.getWriteOptions());
        }

        BatchEntry getNextBatchEntry() {
            while (this.batchFileIterator.hasNext()) {
                BatchEntry be = (BatchEntry)this.batchFileIterator.next();
                if (!this.skipEntry(be)) {
                    return be;
                }
                System.out.println("skipping existing " + be.getFilename());
            }
            return null;
        }

        private boolean skipEntry(BatchEntry entry) {
            if (!this.skipExistingOutputFile()) {
                return false;
            }
            String outputFile = entry.getFilename();
            return this.fileExists(outputFile);
        }

        private boolean fileExists(String filename) {
            return new File(filename).exists();
        }

        private boolean skipExistingOutputFile() {
            return CommandLine.this.skipExistBatchEntry.getMatched();
        }

        int getLineNumber() {
            return this.reader.getLineNumber();
        }

        LineNumberReader getReader() {
            return this.reader;
        }

        class BatchEntry {
            private String entry;
            private String filename;
            private boolean isValid = false;

            private BatchEntry(String line) {
                this.parseLine(line);
            }

            private BatchEntry() {
            }

            void parseLine(String line) {
                String[] splitLine = line.split("\\s+");
                if (splitLine.length == 0) {
                    System.out.println("Ignoring line " + BatchFile.this.getLineNumber() + " failed to parse " + line);
                    return;
                }
                String s1 = splitLine[0].trim();
                if (s1 != null && !s1.equals("")) {
                    this.entry = s1;
                    this.isValid = true;
                }
                if (splitLine.length > 1) {
                    this.filename = splitLine[1].trim();
                    this.filename = this.addCurrentDirIfNoDir(this.filename);
                }
            }

            boolean isValid() {
                return this.isValid;
            }

            String getEntry() {
                return this.entry;
            }

            String getFilename() {
                if (this.filename == null) {
                    this.filename = this.makeDefaultFilename();
                }
                return this.filename;
            }

            String addCurrentDirIfNoDir(String file) {
                if (file.indexOf(47) != -1 && file.indexOf(92) != -1) {
                    return file;
                }
                return "./" + file;
            }

            private String makeDefaultFilename() {
                return "./" + this.entry + "." + CommandLine.this.outputFmtOption.getFileSuffix();
            }

            DataInput makeDataInput() {
                return new DataInput(CommandLine.this.getReadOptions().getInputType(), this.entry);
            }

            void setFilename(String filename) {
                this.filename = filename;
            }

            void setValid(boolean isValid) {
                this.isValid = isValid;
            }
        }
    }

    private class IOOptions {
        private ApolloDataAdapterI adapter;
        private DataInput dataInput;
        private String filename;
        private boolean specified = false;
        private boolean isRead = true;
        private DataInputType inputType;
        private String dbPassword = null;

        private IOOptions(boolean isRead) {
            this.isRead = isRead;
        }

        private void setAdapter(ApolloDataAdapterI adapter) {
            this.adapter = adapter;
        }

        private boolean hasAdapter() throws Exception {
            return this.getAdapter() != null;
        }

        private ApolloDataAdapterI getAdapter() throws Exception {
            if (this.adapter == null) {
                ApolloDataAdapterI apolloDataAdapterI = this.adapter = this.isRead ? this.getReadAdapter() : this.getWriteAdapter();
            }
            if (this.dataInput != null) {
                this.adapter.setDataInput(this.dataInput);
            }
            return this.adapter;
        }

        private ApolloDataAdapterI getReadAdapter() throws Exception {
            return CommandLine.this.inputFmtOption.getAdapter();
        }

        private ApolloDataAdapterI getWriteAdapter() throws Exception {
            return CommandLine.this.outputFmtOption.getAdapter();
        }

        private void setFilename(String filename) {
            this.filename = filename;
        }

        private String getFilename() {
            return this.filename;
        }

        private boolean haveSequenceFilename() {
            return this.getSequenceFilename() != null;
        }

        private String getSequenceFilename() {
            if (!this.isRead) {
                return null;
            }
            return CommandLine.this.seqFileOption.getArg();
        }

        private void setSpecifiedState(boolean specified) {
            this.specified = specified;
        }

        private boolean getSpecifiedState() {
            return this.specified;
        }

        private void setInputType(String inputTypeString) {
            this.inputType = DataInputType.getDataTypeForSoType(inputTypeString);
        }

        private boolean haveInputType() {
            return this.inputType != null;
        }

        private DataInputType getInputType() {
            return this.inputType;
        }

        private void setDataInput(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        private String getDbPassword() {
            return this.dbPassword;
        }

        private void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }
    }

    private class DbPassCommandOption
    extends CommandOption {
        private static final String help = "Read in the password for the chado database you want to read/write from/to. ";

        public DbPassCommandOption() {
            super("readDbPass", 'D', true, "db_pass", help);
        }

        public void execute() throws Exception {
            IOOptions ioo = new IOOptions(false);
            try {
                ioo = CommandLine.this.getDbIOOptions();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("A password was specified without using a DB (chadoDB) as input or output");
                CommandLine.this.parser.usage();
                System.exit(1);
            }
            try {
                ((ChadoAdapter)ioo.getAdapter()).setDbPassForDefaultDb(this.getArg());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private class BackupFileCommandOption
    extends CommandOption {
        private static final String help = "Read in a backup (serialized) file. (Shorthand for -i serialized -f serFile)";

        private BackupFileCommandOption() {
            super("readBackupFile", 'b', true, "backup_file", help);
        }

        public void execute() throws Exception {
            CommandLine.this.setReadFileAdapter(SERIALIZED, this.getArg());
        }
    }

    private class GameFileCommandOption
    extends CommandOption {
        private static final String help = "Read in a game file. (Shorthand for -i game -f gamefile)";

        private GameFileCommandOption() {
            super("readGameFile", 'x', true, "game_file", help);
        }

        public void execute() throws Exception {
            CommandLine.this.setReadFileAdapter(GAME, this.getArg());
        }
    }

    private class WriteFileCommandOption
    extends CommandOption {
        private WriteFileCommandOption() {
            super("writeFile", 'w', true, "filename", "Filename to write to");
        }

        public void execute() throws Exception {
            CommandLine.this.getWriteOptions().setFilename(this.getArg());
            CommandLine.this.setAdapterForFile(CommandLine.this.getWriteOptions());
        }
    }

    private class InputTypeCommandOption
    extends CommandOption {
        private static final String help = "Input type is dependent on input format. For chadoDB use the seqTypes for the db being loaded (e.g. chromosome_arm|chromosome, gene, golden_path_region...";

        private InputTypeCommandOption() {
            super("inputType", 't', true, "type", help);
        }

        private boolean haveType() throws Exception {
            if (!this.getMatched()) {
                return false;
            }
            this.execute();
            return CommandLine.this.getReadOptions().haveInputType();
        }

        public void execute() throws Exception {
            CommandLine.this.getReadOptions().setInputType(this.getArg());
        }
    }

    private class InputFilesListCommandOption
    extends CommandOption {
        private static final String help = "Specify a file which contains a list of files to process as inputFormat and to write to outputFormat. Intended for bath loading files into a DB (chado)";

        private InputFilesListCommandOption() {
            super("inputFilesList", 'p', true, "filename", help);
        }

        public void execute() throws Exception {
            CommandLine.this.batchFile = new BatchInputFile(this.getArg());
            CommandLine.this.isBatchMode = true;
            if (!CommandLine.this.haveReadAdapter()) {
                CommandLine.this.error("Input list/batch file specified without input format");
            }
            CommandLine.this.getReadOptions().setSpecifiedState(true);
        }
    }

    private class SkipExistBatchEntryCommandOption
    extends CommandOption {
        private static final String help = "If in batch mode, skip entry if the output (file) already exists";

        private SkipExistBatchEntryCommandOption() {
            super("skipExistBatchEntry", 'k', false, null, help);
        }
    }

    private class InputListFileCommandOption
    extends CommandOption {
        private static final String help = "Specify a file which contains a list of items to query of type inputType. These will then be queried with inputFormat and written out to ouputFormat.";

        private InputListFileCommandOption() {
            super("inputListFile", 'n', true, "filename", help);
        }

        public void execute() throws Exception {
            CommandLine.this.batchFile = new BatchFile(this.getArg());
            CommandLine.this.isBatchMode = true;
            if (!CommandLine.this.haveReadAdapter()) {
                CommandLine.this.error("Input list/batch file specified without input format");
            }
            if (!CommandLine.this.haveInputType()) {
                CommandLine.this.error("Input list file specified without input type");
            }
            CommandLine.this.getReadOptions().setSpecifiedState(true);
        }
    }

    private class InputFileCommandOption
    extends CommandOption {
        private static final String help = "Specify filename to read in (game,gff,gb,chadoxml,backup)";

        private InputFileCommandOption() {
            super("inputFile", 'f', true, "filename", help);
        }

        public void execute() throws Exception {
            CommandLine.this.getReadOptions().setFilename(this.getArg());
            CommandLine.this.setAdapterForFile(CommandLine.this.getReadOptions());
        }
    }

    private class LocationCommandOption
    extends CommandOption {
        private static final String help = "Specify a location for input. Chromosome:start-end, e.g. 1:1000-6000";

        private LocationCommandOption() {
            super("location", 'l', true, "location", help);
        }

        public void execute() throws Exception {
            if (!CommandLine.this.haveReadAdapter()) {
                CommandLine.this.error("Location specified without input format");
            }
            DataInputType type = DataInputType.BASEPAIR_RANGE;
            DataInput input = new DataInput(type, this.getArg());
            CommandLine.this.getReadAdapter().setDataInput(input);
            CommandLine.this.getReadOptions().setSpecifiedState(true);
        }
    }

    private class OutputFormatCommandOption
    extends CommandOption {
        private ApolloDataAdapterI writeAdapter;
        private String fileSuffix;
        private static final String help = "Specify output format. [chadoDB|game|chadoxml|genbank|gff|das2|backup]";

        private OutputFormatCommandOption() {
            super("outputFormat", 'o', true, "output_format", help);
        }

        public void execute() throws Exception {
            ApolloDataAdapterI ad = this.getAdapter();
            if (ad != null) {
                CommandLine.this.getWriteOptions().setAdapter(this.getAdapter());
            }
        }

        private ApolloDataAdapterI getAdapter() throws Exception {
            if (!this.getMatched()) {
                return null;
            }
            if (this.writeAdapter == null) {
                this.writeAdapter = CommandLine.this.getAdapterForString(this.getArg());
            }
            if (this.writeAdapter != null && this.adapterStringIsDatabase(this.getArg())) {
                CommandLine.this.getWriteOptions().setSpecifiedState(true);
            }
            this.setFileSuffix(this.getArg());
            return this.writeAdapter;
        }

        private boolean adapterStringIsDatabase(String adapterString) {
            return adapterString.equalsIgnoreCase("chadoDB");
        }

        private void setFileSuffix(String fileSuffix) {
            this.fileSuffix = fileSuffix;
        }

        private String getFileSuffix() {
            return this.fileSuffix;
        }
    }

    private class InputFormatCommandOption
    extends CommandOption {
        private ApolloDataAdapterI readAdapter;
        private static final String help = "Specify input format. [chadoDB|game|chadoxml|genbank|gff|das2|backup]";

        private InputFormatCommandOption() {
            super("inputFormat", 'i', true, "input_format", help);
        }

        private ApolloDataAdapterI getAdapter() throws Exception {
            if (!this.getMatched()) {
                return null;
            }
            if (this.readAdapter == null) {
                this.readAdapter = CommandLine.this.getAdapterForString(this.getArg());
            }
            return this.readAdapter;
        }
    }
}

