/*
 * Decompiled with CFR 0.152.
 */
package apollo.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileParse {
    public File inFile;
    public int fileSize;
    int bytes_read = 0;
    public byte[] dataArray;
    public Vector lineArray;
    public int noLines;
    String inType;
    URL url;
    URLConnection urlconn;

    public FileParse() {
    }

    public FileParse(String fileStr, String type) throws MalformedURLException, IOException {
        this.inType = type;
        if (type.equals("File")) {
            this.inFile = new File(fileStr);
            this.fileSize = (int)this.inFile.length();
        }
        if (type.equals("URL")) {
            this.url = new URL(fileStr);
            this.fileSize = 0;
            this.urlconn = this.url.openConnection();
        }
    }

    public void readLines(String inStr) {
        StringTokenizer str = new StringTokenizer(inStr, "\n");
        this.lineArray = new Vector();
        while (str.hasMoreTokens()) {
            this.lineArray.addElement(str.nextToken());
        }
        this.noLines = this.lineArray.size();
    }

    public void readLines() throws IOException {
        String line;
        DataInputStream dataIn;
        this.lineArray = new Vector();
        if (this.inType.equals("File")) {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.inFile));
            dataIn = new DataInputStream(bis);
        } else {
            dataIn = new DataInputStream(this.urlconn.getInputStream());
        }
        while ((line = dataIn.readLine()) != null) {
            this.lineArray.addElement(line);
        }
        this.noLines = this.lineArray.size();
    }

    public Vector splitLine(char splitChar, int element) {
        Vector<String> wordVector = new Vector<String>();
        String line = (String)this.lineArray.elementAt(element);
        char[] charArray = line.toCharArray();
        int i = 0;
        int letter = 0;
        char[] word = new char[line.length()];
        char prev_char = '\n';
        for (i = 0; i < line.length(); ++i) {
            if (charArray[i] != splitChar) {
                word[letter] = charArray[i];
                prev_char = charArray[i];
                ++letter;
                continue;
            }
            if (prev_char == splitChar || prev_char == '\n') continue;
            wordVector.addElement(new String(word));
            letter = 0;
            word = null;
            word = new char[line.length()];
            prev_char = charArray[i];
        }
        if (line.length() != 0) {
            if (charArray[line.length() - 1] != splitChar) {
                wordVector.addElement(new String(word));
            }
        } else {
            return null;
        }
        return wordVector;
    }
}

