/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.synteny;

import apollo.config.ApolloNameAdapterI;
import apollo.config.Config;
import apollo.config.PropertyScheme;
import apollo.config.Style;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.CurationState;
import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CurationSet;
import apollo.editor.AnnotationEditor;
import apollo.editor.TransactionManager;
import apollo.external.IgbBridge;
import apollo.gui.Controller;
import apollo.gui.SelectionManager;
import apollo.gui.StatusBar;
import apollo.gui.featuretree.FeatureTreeFrame;
import apollo.gui.genomemap.NavigationBar;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.synteny.CurationManager;
import java.util.Iterator;
import java.util.Vector;

public class GuiCurationState {
    private int curationNumber;
    private Controller controller;
    private CurationState curState;
    private SelectionManager selectionManager;
    private StrandedZoomableApolloPanel strandedZoomableApolloPanel;
    private String zoomLayoutPosition = "South";
    private NavigationBar navigationBar;
    private FeatureTreeFrame featureTreeFrame;
    private IgbBridge igbBridge;
    private CurationDataLoadListener curationDataLoadListener = new CurationDataLoadListener();

    GuiCurationState(int i) {
        this.curationNumber = i;
    }

    private CurationState getCurationState() {
        if (this.curState == null) {
            this.curState = new CurationState(this.curationNumber);
        }
        return this.curState;
    }

    public Controller getController() {
        if (this.controller == null) {
            this.controller = new Controller();
            this.controller.addListener(Controller.getMasterController());
        }
        return this.controller;
    }

    public SelectionManager getSelectionManager() {
        if (this.selectionManager == null) {
            this.selectionManager = new SelectionManager();
            this.selectionManager.setController(this.getController());
        }
        return this.selectionManager;
    }

    void setCurationName(String spStr) {
        this.curState.setCurationName(spStr);
    }

    public String getCurationName() {
        return this.curState.getCurationName();
    }

    public StrandedZoomableApolloPanel getSZAP() {
        if (this.strandedZoomableApolloPanel == null) {
            String zoomPos = this.getZoomLayoutPosition();
            this.strandedZoomableApolloPanel = new StrandedZoomableApolloPanel(this, zoomPos);
            StatusBar sb = CurationManager.getCurationManager().getStatusBar();
            this.strandedZoomableApolloPanel.setStatusBar(sb);
        }
        return this.strandedZoomableApolloPanel;
    }

    public NavigationBar getNavigationBar() {
        if (this.navigationBar == null) {
            this.navigationBar = new NavigationBar(this);
        }
        return this.navigationBar;
    }

    private String getZoomLayoutPosition() {
        return this.zoomLayoutPosition;
    }

    void setZoomLayoutPosition(String layoutPos) {
        this.zoomLayoutPosition = layoutPos;
    }

    void clear() {
        if (this.controller == null) {
            return;
        }
        this.controller.clear(false);
    }

    void setDataAdapter(ApolloDataAdapterI da) {
        if (da.getCurationState() != null) {
            this.curState = da.getCurationState();
        } else {
            this.getCurationState().setDataAdapter(da);
        }
        da.setDataLoadListener(this.getController());
        da.getStyle().getPropertyScheme().addPropSchemeChangeListener(this.getController());
        da.getStyle().getPropertyScheme().firePropSchemeChangeEvent();
    }

    public ApolloDataAdapterI getDataAdapter() {
        return this.curState.getDataAdapter();
    }

    public Style getStyle() {
        if (this.getDataAdapter().getStyle() != null) {
            return this.getDataAdapter().getStyle();
        }
        return Config.getStyle();
    }

    public PropertyScheme getPropertyScheme() {
        if (this.getDataAdapter() == null) {
            return null;
        }
        return this.getDataAdapter().getStyle().getPropertyScheme();
    }

    public ApolloNameAdapterI getNameAdapter(AnnotatedFeatureI af) {
        return this.curState.getNameAdapter(af);
    }

    void setCurationSet(CurationSet cs) {
        this.unRegisterTranManager();
        this.curState.setCurationSet(cs);
        this.getController().handleDataLoadEvent(new DataLoadEvent((Object)this, cs));
        this.getSZAP().setCurationSet(cs);
        this.registerTranManager();
        this.setUpIgbBridge();
    }

    private void setUpIgbBridge() {
        this.getController().removeListener(this.getIgbBridge());
        if (!this.getStyle().igbHttpConnectionEnabled()) {
            return;
        }
        this.getIgbBridge().setGenomicRange(this.getCurationSet());
        this.getController().addListener(this.getIgbBridge());
    }

    private IgbBridge getIgbBridge() {
        if (this.igbBridge == null) {
            this.igbBridge = new IgbBridge(this.getCurationSet());
        }
        return this.igbBridge;
    }

    private void unRegisterTranManager() {
        Vector listeners = this.getController().getListeners();
        if (listeners != null) {
            Iterator it = listeners.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof TransactionManager)) continue;
                it.remove();
            }
        }
        this.getController().removeListener(this.curationDataLoadListener);
    }

    private void registerTranManager() {
        TransactionManager tm = this.curState.getTransactionManager();
        if (!this.getController().hasListener(tm)) {
            this.getController().addListener(tm);
            tm.setAnnotationChangeListener(this.getController());
            this.getController().addListener(this.curationDataLoadListener);
        }
    }

    public TransactionManager getTransactionManager() {
        return this.curState.getTransactionManager();
    }

    public CurationSet getCurationSet() {
        return this.curState.getCurationSet();
    }

    public FeatureTreeFrame getFeatureTreeFrame() {
        if (this.featureTreeFrame == null) {
            this.featureTreeFrame = new FeatureTreeFrame(this.getCurationSet().getAnnots(), this);
        }
        return this.featureTreeFrame;
    }

    public void addAnnotationEditor(AnnotationEditor ae, boolean forwardStrand) {
        this.curState.addAnnotationEditor(ae, forwardStrand);
    }

    public AnnotationEditor getAnnotationEditor(boolean forwardStrand) {
        return this.curState.getAnnotationEditor(forwardStrand);
    }

    public boolean haveSequence() {
        return this.curState.haveSequence();
    }

    public boolean haveAnnots() {
        return this.curState.haveAnnots();
    }

    private class CurationDataLoadListener
    implements DataLoadListener {
        private CurationDataLoadListener() {
        }

        public boolean handleDataLoadEvent(DataLoadEvent e) {
            if (e.dataRetrievalBeginning()) {
                GuiCurationState.this.getTransactionManager().clear();
            }
            return true;
        }
    }
}

