/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.Config;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.gui.annotinfo.FeatureEditorDialog;
import apollo.gui.featuretree.FeatureTreePanel;
import apollo.gui.synteny.GuiCurationState;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;

public class TreeMenu
extends JPopupMenu
implements ActionListener {
    FeatureTreePanel ftp;
    JMenuItem show;
    JMenuItem hide;
    JMenuItem edit;
    Point pos;
    AnnotatedFeatureI annot = null;
    private GuiCurationState curationState;

    public TreeMenu(FeatureTreePanel ftp, Point pos, GuiCurationState curationState) {
        super("Tree operations");
        this.ftp = ftp;
        this.pos = pos;
        this.curationState = curationState;
        DefaultMutableTreeNode dmtn = this.ftp.getSelectedNode();
        if (dmtn != null) {
            if (dmtn.getUserObject() instanceof AnnotatedFeatureI) {
                this.annot = (AnnotatedFeatureI)dmtn.getUserObject();
            }
        } else {
            this.annot = null;
        }
        this.menuInit();
    }

    public void menuInit() {
        this.show = new JMenuItem("Show annotation");
        this.hide = new JMenuItem("Hide annotation");
        this.edit = Config.isEditingEnabled() ? new JMenuItem("Annotation info editor...") : new JMenuItem("Annotation info...");
        if (Config.isEditingEnabled()) {
            this.add(this.edit);
        }
        this.hide.addActionListener(this);
        this.show.addActionListener(this);
        this.edit.addActionListener(this);
        this.hide.setMnemonic('H');
        this.show.setMnemonic('S');
        this.edit.setMnemonic('E');
        this.hide.setEnabled(false);
        this.show.setEnabled(false);
        if (this.annot == null) {
            this.edit.setEnabled(false);
        }
        this.hide.setAccelerator(KeyStroke.getKeyStroke(72, 1));
        this.show.setAccelerator(KeyStroke.getKeyStroke(83, 1));
        this.edit.setAccelerator(KeyStroke.getKeyStroke(69, 1));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.hide) {
            System.out.println("hide annotation");
        } else if (e.getSource() == this.show) {
            System.out.println("show annotation");
        } else if (e.getSource() == this.edit) {
            FeatureEditorDialog.showTextEditor(this.annot, this.getCurationState());
        }
    }

    private GuiCurationState getCurationState() {
        return this.curationState;
    }
}

