/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.FeatureProperty;
import apollo.config.TierProperty;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.gui.PropertyPanel;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PropertyMenu
extends JPopupMenu
implements ActionListener {
    PropertyPanel type_panel;
    TierProperty tier_prop;
    Hashtable color_items = new Hashtable();
    JMenuItem collapseTier;
    Point pos;
    ApolloDataAdapterI adapter;

    public PropertyMenu(PropertyPanel pp, TierProperty tp, Point pos) {
        super("Pick colors");
        this.type_panel = pp;
        this.tier_prop = tp;
        this.pos = pos;
        this.menuInit();
    }

    public void menuInit() {
        Vector fpVect = this.tier_prop.getFeatureProperties();
        for (int i = 0; i < fpVect.size(); ++i) {
            FeatureProperty fp = (FeatureProperty)fpVect.elementAt(i);
            JMenuItem item = new JMenuItem(fp.getDisplayType());
            item.setBackground(fp.getColour());
            this.add(item);
            item.setEnabled(true);
            this.color_items.put(item, fp);
            item.addActionListener(this);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem item = (JMenuItem)e.getSource();
            FeatureProperty fp = (FeatureProperty)this.color_items.get(item);
            Color color = JColorChooser.showDialog(this, "Choose color for " + fp.getDisplayType() + " features", fp.getColour());
            if (color != null) {
                fp.setColour(color);
                item.setBackground(color);
            }
        }
    }
}

