/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.Transcript;
import apollo.gui.Controller;
import apollo.gui.Selection;
import apollo.gui.SelectionItem;
import apollo.gui.SelectionManager;
import apollo.gui.drawable.SiteCodon;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.event.FeatureSelectionListener;
import apollo.gui.event.TierManagerEvent;
import apollo.gui.genomemap.ResultView;
import apollo.gui.genomemap.SiteTier;
import apollo.gui.genomemap.SiteTierManager;
import apollo.gui.genomemap.Sites;
import apollo.gui.genomemap.TierView;
import apollo.util.FeatureList;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import org.bdgp.util.DNAUtils;

public class SiteView
extends TierView {
    public static final char[] startCodon = new char[]{'A', 'T', 'G'};
    public static final int startCodonHashCode = SiteView.primitiveHash(startCodon);
    private Codon[] stopCodons = null;
    protected int height = 0;
    protected Sites[] sitesArray = new Sites[0];
    protected CurationSet curation;
    protected ResultView resultView;

    public SiteView(JComponent ap, String name, Controller controller, SelectionManager selectionManager) {
        super(ap, name, selectionManager);
        this.initStopCodons();
        this.setController(controller);
        this.setTierManager(new SiteTierManager(controller));
        controller.addListener(new TranslationStartStopSelectionListener());
        this.setBackgroundColour(Color.white);
    }

    private void initStopCodons() {
        List stopCharArrays = DNAUtils.getStopCodonsAsCharArrayList();
        this.stopCodons = new Codon[stopCharArrays.size()];
        for (int i = 0; i < stopCharArrays.size(); ++i) {
            char[] stop = (char[])stopCharArrays.get(i);
            this.stopCodons[i] = new Codon(stop);
        }
    }

    public void setCurationSet(CurationSet set) {
        this.curation = set;
        if (set == null) {
            return;
        }
        if (set.length() > 0) {
            this.curation = set;
        } else {
            System.err.println("Null sequence in SiteView setSequence");
        }
    }

    public void paintDrawables() {
        ((SiteTierManager)this.manager).updateUserCoordBoundaries();
        for (int i = 0; i < this.sitesArray.length; ++i) {
            FeatureProperty fp;
            int frame;
            if (i < 3) {
                frame = i + 1;
                fp = Config.getPropertyScheme().getFeatureProperty("startcodon_frame" + frame);
            } else {
                frame = i - 3 + 1;
                fp = Config.getPropertyScheme().getFeatureProperty("stopcodon_frame" + frame);
            }
            if (!fp.getTier().isVisible()) continue;
            Color colour = fp.getColour();
            SiteTier tier = (SiteTier)this.manager.getTier(i);
            for (int j = 0; j < this.sitesArray[i].size(); ++j) {
                int site = this.sitesArray[i].elementAt(j);
                boolean selected = this.sitesArray[i].isSelected(site);
                this.drawSite(tier, site, colour, selected);
            }
        }
    }

    private void drawSite(SiteTier tier, int position, Color colour, boolean selected) {
        Rectangle box = this.getDrawRectangle(tier, position);
        this.graphics.setColor(colour);
        this.graphics.fillRect(box.x, box.y, box.width, box.height);
        if (selected) {
            this.graphics.setColor(Color.red);
            this.graphics.drawRect(box.x - 2, box.y - 2, box.width + 4, box.height + 4);
        }
    }

    private Rectangle getDrawRectangle(SiteTier tier, int position) {
        int low = tier.getDrawLow();
        int high = tier.getDrawHigh();
        Point lowpos = this.transformer.getXOrientation() == 1 && this.getStrand() == 1 ? this.transformer.toPixel(position - 1, low) : (this.transformer.getXOrientation() == 1 && this.getStrand() == -1 ? this.transformer.toPixel(position - 3, low) : (this.transformer.getXOrientation() == -1 && this.getStrand() == 1 ? this.transformer.toPixel(position + 2, low) : this.transformer.toPixel(position, low)));
        Point highpos = this.transformer.toPixel(position, high);
        int width = (int)(this.transformer.getXPixelsPerCoord() * 3.0 < 1.0 ? 1.0 : this.transformer.getXPixelsPerCoord() * 3.0);
        return new Rectangle(lowpos.x, lowpos.y, width, highpos.y - lowpos.y);
    }

    public void setVisible(boolean state) {
        super.setVisible(state);
        if (this.isVisible()) {
            this.changeSites();
        }
    }

    private void changeSites() {
        this._createSites(this.transformer.getXVisibleRange());
        this.manager.setTierData(this.sitesArray);
        this.manager.fireTierManagerEvent(1);
        this.setInvalidity(true);
    }

    public void setCentre(int val) {
        super.setCentre(val);
        if (this.isVisible()) {
            this.changeSites();
        }
    }

    protected boolean needsTextAvoidUpdate() {
        return false;
    }

    public void setZoomFactor(double fac) {
        super.setZoomFactor(fac);
        if (this.isVisible()) {
            boolean showSites;
            int siteShowLim = Config.getSiteShowLimit();
            boolean bl = showSites = this.transformer.getXCoordsPerPixel() < (double)siteShowLim;
            if (!showSites) {
                this.sitesArray = new Sites[0];
            } else {
                this.changeSites();
            }
        }
    }

    private static int primitiveHash(char[] array) {
        int hashCode = 0;
        if (array.length < 3) {
            System.err.println("primitiveHash expects an array at least 3 long");
        }
        for (int i = 0; i < 3; ++i) {
            hashCode += array[i];
        }
        return hashCode;
    }

    public void _createSites(int[] visRange) {
        int i;
        String dna;
        if (this.curation == null) {
            this.sitesArray = new Sites[0];
            return;
        }
        int seqLow = this.curation.getLow();
        int seqHigh = this.curation.getHigh();
        if (seqHigh <= 0) {
            this.sitesArray = new Sites[0];
            return;
        }
        int min = visRange[0] < visRange[1] ? visRange[0] : visRange[1];
        int max = visRange[0] > visRange[1] ? visRange[0] : visRange[1];
        int len = (max = max > seqHigh ? seqHigh : max) - (min = min < seqLow ? seqLow : min) + 1;
        if (len <= 0) {
            this.sitesArray = new Sites[0];
            return;
        }
        int remainder = len % 3;
        int extension = Math.abs(3 - remainder);
        if (this.getStrand() == 1) {
            if (max + extension <= seqHigh) {
                max += extension;
            }
        } else if (min - extension >= seqLow) {
            min -= extension;
        }
        char[] seq_chars = new char[]{};
        SequenceI seq = this.curation.getRefSequence();
        String string = dna = this.getStrand() == 1 ? seq.getResidues(min, max) : seq.getResidues(max, min);
        if (dna == null || dna.length() == 0) {
            System.out.println("No sequence to make stops & starts from");
            return;
        }
        if (Character.isLowerCase(dna.charAt(0))) {
            dna = dna.toUpperCase();
        }
        if ((seq_chars = dna.toCharArray()).length < 3) {
            this.sitesArray = new Sites[0];
            return;
        }
        int frame = this.getFrame(min, max);
        if (this.sitesArray.length == 0) {
            this.sitesArray = new Sites[6];
            for (i = 0; i < 6; ++i) {
                this.sitesArray[i] = new Sites();
            }
        } else {
            for (i = 0; i < 6; ++i) {
                this.sitesArray[i].clearPositions();
            }
        }
        char seqi = '\u0000';
        char seqip1 = seq_chars[0];
        char seqip2 = seq_chars[1];
        int hashCode3 = seqip1 + seqip2;
        for (int i2 = 0; i2 < seq_chars.length - 2; ++i2) {
            hashCode3 -= seqi;
            seqi = seqip1;
            seqip1 = seqip2;
            seqip2 = seq_chars[i2 + 2];
            hashCode3 += seqip2;
            if (seqi != 'G' && seqi != 'C') {
                int pos;
                if (hashCode3 == startCodonHashCode && startCodon[0] == seqi && startCodon[1] == seqip1) {
                    pos = this.getStrand() == 1 ? i2 + min : max - i2;
                    this.sitesArray[frame].addSite(pos);
                } else if (this.isStop(hashCode3, seqi, seqip1)) {
                    pos = this.getStrand() == 1 ? i2 + min : max - i2;
                    this.sitesArray[frame + 3].addSite(pos);
                }
            }
            if (++frame != 3) continue;
            frame = 0;
        }
    }

    private boolean isStop(int hashCode, char seqi, char seqip1) {
        for (int i = 0; i < this.stopCodons.length; ++i) {
            if (!this.stopCodons[i].matches(hashCode, seqi, seqip1)) continue;
            return true;
        }
        return false;
    }

    public boolean allowsTierDrags() {
        return false;
    }

    public Rectangle getPreferredSize() {
        int total_height = this.height;
        if (this.manager != null) {
            total_height += this.manager.getTotalHeight();
        }
        return new Rectangle(0, 0, 1, total_height);
    }

    public void setResultView(ResultView rv) {
        this.resultView = rv;
    }

    public ResultView getResultView() {
        return this.resultView;
    }

    public boolean handleTierManagerEvent(TierManagerEvent evt) {
        this.setInvalidity(true);
        if (this.getPreferredSize().height != this.getBounds().height) {
            this.getComponent().doLayout();
            return true;
        }
        return super.handleTierManagerEvent(evt);
    }

    public Selection findFeaturesForSelection(Rectangle rect, boolean selectParents) {
        Selection selection = new Selection();
        Vector codons = this.findDrawables(rect);
        for (int i = 0; i < codons.size(); ++i) {
            SiteCodon codon = (SiteCodon)codons.elementAt(i);
            SelectionItem selItem = new SelectionItem(this, codon.getFeature());
            selItem.addSelectionListener(codon);
            selection.add(selItem);
        }
        return selection;
    }

    protected Vector findDrawables(Rectangle rect, boolean selected_only) {
        Vector<SiteCodon> matches = new Vector<SiteCodon>();
        String namePrefix = "start codon";
        for (int i = 0; i < this.sitesArray.length; ++i) {
            String type;
            int frame;
            if (i >= 3) {
                frame = i - 2;
                type = "stopcodon_frame" + frame;
                namePrefix = "stop codon";
            } else {
                frame = i + 1;
                type = "startcodon_frame" + frame;
            }
            SiteTier tier = (SiteTier)this.manager.getTier(i);
            for (int j = 0; j < this.sitesArray[i].size(); ++j) {
                int pos = this.sitesArray[i].elementAt(j);
                Rectangle box = this.getDrawRectangle(tier, pos);
                if (!rect.intersects(box) || (!selected_only || !this.sitesArray[i].isSelected(pos)) && selected_only) continue;
                int low = this.getStrand() == 1 ? pos : pos - 2;
                int high = low + 2;
                SiteCodon site = this.sitesArray[i].getSiteCodon(low, high, type, this.getStrand(), namePrefix);
                matches.addElement(site);
            }
        }
        return matches;
    }

    public void clearSelections() {
        for (int i = 0; i < this.sitesArray.length; ++i) {
            this.sitesArray[i].clearSelected();
        }
    }

    public void selectParents(Selection selection) {
    }

    private int getFrame(int bp) {
        return this.getFrame(bp, bp);
    }

    private int getFrame(int rangeLow, int rangeHi) {
        if (this.isForwardStrand()) {
            return (rangeLow - this.curation.getLow()) % 3;
        }
        return (this.curation.getHigh() - rangeHi) % 3;
    }

    private boolean isTopLevelAnnot(SeqFeatureI annot) {
        if (!annot.hasAnnotatedFeature()) {
            return false;
        }
        return annot.getAnnotatedFeature().isAnnotTop();
    }

    public Selection getViewSelection(Selection selection) {
        Selection view_selection = new Selection();
        Vector selected = selection.getSelected();
        int sel_count = selected.size();
        for (int i = 0; i < sel_count; ++i) {
            SelectionItem si = (SelectionItem)selected.elementAt(i);
            if (si.getSource() != this) continue;
            view_selection.add(si);
        }
        return view_selection;
    }

    private class TranslationStartStopSelectionListener
    implements FeatureSelectionListener {
        private TranslationStartStopSelectionListener() {
        }

        public boolean handleFeatureSelectionEvent(FeatureSelectionEvent e) {
            if (e.getSource() instanceof TranslationStartStopSelectionListener) {
                return false;
            }
            if (!SiteView.this.isVisible()) {
                return false;
            }
            HashSet transSet = this.getTranscripts(e.getSelection());
            Selection codonSelection = new Selection();
            Iterator i = transSet.iterator();
            while (i.hasNext()) {
                SelectionItem stopSelectionItem;
                Transcript t = (Transcript)i.next();
                SelectionItem startSelectionItem = this.getStartSelectionItem(t);
                if (startSelectionItem != null) {
                    codonSelection.add(startSelectionItem);
                }
                if ((stopSelectionItem = this.getStopSelectionItem(t)) == null) continue;
                codonSelection.add(stopSelectionItem);
            }
            if (codonSelection.size() > 0) {
                SiteView.this.selectionManager.addToCurrentSelection(codonSelection);
            }
            return true;
        }

        private SelectionItem getStartSelectionItem(Transcript t) {
            if (!t.hasTranslationStart()) {
                return null;
            }
            return this.getSelectionItem(t.getTranslationStart(), true);
        }

        private SelectionItem getStopSelectionItem(Transcript t) {
            if (!t.hasTranslationEnd()) {
                return null;
            }
            return this.getSelectionItem(t.getTranslationEnd(), false);
        }

        private SelectionItem getSelectionItem(int basepair, boolean getStart) {
            if (this.outOfRange(basepair)) {
                return null;
            }
            Sites sites = this.getSitesForBasepair(basepair, getStart);
            if (sites == null || !sites.siteExistsAtPosition(basepair)) {
                return null;
            }
            String type = this.getTypeString(basepair, getStart);
            String prefix = (getStart ? "start" : "stop") + " codon";
            int low = SiteView.this.isForwardStrand() ? basepair : basepair - 2;
            int high = low + 2;
            SiteCodon siteCodon = sites.getSiteCodon(low, high, type, SiteView.this.getStrand(), prefix);
            SelectionItem selItem = new SelectionItem(SiteView.this, siteCodon.getFeature());
            selItem.addSelectionListener(siteCodon);
            return selItem;
        }

        private boolean outOfRange(int basepair) {
            return basepair < SiteView.this.curation.getLow() || basepair > SiteView.this.curation.getHigh();
        }

        private Sites getSitesForBasepair(int basepair, boolean getStart) {
            if (this.outOfRange(basepair)) {
                return null;
            }
            int sitesIndex = SiteView.this.getFrame(basepair);
            if (!getStart) {
                sitesIndex += 3;
            }
            if (sitesIndex >= SiteView.this.sitesArray.length) {
                sitesIndex = SiteView.this.sitesArray.length - 1;
            }
            if (sitesIndex < 0) {
                System.err.println("getSitesForBasepair: can't find sites for requested basepair " + basepair);
                return null;
            }
            return SiteView.this.sitesArray[sitesIndex];
        }

        private String getTypeString(int basepair, boolean start) {
            int frame = SiteView.this.getFrame(basepair) + 1;
            String startStop = start ? "start" : "stop";
            return startStop + "codon_frame" + frame;
        }

        private HashSet getTranscripts(Selection sel) {
            if (SiteView.this.resultView == null) {
                System.out.println("SiteView has null resultView");
                return null;
            }
            if (SiteView.this.resultView.getAnnotationView() == null) {
                System.out.println("SiteView's resultView has null AnnotationView");
                return null;
            }
            FeatureSetI top = SiteView.this.resultView.getAnnotationView().getGeneHolder();
            boolean checkForRedundantDescendants = true;
            Selection annotSel = sel.getSelectionDescendedFromModel(top, checkForRedundantDescendants);
            FeatureList annots = annotSel.getConsolidatedFeatures();
            HashSet<SeqFeatureI> trans = new HashSet<SeqFeatureI>(annots.size());
            for (int i = 0; i < annots.size(); ++i) {
                SeqFeatureI ann = annots.getFeature(i);
                if (ann.isTranscript()) {
                    trans.add(ann);
                    continue;
                }
                if (!SiteView.this.isTopLevelAnnot(ann)) continue;
                trans.addAll(ann.getFeatures());
            }
            return trans;
        }
    }

    private class Codon {
        private int hashCode;
        private char[] chars;

        private Codon(char[] chars) {
            this.chars = chars;
            this.hashCode = SiteView.primitiveHash(chars);
        }

        private boolean matches(int hashCode, char seqi, char seqip1) {
            return hashCode == this.hashCode && this.chars[0] == seqi && this.chars[1] == seqip1;
        }
    }
}

