/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.gui.Transformer;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class PlotUtil {
    private PlotUtil() {
    }

    public static int calcTickInterval(int[] range) {
        return PlotUtil.calcTickInterval(range, null, null, null);
    }

    public static int calcTickInterval(int[] range, Graphics graphics, Transformer transformer, Vector labels) {
        double dtick;
        int ii;
        int endCoord = range[1];
        int startCoord = range[0];
        int length = endCoord - startCoord + 1;
        int tmp = (int)(Math.log(length) / Math.log(10.0));
        int tick = (int)Math.pow(10.0, tmp - (ii = 1));
        if (tick == 0) {
            tick = 1;
        }
        double dtickorig = dtick = (double)tick;
        double[] tickints = new double[6];
        if (tick > 1) {
            tickints[0] = 2.0;
            tickints[1] = 2.5;
            tickints[2] = 5.0;
            tickints[3] = 8.0;
            tickints[4] = 10.0;
            tickints[5] = 20.0;
        } else {
            tickints[0] = 2.0;
            tickints[1] = 4.0;
            tickints[2] = 5.0;
            tickints[3] = 8.0;
            tickints[4] = 10.0;
            tickints[5] = 20.0;
        }
        int intnum = 0;
        while ((double)length / dtick > 10.0) {
            dtick = dtickorig * tickints[intnum++];
        }
        tick = (int)dtick;
        if (graphics != null) {
            FontMetrics fm = graphics.getFontMetrics();
            boolean overlaps = true;
            --intnum;
            while (overlaps && intnum < tickints.length - 1) {
                int startpos = startCoord / tick * tick;
                Point start = transformer.toPixel(new Point(startpos, 0));
                Point end = transformer.toPixel(new Point(startpos + tick, 0));
                int tickPix = 0;
                if (transformer.getXOrientation() == 1) {
                    tickPix = end.x - start.x - 1;
                    tickPix -= (end.x - start.x - 1) / 5;
                } else {
                    tickPix = start.x - end.x - 1;
                    tickPix -= (start.x - end.x - 1) / 5;
                }
                overlaps = false;
                for (int i = startpos; i <= endCoord && !overlaps; i += tick) {
                    String label = PlotUtil.getLabel(tick, startpos, i);
                    if (fm.stringWidth(label) <= tickPix) continue;
                    overlaps = true;
                    dtick = dtickorig * tickints[++intnum];
                    tick = (int)dtick;
                }
            }
        }
        if (labels != null) {
            int startpos;
            for (int i = startpos = startCoord / tick * tick; i <= endCoord; i += tick) {
                String label = PlotUtil.getLabel(tick, startpos, i);
                labels.addElement(label);
            }
        }
        return tick;
    }

    public static double log10(double x) {
        return Math.log(x) * 0.4342944819032518;
    }

    private static String getLabel(int tick, int startpos, int i) {
        String label;
        if (PlotUtil.log10(tick) >= 4.0 || startpos > 100000 && PlotUtil.log10(tick) >= 3.0) {
            double mbval = (double)i / 1000000.0;
            label = String.valueOf(mbval) + "Mb";
        } else {
            label = String.valueOf(i);
        }
        return label;
    }
}

