/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.evidencepanel;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.gui.Controller;
import apollo.gui.DetailInfo;
import apollo.gui.SelectionManager;
import apollo.gui.drawable.DrawableSeqFeature;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.event.FeatureSelectionListener;
import apollo.gui.evidencepanel.TablePanel;
import apollo.util.ClipboardUtil;
import apollo.util.FeatureList;
import apollo.util.SeqFeatureUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class SetDetailPanel
extends TablePanel {
    JLabel labelBox;
    JScrollPane descPane;
    JTextArea descBox;
    JPanel headerPanel;
    SeqFeatureI fset;

    public SetDetailPanel(Controller c, SelectionManager sm) {
        super(c, sm);
        this.init();
    }

    public SetDetailPanel(FeatureSetI fset, Controller c, SelectionManager sm) {
        this(c, sm);
        this.setFeatureSet(fset);
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.labelBox = new JLabel("");
        this.labelBox.setFont(new Font("Helvetica", 1, 12));
        this.labelBox.setHorizontalAlignment(0);
        this.labelBox.setOpaque(true);
        this.labelBox.setForeground(Color.black);
        this.descBox = new JTextArea("");
        this.descBox.setEditable(false);
        this.descBox.setLineWrap(true);
        this.descBox.setWrapStyleWord(true);
        this.descBox.registerKeyboardAction(new CopyAction(), "Copy", KeyStroke.getKeyStroke(67, 2), 0);
        this.descPane = new JScrollPane(this.descBox);
        this.headerPanel = new JPanel();
        this.headerPanel.setLayout(new BorderLayout());
        this.headerPanel.add((Component)this.labelBox, "North");
        this.headerPanel.add((Component)this.descPane, "Center");
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.pane, "Center");
        this.getController().addListener(new FeatureSelectionListener(){

            public boolean handleFeatureSelectionEvent(FeatureSelectionEvent e) {
                if (SetDetailPanel.this.isSelectionSource(e)) {
                    return false;
                }
                FeatureList f = e.getFeatures();
                if (f.size() != 1) {
                    return false;
                }
                SetDetailPanel.this.selectFeature(f.getFeature(0));
                return true;
            }
        });
    }

    public void setFeatureSet(SeqFeatureI fset) {
        this.fset = fset;
        this.populateTable();
    }

    protected void reset() {
        this.descBox.setText("");
        this.labelBox.setText("");
        this.model.setData(new Vector(0));
        this.model.setPropertyList(new Vector(0));
        this.fset = null;
    }

    protected void populateTable() {
        Vector<SeqFeatureI> feature_list;
        if (this.fset == null) {
            this.reset();
            this.repaint();
            return;
        }
        if (this.fset.hasKids()) {
            feature_list = SeqFeatureUtil.getSortedKids(this.fset);
        } else {
            feature_list = new Vector<SeqFeatureI>();
            feature_list.add(this.fset);
        }
        if (feature_list.size() == 0) {
            return;
        }
        SeqFeatureI firstFeature = (SeqFeatureI)feature_list.elementAt(0);
        FeatureProperty fp = Config.getPropertyScheme().getFeatureProperty(firstFeature.getTopLevelType());
        Vector propertyVals = fp.getColumnHeadings();
        String sortKey = fp.getSortProperty();
        String oldType = this.model.getType();
        String oldSortKey = this.model.getSortKey();
        boolean oldReverseSort = this.model.getReverseSort();
        this.model.setType(firstFeature.getFeatureType());
        this.model.setPropertyList(propertyVals);
        this.model.setData(feature_list, sortKey, fp.getReverseSort());
        if (oldType == null || oldType.equals(firstFeature.getFeatureType())) {
            this.model.setSortKey(oldSortKey);
            this.model.setReverseSort(oldReverseSort);
        }
        this.table.sizeColumnsToFit(-1);
        this.setupHeader(this.fset, firstFeature);
        this.table.repaint();
    }

    public void setToFeature(SeqFeatureI feature) {
    }

    protected void setupHeader(SeqFeatureI fset, SeqFeatureI sf) {
        String desc = "";
        String name = "";
        int length = 0;
        if (sf.hasHitFeature()) {
            SequenceI seq = fset.getHitSequence();
            SeqFeatureI hit = sf.getHitFeature();
            if (seq == null) {
                seq = hit.getRefSequence();
            }
            if (seq != null) {
                String string = name = seq.getName() != null ? seq.getName() : "";
                if (!name.equals("")) {
                    name = DetailInfo.getPropertyType(fset) + ":  " + name;
                }
                desc = seq.getDescription() != null ? seq.getDescription() : "";
                length = seq.getLength() > 0 ? seq.getLength() : 0;
            } else {
                name = Config.getDisplayPrefs().getBioTypeForDisplay(fset);
            }
        } else {
            name = fset.isAnnotTop() ? Config.getDisplayPrefs().getDisplayName(fset) : (fset.getRefFeature() != null ? Config.getDisplayPrefs().getDisplayName(fset.getRefFeature()) : Config.getDisplayPrefs().getDisplayName(fset));
            if (fset.getName() != null && !fset.getName().equals("no_name") && !fset.getName().equals("")) {
                desc = fset.getName();
            }
            if (fset.hasAnnotatedFeature()) {
                AnnotatedFeatureI gene = fset.getAnnotatedFeature();
                while (gene.getRefFeature().hasAnnotatedFeature()) {
                    gene = gene.getRefFeature().getAnnotatedFeature();
                }
                desc = desc + " " + gene.getDescription();
            }
        }
        this.descBox.setText(desc);
        if (length == 0) {
            this.labelBox.setText(name);
        } else {
            this.labelBox.setText(name + " (length=" + length + ")");
        }
        this.labelBox.setBackground(this.getFeatureColor());
    }

    private Color getFeatureColor() {
        if (this.fset instanceof DrawableSeqFeature) {
            FeatureProperty prop = ((DrawableSeqFeature)((Object)this.fset)).getFeatureProperty();
            return prop.getColour();
        }
        if (this.fset instanceof AnnotatedFeatureI) {
            AnnotatedFeatureI annot = (AnnotatedFeatureI)this.fset;
            return Config.getAnnotationColor(annot);
        }
        FeatureProperty prop = Config.getPropertyScheme().getFeatureProperty(this.fset.getTopLevelType());
        return prop.getColour();
    }

    private class CopyAction
    implements ActionListener {
        private CopyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ClipboardUtil.copyTextToClipboard(SetDetailPanel.this.descBox.getSelectedText());
        }
    }
}

