/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.evidencepanel;

import apollo.config.Config;
import apollo.gui.ApolloFrame;
import apollo.gui.evidencepanel.EvidencePanelContainer;
import apollo.gui.synteny.SyntenyPanel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSplitPane;

public class EvidencePanelOrientationManager {
    private int orientation = 2;
    private OrientAction action;
    private ApolloFrame apolloFrame = ApolloFrame.getApolloFrame();
    private static EvidencePanelOrientationManager singleton;

    public static EvidencePanelOrientationManager getSingleton() {
        if (singleton == null) {
            singleton = new EvidencePanelOrientationManager();
        }
        return singleton;
    }

    private EvidencePanelOrientationManager() {
        this.setOrientationFromString(Config.getFrameOrientation());
        this.action = new OrientAction(this.getOrientationMenuString());
        this.action.setEnabled(true);
    }

    private EvidencePanelContainer getEvidencePanelContainer() {
        return EvidencePanelContainer.getSingleton();
    }

    private JSplitPane getSplitPane() {
        return this.apolloFrame.getSplitPane();
    }

    private SyntenyPanel getSyntenyPanel() {
        return this.apolloFrame.getSyntenyPanel();
    }

    private int getPreferredFrameHeight() {
        return this.apolloFrame.getPreferredFrameHeight();
    }

    private void setOrientationFromString(String orientString) {
        if (orientString.equalsIgnoreCase("vertical")) {
            this.orientation = 1;
        } else if (orientString.equalsIgnoreCase("horizontal")) {
            this.orientation = 2;
        }
    }

    public Action getAction() {
        return this.action;
    }

    public void orientEvidencePanels() {
        if (this.orientation == 2) {
            this.setHorizontalLayout();
        } else if (this.orientation == 1) {
            this.setVerticalLayout();
        }
        this.getAction().putValue("Name", this.getOrientationMenuString());
    }

    private void setVerticalLayout() {
        this.getSplitPane().remove(this.getSyntenyPanel());
        this.getSplitPane().remove(this.getEvidencePanelContainer());
        this.getSplitPane().setOrientation(1);
        this.getSplitPane().setLeftComponent(this.getEvidencePanelContainer());
        this.getSplitPane().setRightComponent(this.getSyntenyPanel());
        this.getEvidencePanelContainer().setOrientation(1);
    }

    private void setHorizontalLayout() {
        this.getSplitPane().remove(this.getSyntenyPanel());
        this.getSplitPane().remove(this.getEvidencePanelContainer());
        this.getSplitPane().remove(this.getSyntenyPanel());
        this.getSplitPane().setOrientation(0);
        this.getSplitPane().setTopComponent(this.getSyntenyPanel());
        this.getSplitPane().setBottomComponent(this.getEvidencePanelContainer());
        int evidencePanelHeight = Config.getStyle().getEvidencePanelHeight();
        this.getSplitPane().setDividerLocation(this.getPreferredFrameHeight() - evidencePanelHeight);
        this.getEvidencePanelContainer().setOrientation(2);
    }

    private String getOrientationMenuString() {
        if (this.orientation == 2) {
            return "Make evidence panel vertical";
        }
        return "Make evidence panel horizontal";
    }

    private class OrientAction
    extends AbstractAction {
        public OrientAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if (EvidencePanelOrientationManager.this.orientation == 2) {
                EvidencePanelOrientationManager.this.orientation = 1;
            } else {
                EvidencePanelOrientationManager.this.orientation = 2;
            }
            EvidencePanelOrientationManager.this.orientEvidencePanels();
        }
    }
}

