/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.drawable;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.datamodel.AbstractSequence;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.gui.SelectableI;
import apollo.gui.TierManagerI;
import apollo.gui.Transformer;
import apollo.gui.drawable.Drawable;
import apollo.gui.drawable.DrawableSeqFeature;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Date;

public class DrawableResultSeqFeature
extends DrawableSeqFeature
implements Drawable,
SelectableI {
    public DrawableResultSeqFeature() {
        super(true);
    }

    public DrawableResultSeqFeature(SeqFeatureI feature) {
        super(feature, true);
    }

    protected void addDecorations(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        FeaturePair fp;
        SeqFeatureI hit;
        SequenceI seq;
        super.addDecorations(g, boxBounds, transformer, manager);
        Date recentDate = this.getFeatureProperty().getRecentDate();
        if (recentDate != null && this.getFeature() instanceof FeaturePair && (seq = (hit = (fp = (FeaturePair)this.getFeature()).getHitFeature()).getRefSequence()) != null && ((AbstractSequence)seq).isNewerThan(recentDate)) {
            g.setColor(Config.getEdgematchColor());
            g.drawRect(boxBounds.x - 2, boxBounds.y - 2, boxBounds.width + 3, boxBounds.height + 3);
        }
        if (this.tagged()) {
            int zagInterval;
            Color taggedColor = Config.getStyle().getTaggedColor();
            g.setColor(taggedColor);
            int hatch_width = boxBounds.height;
            if (boxBounds.width <= hatch_width) {
                zagInterval = boxBounds.width;
            } else {
                zagInterval = hatch_width;
                int adjust = boxBounds.width % zagInterval;
                if ((double)adjust > (double)zagInterval * 0.5) {
                    int zig_count = boxBounds.width / zagInterval;
                    zagInterval = (int)((double)boxBounds.width / (double)zig_count + 1.0);
                }
            }
            int x_end = boxBounds.x + boxBounds.width;
            int y_start = boxBounds.y;
            int y_end = boxBounds.y + boxBounds.height;
            for (int zig_Xstart = boxBounds.x; zig_Xstart < x_end; zig_Xstart += zagInterval) {
                int zig_Xend = zig_Xstart + zagInterval;
                if (zig_Xend > x_end) {
                    zig_Xend = x_end;
                }
                g.drawLine(zig_Xstart, y_start, zig_Xend, y_end);
                g.drawLine(zig_Xstart, y_end, zig_Xend, y_start);
            }
        }
        if (transformer.getXPixelsPerCoord() >= 5.0 && this.getFeature() instanceof FeaturePair) {
            fp = (FeaturePair)this.getFeature();
            hit = fp.getHitFeature();
            String align_seq = fp.getHitFeature().getAlignment();
            if ((align_seq == null || align_seq.equals("")) && hit.getRefSequence() != null && hit.getLow() >= 0) {
                align_seq = hit.getRefSequence().getResidues(hit.getLow(), hit.getHigh());
            }
            if (align_seq != null && !align_seq.equals("")) {
                this.drawAlignSeq(g, transformer, fp, align_seq, boxBounds);
            }
        }
    }

    private void drawAlignSeq(Graphics g, Transformer transformer, FeaturePair fp, String align_seq, Rectangle box) {
        SeqFeatureI result = fp.getRefFeature();
        int leftCoord = this.getLow();
        int rightCoord = this.getHigh();
        int[] visRange = transformer.getXVisibleRange();
        int seq_screen_start = 0;
        if (leftCoord < visRange[0]) {
            seq_screen_start = visRange[0] - leftCoord;
            leftCoord = visRange[0];
            if (this.isProtein(result)) {
                leftCoord = this.isForwardStrand() ? (leftCoord -= seq_screen_start % 3) : (leftCoord -= seq_screen_start % 3 + 1);
            }
        } else if (this.isProtein(result) && !this.isForwardStrand()) {
            leftCoord += 2;
        }
        int seq_screen_stop = 0;
        if (rightCoord > visRange[1]) {
            seq_screen_stop = rightCoord - visRange[1];
            rightCoord = visRange[1];
        }
        FontMetrics fm = g.getFontMetrics();
        int res_y = this.getCharY(fm, box);
        int coord_increment = 1;
        boolean forward = transformer.getXOrientation() == 1;
        Color fontColor = this.fontColorForBackground(this.getFeatureProperty().getColour());
        g.setColor(fontColor);
        for (int i = leftCoord; i <= rightCoord; i += coord_increment) {
            int index = (this.isForwardStrand() ? i - leftCoord + seq_screen_start : rightCoord - i + seq_screen_stop) / coord_increment;
            String res = index + 1 < align_seq.length() ? align_seq.substring(index, index + 1) : (index < align_seq.length() ? align_seq.substring(index) : " ");
            int offset = (int)(transformer.getXPixelsPerCoord() / 2.0 - (double)(fm.stringWidth(res) / 2));
            int res_x = forward ? transformer.toPixelX(i - 1) : transformer.toPixelX(i);
            g.drawString(res, res_x += offset, res_y);
        }
    }

    private boolean isProtein(SeqFeatureI result) {
        SeqFeatureI analysis = result;
        String program = null;
        if (analysis != null) {
            program = analysis.getProgramName();
        }
        if (program != null && ((program = program.toLowerCase()).indexOf("blastp") >= 0 || program.indexOf("blastx") >= 0)) {
            return true;
        }
        FeatureProperty fp = this.getFeatureProperty();
        if (fp.getTier().getLabel().indexOf("Protein") >= 0) {
            return true;
        }
        return fp.getTier().isProtein();
    }

    private boolean tagged() {
        String tag = this.getFeature().getRefFeature().getProperty("tag");
        return tag != null && !tag.equals("");
    }
}

