/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.detailviewers.exonviewer;

import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.gui.detailviewers.exonviewer.BaseRenderer;
import apollo.gui.detailviewers.exonviewer.DefaultBaseRenderer;
import apollo.gui.detailviewers.exonviewer.FeatureWrapper;
import apollo.gui.detailviewers.exonviewer.SeqAlignPanel;
import java.util.Enumeration;
import java.util.Vector;
import org.bdgp.util.Range;
import org.bdgp.util.RangeHash;

class SeqWrapper {
    protected SequenceI seq;
    protected int phase;
    protected BaseRenderer rend;
    protected String seq_type = "DNA";
    protected RangeHash featureSets;
    private RangeHash seqFeatures;
    protected boolean visible = true;
    private SeqAlignPanel seqAlignPanel;

    public SeqWrapper(SequenceI seq, int phase, String seq_type, SeqAlignPanel panel) {
        this(seq, phase, seq_type, new DefaultBaseRenderer(panel.getCharWidth(), panel.getCharHeight()), panel);
    }

    private SeqWrapper(SequenceI seq, int phase, String seq_type, BaseRenderer rend, SeqAlignPanel panel) {
        this.seq = seq;
        this.phase = phase;
        this.seq_type = seq_type;
        this.rend = rend;
        this.featureSets = new RangeHash();
        this.seqFeatures = new RangeHash();
        this.seqAlignPanel = panel;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public BaseRenderer getRenderer() {
        return this.rend;
    }

    public void setRenderer(BaseRenderer rend) {
        this.rend = rend;
    }

    public SequenceI getSequence() {
        return this.seq;
    }

    private boolean existsAt(int i) {
        int pos = i;
        if (this.seq.hasResidueType() && this.seq.getResidueType().equals("AA")) {
            pos = i / 3;
        }
        return pos >= 0 && pos < this.seq.getLength();
    }

    public char getCharAt(int pos) {
        if (this.existsAt(pos)) {
            if (this.seq.hasResidueType() && this.seq.getResidueType().equals("AA")) {
                if (this.phase == pos % 3) {
                    return this.seq.getBaseAt(pos / 3);
                }
            } else if (this.seq_type.equals("AA")) {
                if (this.phase == pos % 3 && pos + 2 <= this.seq.getLength()) {
                    String codon = this.seq.getResidues(pos, pos + 2);
                    return codon.charAt(0);
                }
            } else {
                int index = this.seqAlignPanel.posToResidue(pos);
                if (index <= this.seqAlignPanel.getLongestSeq()) {
                    return this.seq.getBaseAt(index);
                }
                return '\u0000';
            }
        }
        return '\u0000';
    }

    public Vector getFeaturesInRange(int startpos, int endpos) {
        Vector features = this.seqFeatures.get(startpos, endpos);
        if (features.size() == 0) {
            features = this.featureSets.get(startpos, endpos);
        }
        Vector<SeqFeatureI> out = new Vector<SeqFeatureI>();
        for (int i = 0; i < features.size(); ++i) {
            out.addElement(((FeatureWrapper)features.elementAt(i)).getFeature());
        }
        return out;
    }

    public SeqFeatureI getFeatureAtPosition(int pos) {
        FeatureWrapper out = (FeatureWrapper)this.seqFeatures.get(pos);
        if (out == null) {
            out = (FeatureWrapper)this.featureSets.get(pos);
        }
        if (out == null) {
            return null;
        }
        return out.getFeature();
    }

    public FeatureSetI getFeatureSetAtPosition(int pos) {
        FeatureWrapper out = (FeatureWrapper)this.featureSets.get(pos);
        if (out != null && out.getFeature().canHaveChildren()) {
            return (FeatureSetI)out.getFeature();
        }
        return null;
    }

    protected FeatureWrapper getFeatureWrapperAtPosition(int pos) {
        FeatureWrapper out = (FeatureWrapper)this.seqFeatures.get(pos);
        if (out == null) {
            out = (FeatureWrapper)this.featureSets.get(pos);
        }
        if (out == null) {
            return null;
        }
        return out;
    }

    public int getTypeAtPosition(int pos) {
        SeqFeatureI feature = this.getFeatureAtPosition(pos);
        if (feature == null) {
            return -1;
        }
        if (feature.canHaveChildren()) {
            return 4;
        }
        return 5;
    }

    public double[] getRangeAtPosition(int pos) {
        double[] output = this.seqFeatures.getInterval(pos);
        return output;
    }

    public int getRangeIndex(int low, int high) {
        return this.featureSets.getIntervalIndex(low, high);
    }

    public int getExonRangeIndex(int low, int high) {
        return this.seqFeatures.getIntervalIndex(low, high);
    }

    public int getExonRangeIndex(int low, int high, boolean exact) {
        return this.seqFeatures.getIntervalIndex(low, high, exact);
    }

    public int getFeatureCount() {
        return this.seqFeatures.size();
    }

    public SeqFeatureI getFeatureAtIndex(int index) {
        if (index < 0 || index >= this.seqFeatures.size()) {
            return null;
        }
        return ((FeatureWrapper)this.seqFeatures.getItemAtIndex(index)).getFeature();
    }

    public int getBoundaryType(int pos) {
        FeatureWrapper fw = this.getFeatureWrapperAtPosition(pos);
        if (fw == null) {
            return 0;
        }
        if (fw.getLow() == pos) {
            return 1;
        }
        if (fw.getHigh() == pos) {
            return 2;
        }
        return 0;
    }

    public void addFeature(SeqFeatureI in) {
        if (in.hasKids()) {
            FeatureSetI fs = (FeatureSetI)in;
            FeatureWrapper wrap = new FeatureWrapper(fs, this);
            this.featureSets.put((Range)wrap, (Object)wrap);
            for (int i = 0; i < fs.getFeatures().size(); ++i) {
                SeqFeatureI sf = (SeqFeatureI)fs.getFeatures().elementAt(i);
                FeatureWrapper fwrap = new FeatureWrapper(sf, this);
                this.seqFeatures.put((Range)fwrap, (Object)fwrap);
            }
        } else {
            FeatureWrapper fw = new FeatureWrapper(in, this);
            this.seqFeatures.put((Range)fw, (Object)fw);
            if (this.seqAlignPanel.isOneLevelAnnot(in)) {
                this.featureSets.put((Range)fw, (Object)fw);
            }
        }
    }

    public void removeFeature(FeatureSetI fs) {
        Enumeration e = this.featureSets.values();
        this.featureSets = new RangeHash();
        this.seqFeatures = new RangeHash();
        while (e.hasMoreElements()) {
            SeqFeatureI sf = ((FeatureWrapper)e.nextElement()).getFeature();
            if (sf == fs) continue;
            this.addFeature(sf);
        }
    }

    public Vector getFeatures() {
        Vector out = new Vector();
        Enumeration e = this.featureSets.values();
        while (e.hasMoreElements()) {
            out.addElement(e.nextElement());
        }
        return out;
    }

    int basePairToPos(int bp) {
        return this.seqAlignPanel.basePairToPos(bp);
    }
}

