/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.detailviewers.exonviewer;

import apollo.config.Config;
import apollo.datamodel.SequenceI;
import apollo.gui.detailviewers.exonviewer.BaseEditorPanel;
import apollo.gui.detailviewers.exonviewer.DefaultBaseRenderer;
import apollo.gui.detailviewers.exonviewer.SeqAlignPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Vector;

public class AminoAcidRenderer
extends DefaultBaseRenderer {
    private static Hashtable colors = new Hashtable();
    Color bgcolor;
    Color disabled = new Color(200, 200, 200);
    int phase;
    Font regularFont = Config.getExonDetailEditorSequenceFont();
    Font boldFont = Config.getExonDetailEditorSequenceFont();
    SeqAlignPanel panel;
    Color hatchColor;

    public AminoAcidRenderer(int width, int height, int phase, SeqAlignPanel panel) {
        super(width, height);
        this.setFontSizes(12);
        this.phase = phase;
        this.panel = panel;
    }

    public void setFontSizes(int size) {
        this.regularFont = new Font("Courier", 0, size);
        this.boldFont = new Font("Dialog", 1, size);
    }

    public Color getHatchColor() {
        return this.hatchColor;
    }

    public Component getBaseRendererComponent(char base, int pos, int tier, SequenceI seq) {
        if (this.panel instanceof BaseEditorPanel && ((BaseEditorPanel)this.panel).getShowHitZones()) {
            Vector hitZones = ((BaseEditorPanel)this.panel).getTranslatedHitZones(this.phase);
            this.hatchColor = null;
            for (int hitIndex = 0; hitZones != null && hitIndex < hitZones.size(); ++hitIndex) {
                int[] hitZone = (int[])hitZones.elementAt(hitIndex);
                if (pos < hitZone[0] * 3 + this.phase || pos >= hitZone[1] * 3 + this.phase) continue;
                this.hatchColor = Color.yellow;
                break;
            }
        }
        if (colors.get(base + "") == null) {
            this.setFont(this.regularFont);
        } else {
            this.setFont(this.boldFont);
        }
        return super.getBaseRendererComponent(base, pos, tier, seq);
    }

    public Color getTextColor() {
        Color stored = (Color)colors.get(this.c + "");
        if (stored == null) {
            return this.disabled;
        }
        return stored;
    }

    static {
        colors.put("M", Color.green);
        colors.put("*", Color.red);
    }
}

