/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SequenceI;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Pattern;

public class SequenceSelector {
    RangeI sf;
    boolean reverseComplement = false;
    boolean useRegExp;
    int start;
    int end;
    String queryString;
    Vector zones = new Vector();
    int curInd;
    int blockSize = 100000;
    int contextLen = 35;

    public SequenceSelector(RangeI sf, String queryStr) {
        this(sf, queryStr, false, false);
    }

    public SequenceSelector(RangeI sf, String queryStr, boolean reverseComplement) {
        this(sf, queryStr, reverseComplement, false);
    }

    public SequenceSelector(RangeI sf, String queryStr, boolean reverseComplement, boolean useRegExp) {
        this.queryString = queryStr;
        this.sf = sf;
        this.start = sf.getStart();
        this.end = sf.getEnd();
        this.useRegExp = useRegExp;
        if (this.start > this.end) {
            int tmp = this.start;
            this.start = this.end;
            this.end = tmp;
        }
        if (sf.getRefSequence().getLength() < 3 * this.blockSize) {
            this.blockSize = sf.getRefSequence().getLength() / 3;
        }
        this.reverseComplement = reverseComplement;
        this.findMatches();
    }

    public int findMatches() {
        String correctedQueryString = !this.useRegExp ? this.cleanUpNonRegExpString(this.queryString) : this.queryString;
        if (this.reverseComplement) {
            correctedQueryString = this.revCompRegExp(correctedQueryString);
        }
        Perl5Compiler p5Compiler = new Perl5Compiler();
        Perl5Pattern pattern = null;
        Perl5Pattern defaultPattern = null;
        Perl5Matcher matcher = new Perl5Matcher();
        try {
            defaultPattern = (Perl5Pattern)p5Compiler.compile("invalid perl5 expression");
            pattern = (Perl5Pattern)p5Compiler.compile(correctedQueryString, 1);
        }
        catch (MalformedPatternException ex) {
            pattern = defaultPattern;
        }
        PatternMatcherInput pmInput = null;
        int chunkLen = this.blockSize + 2 * correctedQueryString.length();
        SequenceI seq = this.sf.getRefSequence();
        for (int i = this.start; i <= this.end; i += this.blockSize) {
            String seqString = seq.getResidues(i, i + chunkLen);
            pmInput = new PatternMatcherInput(seqString);
            while (matcher.contains(pmInput, (Pattern)pattern)) {
                int matchPos = pmInput.getMatchBeginOffset() + i;
                int matchEnd = pmInput.getMatchEndOffset() + i - 1;
                if (this.reverseComplement && matchPos < 1) {
                    matchPos = 1;
                }
                int[] match_positions = new int[]{matchPos, matchEnd};
                this.zones.add(match_positions);
            }
        }
        return this.zones.size();
    }

    public int getMatchCount() {
        return this.zones.size();
    }

    public Vector getMatches() {
        int match_cnt = this.zones.size();
        Vector<SeqFeature> matches = new Vector<SeqFeature>();
        for (int i = 0; i < match_cnt; ++i) {
            int[] match_positions = (int[])this.zones.elementAt(i);
            int strand = this.reverseComplement ? -1 : 1;
            SeqFeature match = new SeqFeature(match_positions[0], match_positions[1], "Sequence selection", strand);
            match.setRefSequence(this.sf.getRefSequence());
            matches.add(match);
        }
        return matches;
    }

    public Vector getZones() {
        return this.zones;
    }

    String revCompRegExp(String inString) {
        char[] charArray = inString.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] == 'a' || charArray[i] == 'A') {
                charArray[i] = 84;
                continue;
            }
            if (charArray[i] == 'c' || charArray[i] == 'C') {
                charArray[i] = 71;
                continue;
            }
            if (charArray[i] == 'g' || charArray[i] == 'G') {
                charArray[i] = 67;
                continue;
            }
            if (charArray[i] != 't' && charArray[i] != 'T') continue;
            charArray[i] = 65;
        }
        return this.reversedRegExp(new String(charArray));
    }

    String reversedRegExp(String inString) {
        boolean inside_bracket = false;
        int num_cons_backslashes = 0;
        String revString = new String();
        String starter = "";
        String ender = "";
        char[] charString = inString.toCharArray();
        StringBuffer saveChar = new StringBuffer();
        for (int i = 0; i < charString.length; ++i) {
            if (i == 0) {
                if (charString[i] == '^') {
                    starter = "^";
                    continue;
                }
            } else if (i == charString.length - 1 && charString[i] == '$') {
                ender = "$";
                continue;
            }
            boolean bl = inside_bracket = inside_bracket || charString[i] == '[' && num_cons_backslashes % 2 == 0;
            if (inside_bracket && num_cons_backslashes % 2 == 0 && charString[i] == ']') {
                inside_bracket = false;
            }
            num_cons_backslashes = charString[i] == '\\' ? ++num_cons_backslashes : 0;
            if (!inside_bracket && num_cons_backslashes % 2 == 0) {
                if (charString[i] == '*' || charString[i] == '+' || charString[i] == '?' || charString[i] == 'A' || charString[i] == 'T' || charString[i] == 'G' || charString[i] == 'C' || charString[i] == 'N') {
                    revString = charString[i] + saveChar.toString() + revString;
                    saveChar = new StringBuffer();
                    continue;
                }
                saveChar.append(String.valueOf(charString[i]));
                continue;
            }
            saveChar.append(String.valueOf(charString[i]));
        }
        revString = starter + saveChar.toString() + revString + ender;
        return revString;
    }

    String cleanUpNonRegExpString(String in) {
        StringBuffer cleaned = new StringBuffer();
        char[] chars = in.toCharArray();
        block4: for (int index = 0; index < chars.length; ++index) {
            switch (chars[index]) {
                case '*': {
                    cleaned.append(".*");
                    continue block4;
                }
                case 'A': 
                case 'C': 
                case 'G': 
                case 'N': 
                case 'T': 
                case 'a': 
                case 'c': 
                case 'g': 
                case 'n': 
                case 't': {
                    cleaned.append(chars[index]);
                }
            }
        }
        return cleaned.toString();
    }
}

