/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.AbstractDataAdapterUI;

public abstract class GenericFileAdapterGUI
extends AbstractDataAdapterUI {
    public static final int MAX_HISTORY_LENGTH = 5;
    protected DataAdapter driver;
    protected IOOperation op;
    protected JComboBox pathList;
    protected JPanel panel;
    protected JPanel panel2;
    protected JLabel typeLabel;
    protected Vector filePaths;
    JButton browseButton;
    protected Properties props;
    int pathListWidth = 500;

    public GenericFileAdapterGUI() {
    }

    public GenericFileAdapterGUI(IOOperation op) {
        this.op = op;
        this.initGUI();
        this.buildGUI();
        this.attachListeners();
    }

    public void initGUI() {
        this.pathList = new JComboBox();
        this.filePaths = new Vector();
        this.browseButton = new JButton("Browse...");
        this.typeLabel = new JLabel("File type not set");
        this.pathList.setEditable(true);
    }

    public void buildGUI() {
        this.panel = new JPanel();
        this.pathList.setFont(this.getFont());
        this.browseButton.setFont(this.getFont());
        this.pathList.setAlignmentY(0.5f);
        this.browseButton.setAlignmentY(0.5f);
        this.pathList.setPreferredSize(new Dimension(this.pathListWidth, 10));
        this.setLayout(new BorderLayout());
        this.panel.setLayout(new BorderLayout());
        this.panel2 = new JPanel();
        this.panel2.setLayout(new BoxLayout(this.panel2, 0));
        this.panel2.add(this.pathList);
        this.panel2.add(this.browseButton);
        this.panel.add(this.panel2);
        this.add("South", this.panel);
    }

    public void attachListeners() {
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GenericFileAdapterGUI.this.browseFiles(GenericFileAdapterGUI.this.pathList);
            }
        });
    }

    public void browseFiles(JComboBox list) {
        String selectedPath = this.getSelectedPath();
        File currentFile = new File(selectedPath);
        File browseFile = GenericFileAdapterGUI.fileBrowser(currentFile, (Component)((Object)this));
        if (browseFile == null) {
            return;
        }
        list.configureEditor(list.getEditor(), browseFile.toString());
    }

    public static File fileBrowser(File currentFile, Component parent) {
        String startPath = currentFile != null && currentFile.exists() ? currentFile.getPath() : System.getProperty("user.home");
        JFileChooser chooser = new JFileChooser(startPath);
        int returnVal = chooser.showOpenDialog(parent);
        File file = chooser.getSelectedFile();
        if (file == null) {
            JOptionPane.showMessageDialog(parent, "No file selected", "Error", 0);
            return null;
        }
        if (returnVal != 0) {
            return null;
        }
        return file;
    }

    public void setDataAdapter(DataAdapter driver) {
        this.driver = driver;
        this.typeLabel.setText(driver.getType());
    }

    public void setProperties(Properties in) {
        this.props = in;
        if (this.props == null) {
            return;
        }
        this.filePaths = new Vector();
        String historyItems = this.props.getProperty("historyItems");
        if (historyItems == null || Integer.parseInt(historyItems) == 0) {
            System.out.println("No history for this file adapter");
            return;
        }
        try {
            int items = Integer.parseInt(historyItems);
            for (int i = 0; i < items; ++i) {
                this.filePaths.addElement(this.props.getProperty("historyItem" + i));
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Can't parse history file");
        }
        this.pathList.setModel(new DefaultComboBoxModel(this.filePaths));
    }

    public Properties getProperties() {
        String selectedPath = this.getSelectedPath();
        this.filePaths.removeElement(selectedPath);
        this.filePaths.insertElementAt(selectedPath, 0);
        Properties out = new Properties();
        if (this.filePaths.size() > 5) {
            out.put("historyItems", "5");
        } else {
            out.put("historyItems", this.filePaths.size() + "");
        }
        for (int i = 0; i < this.filePaths.size() && i < 5; ++i) {
            out.put("historyItem" + i, (String)this.filePaths.elementAt(i));
        }
        return out;
    }

    public String getSelectedPath() {
        String selectedPath = (String)this.pathList.getSelectedItem();
        if (selectedPath == null || !selectedPath.equals(this.pathList.getEditor().getItem())) {
            selectedPath = (String)this.pathList.getEditor().getItem();
        }
        return selectedPath;
    }

    public boolean validOperation() throws DataAdapterException {
        return true;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public int getPathListWidth() {
        return this.pathListWidth;
    }

    public void setPathListWidth(int width) {
        this.pathListWidth = width;
    }
}

