/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.config.Config;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Synonym;
import apollo.editor.AnnotationEditor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TransactionSubpart
implements Serializable {
    private static Map stringToSubpart = new HashMap();
    public static TransactionSubpart PARENT = new TransactionSubpart("PARENT", class$apollo$datamodel$SeqFeatureI == null ? (class$apollo$datamodel$SeqFeatureI = TransactionSubpart.class$("apollo.datamodel.SeqFeatureI")) : class$apollo$datamodel$SeqFeatureI);
    public static TransactionSubpart ID = new IdSubpart();
    public static TransactionSubpart NAME = new NameSubpart();
    public static TransactionSubpart TYPE = new TypeSubpart();
    public static TransactionSubpart COMMENT = new TransactionSubpart("COMMENT", class$apollo$datamodel$Comment == null ? (class$apollo$datamodel$Comment = TransactionSubpart.class$("apollo.datamodel.Comment")) : class$apollo$datamodel$Comment);
    public static TransactionSubpart SYNONYM = new SynonymSubpart();
    public static TransactionSubpart LIMITS = new TransactionSubpart("LIMITS", class$apollo$datamodel$RangeI == null ? (class$apollo$datamodel$RangeI = TransactionSubpart.class$("apollo.datamodel.RangeI")) : class$apollo$datamodel$RangeI);
    public static TransactionSubpart PEPTIDE_LIMITS = new TransactionSubpart("PEPTIDE_LIMITS", class$apollo$datamodel$RangeI == null ? (class$apollo$datamodel$RangeI = TransactionSubpart.class$("apollo.datamodel.RangeI")) : class$apollo$datamodel$RangeI);
    public static TransactionSubpart PEPTIDE_NAME = new PeptideNameSubpart();
    public static TransactionSubpart PEPTIDE_ID = new PeptideIdSubpart();
    public static TransactionSubpart CDNA_NAME = new CdnaNameSubpart();
    public static TransactionSubpart REPLACE_STOP = new TransactionSubpart("REPLACE_STOP", class$java$lang$Boolean == null ? (class$java$lang$Boolean = TransactionSubpart.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    public static TransactionSubpart PLUS_1_FRAMESHIFT = new TransactionSubpart("PLUS_1_FRAMESHIFT", class$java$lang$Integer == null ? (class$java$lang$Integer = TransactionSubpart.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static TransactionSubpart MINUS_1_FRAMESHIFT = new TransactionSubpart("MINUS_1_FRAMESHIFT", class$java$lang$Integer == null ? (class$java$lang$Integer = TransactionSubpart.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static TransactionSubpart NON_CONSENSUS_SPLICE_OKAY = new TransactionSubpart("NON_CONSENSUS_SPLICE_OKAY", class$java$lang$Boolean == null ? (class$java$lang$Boolean = TransactionSubpart.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    public static TransactionSubpart IS_DICISTRONIC = new TransactionSubpart("dicistronic", class$java$lang$Boolean == null ? (class$java$lang$Boolean = TransactionSubpart.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    public static TransactionSubpart IS_PROBLEMATIC = new TransactionSubpart("IS_PROBLEMATIC", class$java$lang$Boolean == null ? (class$java$lang$Boolean = TransactionSubpart.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    public static TransactionSubpart FINISHED = new TransactionSubpart("FINISHED", class$java$lang$Boolean == null ? (class$java$lang$Boolean = TransactionSubpart.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    public static TransactionSubpart DBXREF = new TransactionSubpart("DBXREF", class$apollo$datamodel$DbXref == null ? (class$apollo$datamodel$DbXref = TransactionSubpart.class$("apollo.datamodel.DbXref")) : class$apollo$datamodel$DbXref);
    public static TransactionSubpart DESCRIPTION = new TransactionSubpart("DESCRIPTION", class$java$lang$String == null ? (class$java$lang$String = TransactionSubpart.class$("java.lang.String")) : class$java$lang$String);
    private String subpartString;
    private Class type;
    static /* synthetic */ Class class$apollo$datamodel$SeqFeatureI;
    static /* synthetic */ Class class$apollo$datamodel$Comment;
    static /* synthetic */ Class class$apollo$datamodel$RangeI;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$apollo$datamodel$DbXref;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$apollo$datamodel$Synonym;

    private TransactionSubpart(String subpartString, Class type) {
        this.subpartString = subpartString;
        stringToSubpart.put(subpartString, this);
        this.type = type;
    }

    public String toString() {
        return this.subpartString;
    }

    public static TransactionSubpart stringToSubpart(String subpartString) {
        return (TransactionSubpart)stringToSubpart.get(subpartString);
    }

    public boolean isBoolean() {
        if (this.type == null) {
            return false;
        }
        return this.type.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TransactionSubpart.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    public boolean isString() {
        if (this.type == null) {
            return false;
        }
        return this.type.equals(class$java$lang$String == null ? (class$java$lang$String = TransactionSubpart.class$("java.lang.String")) : class$java$lang$String);
    }

    public boolean isType() {
        return this == TYPE;
    }

    public boolean isId() {
        return false;
    }

    public boolean isInt() {
        if (this.type == null) {
            return false;
        }
        return this.type.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = TransactionSubpart.class$("java.lang.Integer")) : class$java$lang$Integer);
    }

    public boolean isName() {
        return this == NAME;
    }

    public boolean isComment() {
        return this == COMMENT;
    }

    public boolean isSynonym() {
        return this == SYNONYM;
    }

    public boolean isLimits() {
        return this.type.equals(class$apollo$datamodel$RangeI == null ? (class$apollo$datamodel$RangeI = TransactionSubpart.class$("apollo.datamodel.RangeI")) : class$apollo$datamodel$RangeI);
    }

    public void setValue(SeqFeatureI feat, Object value) {
        if (AnnotationEditor.DEBUG) {
            System.out.println("\nsetValue called with no subclass for subpart " + this + "\n");
        }
    }

    public void setValue(SeqFeatureI feat, Object value, boolean isAdd) {
        if (AnnotationEditor.DEBUG) {
            System.out.println("\nsetValue called with no subclass for subpart " + this + "\n");
        }
    }

    private void checkValue(Object value) {
        if (Config.DEBUG && value == null) {
            System.out.println("DEBUG: Value for subpart " + this + " is null");
        }
        if (!this.valueIsCorrectType(value)) {
            String m = "Wrong type for subpart " + this + " got " + value.getClass() + " expected " + this.type;
            throw new RuntimeException(m);
        }
    }

    private boolean valueIsCorrectType(Object value) {
        if (value == null) {
            return true;
        }
        return value.getClass().equals(this.type);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SynonymSubpart
    extends TransactionSubpart {
        private SynonymSubpart() {
            super("SYNONYM", class$apollo$datamodel$Synonym == null ? (class$apollo$datamodel$Synonym = TransactionSubpart.class$("apollo.datamodel.Synonym")) : class$apollo$datamodel$Synonym);
        }

        public void setValue(SeqFeatureI feat, Object syn, boolean isAdd) {
            if (feat == null || !feat.hasAnnotatedFeature() || syn == null) {
                AnnotationEditor.debugPrint("Failed to set syn val feat " + feat + " syn " + syn);
                return;
            }
            ((TransactionSubpart)this).checkValue(syn);
            AnnotatedFeatureI annot = feat.getAnnotatedFeature();
            if (isAdd) {
                annot.addSynonym((Synonym)syn);
            } else {
                annot.deleteSynonym((Synonym)syn);
            }
        }
    }

    private static class CdnaNameSubpart
    extends TransactionSubpart {
        private CdnaNameSubpart() {
            super("CDNA_NAME", class$java$lang$String == null ? (class$java$lang$String = TransactionSubpart.class$("java.lang.String")) : class$java$lang$String);
        }

        public void setValue(SeqFeatureI feat, Object name) {
            ((TransactionSubpart)this).checkValue(name);
            if (!feat.hasAnnotatedFeature()) {
                return;
            }
            feat.getAnnotatedFeature().get_cDNASequence().setAccessionNo((String)name);
        }
    }

    private static class PeptideIdSubpart
    extends TransactionSubpart {
        private PeptideIdSubpart() {
            super("PEPTIDE_ID", class$java$lang$String == null ? (class$java$lang$String = TransactionSubpart.class$("java.lang.String")) : class$java$lang$String);
        }

        public void setValue(SeqFeatureI feat, Object name) {
            ((TransactionSubpart)this).checkValue(name);
            feat.getPeptideSequence().setAccessionNo((String)name);
        }
    }

    private static class PeptideNameSubpart
    extends TransactionSubpart {
        private PeptideNameSubpart() {
            super("PEPTIDE_NAME", class$java$lang$String == null ? (class$java$lang$String = TransactionSubpart.class$("java.lang.String")) : class$java$lang$String);
        }

        public void setValue(SeqFeatureI feat, Object name) {
            ((TransactionSubpart)this).checkValue(name);
            feat.getPeptideSequence().setName((String)name);
        }
    }

    private static class IdSubpart
    extends TransactionSubpart {
        private IdSubpart() {
            super("ID", class$java$lang$String == null ? (class$java$lang$String = TransactionSubpart.class$("java.lang.String")) : class$java$lang$String);
        }

        public boolean isId() {
            return true;
        }

        public void setValue(SeqFeatureI feat, Object id) {
            ((TransactionSubpart)this).checkValue(id);
            feat.setId((String)id);
        }
    }

    private static class TypeSubpart
    extends TransactionSubpart {
        private TypeSubpart() {
            super("TYPE", class$java$lang$String == null ? (class$java$lang$String = TransactionSubpart.class$("java.lang.String")) : class$java$lang$String);
        }

        public boolean isType() {
            return true;
        }

        public void setValue(SeqFeatureI feat, Object type) {
            ((TransactionSubpart)this).checkValue(type);
            feat.setFeatureType((String)type);
            feat.setTopLevelType((String)type);
        }
    }

    private static class NameSubpart
    extends TransactionSubpart {
        private NameSubpart() {
            super("NAME", class$java$lang$String == null ? (class$java$lang$String = TransactionSubpart.class$("java.lang.String")) : class$java$lang$String);
        }

        public boolean isName() {
            return true;
        }

        public void setValue(SeqFeatureI feat, Object name) {
            ((TransactionSubpart)this).checkValue(name);
            feat.setName((String)name);
        }
    }
}

