/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.datamodel.SeqFeatureI;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationDeleteEvent;
import apollo.editor.Transaction;
import apollo.editor.TransactionSubpart;

public class DeleteTransaction
extends Transaction {
    private SeqFeatureI parentFeature;
    private int deletedSubpartRank;

    public DeleteTransaction() {
    }

    public DeleteTransaction(SeqFeatureI feature, SeqFeatureI parent) {
        this.setSeqFeature(feature);
        this.parentFeature = parent;
    }

    public DeleteTransaction(SeqFeatureI feature, SeqFeatureI parent, Object source) {
        this(feature, parent);
        this.setSource(source);
    }

    public DeleteTransaction(SeqFeatureI feature, TransactionSubpart subpart) {
        this.setSeqFeature(feature);
        this.setSubpart(subpart);
    }

    public DeleteTransaction(SeqFeatureI feature, TransactionSubpart subpart, Object subpartValue) {
        this.setSeqFeature(feature);
        this.setSubpart(subpart);
        this.setOldSubpartValue(subpartValue);
    }

    public DeleteTransaction(Object source, SeqFeatureI feature, TransactionSubpart subpart, Object subpartValue, int subpartRank) {
        this(feature, subpart, subpartValue);
        this.setSubpartRank(subpartRank);
        this.setSource(source);
    }

    public boolean isDelete() {
        return true;
    }

    public SeqFeatureI getDeletedFeature() {
        return this.getSeqFeature();
    }

    public SeqFeatureI getParentFeature() {
        return this.parentFeature;
    }

    public void setParentFeature(SeqFeatureI parent) {
        this.parentFeature = parent;
    }

    public AnnotationChangeEvent generateAnnotationChangeEvent() {
        return new AnnotationDeleteEvent(this);
    }

    public void editModel() {
        if (!this.hasSubpart()) {
            throw new IllegalStateException("no editModel on add whole feats yet");
        }
        boolean isAdd = false;
        this.getSubpart().setValue(this.getSeqFeature(), this.getOldSubpartValue(), isAdd);
    }

    public void undo() {
        boolean isAdd = true;
        this.getSubpart().setValue(this.getSeqFeature(), this.getOldSubpartValue(), isAdd);
    }
}

