/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel.seq;

import apollo.datamodel.Range;
import apollo.datamodel.SequenceI;
import apollo.datamodel.seq.AbstractLazySequence;
import apollo.datamodel.seq.CacheSeqIdLoader;
import apollo.datamodel.seq.CacheSequenceLoader;
import apollo.gui.Controller;

public class GAMESequence
extends AbstractLazySequence {
    private String range_residues;

    public GAMESequence(String id, Controller c, String dna) {
        super(id, c);
        this.setResidues(dna);
    }

    protected CacheSequenceLoader createCacher() {
        return new CacheSeqIdLoader(this);
    }

    public String getResiduesFromSource(int low, int high) {
        String seq = this.getResiduesFromSourceImpl(low, high);
        return seq;
    }

    public SequenceI getSubSequence(int start, int end) {
        Range subLoc = new Range(this.getRange().getName(), this.getRange().getStart() + start - 1, this.getRange().getStart() + end - 1);
        GAMESequence temp = new GAMESequence(this.getName(), this.llco.getController(), this.range_residues.substring(start, end));
        temp.setRange(subLoc);
        temp.setLength(subLoc.length());
        return temp;
    }

    protected boolean needInclusiveEnd() {
        return true;
    }

    protected String getResiduesFromSourceImpl(int low, int high) {
        int str_high;
        if (this.range_residues == null) {
            return null;
        }
        int str_low = low - this.getRange().getStart();
        if (str_low == (str_high = high - this.getRange().getStart())) {
            str_high = str_low + 1;
        }
        if (str_high < this.range_residues.length()) {
            return this.range_residues.substring(str_low, str_high);
        }
        if (str_low < this.range_residues.length()) {
            return this.range_residues.substring(str_low);
        }
        return null;
    }

    public boolean hasSequence() {
        String residues = this.getResidues();
        return residues != null && residues.length() > 1;
    }

    public void setResidues(String seqString) {
        if (seqString != null && !seqString.equals("")) {
            this.range_residues = seqString;
            this.setLength(this.range_residues.length());
        }
    }

    public boolean isLazy() {
        return false;
    }
}

