/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel.seq;

import apollo.config.Config;
import apollo.datamodel.AbstractSequence;
import apollo.datamodel.Range;
import apollo.datamodel.RangeI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.seq.CacheSequenceLoader;
import apollo.datamodel.seq.LazySequenceI;
import apollo.gui.Controller;
import apollo.gui.event.LazyLoadEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class AbstractLazySequence
extends AbstractSequence
implements LazySequenceI {
    protected LazyLoadControlledObject llco;
    protected CacheSequenceLoader cacher;

    public AbstractLazySequence(String id, Controller c) {
        super(id);
        this.setController(c);
        this.setCacher(this.createCacher());
    }

    public RangeI getRange() {
        if (this.genomicRange == null) {
            this.setRange(new Range(this.getName(), 1, this.getLength()));
        }
        return this.genomicRange;
    }

    public abstract SequenceI getSubSequence(int var1, int var2);

    private void writeObject(ObjectOutputStream out) throws IOException {
        LazyLoadControlledObject tmpl = this.llco;
        CacheSequenceLoader tmpc = this.cacher;
        this.llco = null;
        this.cacher = null;
        out.defaultWriteObject();
        this.llco = tmpl;
        this.cacher = tmpc;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setController(Config.getController());
        this.setCacher(this.createCacher());
    }

    protected CacheSequenceLoader createCacher() {
        return new CacheSequenceLoader(this);
    }

    public void setController(Controller c) {
        this.llco = new LazyLoadControlledObject(c);
    }

    public void setCacher(CacheSequenceLoader csl) {
        this.cacher = csl;
    }

    public CacheSequenceLoader getCacher() {
        return this.cacher;
    }

    protected String getResiduesImpl(int start, int end) {
        return this.cacher.getResidues(start, end);
    }

    protected String getResiduesImpl(int start) {
        return this.cacher.getResidues(start, this.getLength());
    }

    public String getResiduesFromSource(int low, int high) {
        this.llco.fireLazyLoadEvent(10);
        String seq = this.getResiduesFromSourceImpl(low, high);
        this.llco.fireLazyLoadEvent(11);
        return seq;
    }

    protected boolean needInclusiveEnd() {
        return false;
    }

    protected abstract String getResiduesFromSourceImpl(int var1, int var2);

    public boolean isLazy() {
        return true;
    }

    protected class LazyLoadControlledObject {
        private Controller controller;

        public LazyLoadControlledObject(Controller c) {
            this.controller = c;
        }

        public void fireLazyLoadEvent(int type) {
            Config.getController().handleLazyLoadEvent(new LazyLoadEvent(this, AbstractLazySequence.this.getName(), type, 1));
        }

        public Controller getController() {
            return this.controller;
        }
    }
}

