/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.config.Config;
import apollo.datamodel.ApolloDataI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.LinkSet;
import apollo.datamodel.SpeciesComparison;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CompositeDataHolder
implements ApolloDataI {
    private CurationSet compositeCurationSet;
    private boolean hasLinks = false;
    private List speciesComparisons = new ArrayList(1);
    private String name;

    public CompositeDataHolder() {
    }

    public CompositeDataHolder(SpeciesComparison sc) {
        this.addSpeciesComparison(sc);
    }

    public CompositeDataHolder(CurationSet curSet) {
        if (curSet.isMultiSpecies()) {
            this.wrapCompositeCurationSet(curSet);
        } else {
            SpeciesComparison comparison = new SpeciesComparison();
            comparison.setCurationSet(0, Config.getDefaultSingleSpeciesName(), curSet);
            this.addSpeciesComparison(comparison);
        }
    }

    private void wrapCompositeCurationSet(CurationSet compositeCur) {
        this.compositeCurationSet = compositeCur;
        this.hasLinks = true;
        Iterator it = this.compositeCurationSet.getChildSetOrderedNames().iterator();
        String prevSpecies = null;
        while (it.hasNext()) {
            String species = (String)it.next();
            if (this.isComparaCurationSet(species)) continue;
            if (prevSpecies != null) {
                CurationSet cs1 = this.getCurSetFromCompCurSet(prevSpecies);
                CurationSet cs2 = this.getCurSetFromCompCurSet(species);
                LinkSet ls = this.getCompCurLinkSet(prevSpecies, species);
                SpeciesComparison sc = new SpeciesComparison(prevSpecies, cs1, ls, species, cs2);
                this.addSpeciesComparison(sc);
            }
            prevSpecies = species;
        }
        this.name = compositeCur.getName();
    }

    public CurationSet getCurationSet(String setName) {
        if (this.isCompCurSetWrapper()) {
            return this.compositeCurationSet.getCurationSet(setName);
        }
        for (int i = 0; i < this.speciesComparisons.size(); ++i) {
            CurationSet cs = this.getSpeciesComparison(i).getCurationSet(setName);
            if (cs == null) continue;
            return cs;
        }
        throw new RuntimeException("No cur set for species " + setName);
    }

    private boolean isCompCurSetWrapper() {
        return this.compositeCurationSet != null;
    }

    public CurationSet getCurationSet(int i) {
        if (this.compositeCurationSet != null) {
            return this.getCurSetFromCompCurSet(this.getSpecies(i));
        }
        if (i == 0) {
            return this.getSpeciesComparison(0).getCurationSet1();
        }
        return this.getSpeciesComparison(i - 1).getCurationSet2();
    }

    public int numberOfSpecies() {
        int num = this.speciesComparisons.size();
        if (this.getLastSpeciesComp().hasBothSpecies()) {
            ++num;
        }
        return num;
    }

    public int getNumberOfSpecies() {
        return this.numberOfSpecies();
    }

    public String getSpecies(int i) {
        if (i == this.speciesComparisons.size()) {
            return this.getSpeciesComparison(i - 1).getSpecies2();
        }
        return this.getSpeciesComparison(i).getSpecies1();
    }

    public boolean hasNonEmptyLinkSet() {
        return this.getSpeciesComparison(0).hasNonEmptyLinkSet();
    }

    private LinkSet getCompCurLinkSet(String firstSetName, String secondSetName) {
        CurationSet cs = this.getCurSetFromCompCurSet(firstSetName + "-" + secondSetName);
        if (cs == null) {
            cs = this.getCurSetFromCompCurSet(secondSetName + "-" + firstSetName);
        }
        LinkSet linkSet = new LinkSet(cs, firstSetName, secondSetName);
        return linkSet;
    }

    public CurationSet getCurSetFromCompCurSet(String setName) {
        return this.compositeCurationSet.getCurationSet(setName);
    }

    public int getNumberOfLinkSets() {
        return this.speciesCompSize();
    }

    public LinkSet getLinkSet(int i) {
        return this.getSpeciesComparison(i).getLinkSet();
    }

    public void addSpeciesComparison(SpeciesComparison sc) {
        this.speciesComparisons.add(sc);
    }

    public int speciesCompSize() {
        return this.speciesComparisons.size();
    }

    public SpeciesComparison getSpeciesComparison(int i) {
        return (SpeciesComparison)this.speciesComparisons.get(i);
    }

    private SpeciesComparison getLastSpeciesComp() {
        return this.getSpeciesComparison(this.speciesComparisons.size() - 1);
    }

    public CurationSet getCompositeCurationSet() {
        return this.compositeCurationSet;
    }

    private boolean isComparaCurationSet(String name) {
        HashMap logicalNamesAndSpecies = Config.getStyle("apollo.dataadapter.synteny.SyntenyAdapter").getSyntenySpeciesNames();
        String speciesName = (String)logicalNamesAndSpecies.get("Name." + name);
        return speciesName != null && speciesName.equals("Compara");
    }

    public boolean isCurationSet() {
        return false;
    }

    public CurationSet getCurationSet() {
        return null;
    }

    public boolean isCompositeDataHolder() {
        return true;
    }

    public CompositeDataHolder getCompositeDataHolder() {
        return this;
    }

    public boolean isMultiSpecies() {
        return this.getNumberOfSpecies() > 1;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getCurationSet(0).getName();
        }
        return this.name;
    }
}

