/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.LinkType;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.synteny.LinkerI;
import apollo.dataadapter.synteny.PeptideLinker;
import apollo.dataadapter.synteny.SelfLinker;
import apollo.dataadapter.synteny.TranscriptLinker;
import apollo.datamodel.CurationSet;
import apollo.datamodel.Link;
import apollo.datamodel.LinkSet;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SpeciesComparison;
import apollo.util.FeatureList;
import apollo.util.SeqFeatureUtil;

abstract class AbstractLinker
implements LinkerI {
    private FeatureProperty featureProperty;

    AbstractLinker() {
    }

    static LinkerI getLinker(FeatureProperty linkedProp) {
        LinkType type = linkedProp.getLinkType();
        if (type == LinkType.PEPTIDE) {
            return new PeptideLinker(linkedProp);
        }
        if (type == LinkType.TRANSCRIPT) {
            return new TranscriptLinker(linkedProp);
        }
        if (type == LinkType.SELF) {
            return new SelfLinker(linkedProp);
        }
        if (type == LinkType.NO_LINK) {
            System.out.println("Programmer error: link type is NO_LINK in GameSynteny.getLinker");
            throw new RuntimeException();
        }
        System.out.println("link type " + type + " didnt find linker for it???");
        return null;
    }

    protected FeatureProperty getFeatureProperty() {
        return this.featureProperty;
    }

    protected void setFeatureProperty(FeatureProperty fp) {
        this.featureProperty = fp;
    }

    protected String getSpecies1() {
        return this.getFeatureProperty().getLinkSpecies1();
    }

    public LinkSet createLinksFromSpeciesComp(SpeciesComparison twoSpecies) {
        FeatureList feats1 = this.getLinkFeatures(twoSpecies.getCurationSet1());
        FeatureList feats2 = this.getLinkFeatures(twoSpecies.getCurationSet2());
        if (feats1.isEmpty() || feats2.isEmpty()) {
            return new LinkSet();
        }
        return this.createLinksFromFeatLists(feats1, feats2);
    }

    protected FeatureList getLinkFeatures(CurationSet curSet) {
        this.dbg("******is parent link type " + this.getFeatureProperty().getLinkType().isParentLevel());
        if (this.getFeatureProperty().getLinkType().isParentLevel()) {
            return SeqFeatureUtil.getFeatPropLeafParentFeats(curSet, this.getFeatureProperty());
        }
        return SeqFeatureUtil.getFeatPropLeafFeatures(curSet, this.getFeatureProperty());
    }

    private LinkSet createLinksFromFeatLists(FeatureList feats1, FeatureList feats2) {
        LinkSet links = new LinkSet(false);
        for (int i = 0; i < feats1.size(); ++i) {
            SeqFeatureI feat1 = feats1.getFeature(i);
            for (int j = 0; j < feats2.size(); ++j) {
                SeqFeatureI feat2 = feats2.getFeature(j);
                if (!this.featsAreLinked(feat1, feat2)) continue;
                Link link = this.createLink(feat1, feat2);
                if (link != null) {
                    links.addLink(link);
                    continue;
                }
                System.out.println("Failed to make link for " + feat1.getName() + ", " + feat2.getName());
            }
        }
        return links;
    }

    private void dbg(String m) {
        if (Config.DEBUG) {
            System.out.println(m);
        }
    }

    protected abstract boolean featsAreLinked(SeqFeatureI var1, SeqFeatureI var2);

    public Link createLink(SeqFeatureI feat1, SeqFeatureI feat2) {
        return new Link(feat1, feat2, this.hasSpeciesFeature(), this.hasPercentIdentity());
    }

    public CurationSet getCurationSetForLink(ApolloDataAdapterI adap, SeqFeatureI link) throws ApolloAdapterException {
        adap.setDatabase(this.getTargetDbOfLink(link));
        adap.setInputType(this.getInputType());
        adap.setInput(this.getInputString(link));
        this.dbg("AbsLink adap input " + adap.getInput() + " input string set to data adapter is " + this.getInputString(link));
        this.doPadding(adap, link);
        return adap.getCurationSet();
    }

    protected abstract DataInputType getInputType();

    protected abstract String getInputString(SeqFeatureI var1);

    protected void doPadding(ApolloDataAdapterI adap, SeqFeatureI link) {
    }

    private String getTargetDbOfLink(SeqFeatureI feat) {
        if (this.featFromLinkSpecies1(feat)) {
            return Config.getSyntenyDatabaseForSpecies(this.featureProperty.getLinkSpecies2());
        }
        return Config.getSyntenyDatabaseForSpecies(this.featureProperty.getLinkSpecies1());
    }

    boolean featFromLinkSpecies1(SeqFeatureI feat) {
        String spec = this.featureProperty.getLinkSpecies1();
        return feat.getRefSequence().getOrganism().equals(spec);
    }

    public boolean featListFromLinkSpecies1(FeatureList featList) {
        if (featList.isEmpty()) {
            return false;
        }
        return this.featFromLinkSpecies1(featList.getFeature(0));
    }

    protected SeqFeatureI getHitFeat(SeqFeatureI feat) {
        if (feat.hasHitFeature()) {
            feat = feat.getHitFeature();
        }
        return feat;
    }

    protected boolean hasSpeciesFeature() {
        return true;
    }

    protected boolean hasPercentIdentity() {
        return false;
    }

    protected int padLeft(SeqFeatureI feat) {
        return feat.getLow() - feat.getRefSequence().getRange().getLow();
    }

    protected int padRight(SeqFeatureI feat) {
        return feat.getRefSequence().getRange().getHigh() - feat.getHigh();
    }
}

