/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.otter.parser;

import apollo.dataadapter.otter.parser.OtterContentHandler;
import apollo.dataadapter.otter.parser.TagHandler;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Transcript;
import java.util.Hashtable;
import java.util.Iterator;
import org.xml.sax.Attributes;

public class TranscriptTagHandler
extends TagHandler {
    public void handleStartElement(OtterContentHandler theContentHandler, String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        super.handleStartElement(theContentHandler, namespaceURI, localName, qualifiedName, attributes);
        Transcript transcript = new Transcript();
        theContentHandler.pushStackObject(transcript);
    }

    public void handleEndElement(OtterContentHandler theContentHandler, String namespaceURI, String localName, String qualifiedName) {
        super.handleEndElement(theContentHandler, namespaceURI, localName, qualifiedName);
        Transcript transcript = (Transcript)theContentHandler.popStackObject();
        AnnotatedFeatureI parentGene = (AnnotatedFeatureI)theContentHandler.getStackObject();
        parentGene.addFeature(transcript);
        transcript.setRefFeature(parentGene);
        transcript.setRefSequence(theContentHandler.getCurationSet().getRefSequence());
        if (transcript.getTopLevelType().equals("partial")) {
            transcript.setFeatureType("partial");
        } else {
            transcript.setFeatureType("otter");
        }
        transcript.getGene().setStrand(transcript.getStrand());
        String translationStartStr = transcript.getProperty(TagHandler.TRANSLATION_START);
        String translationEndStr = transcript.getProperty(TagHandler.TRANSLATION_END);
        Hashtable props = transcript.getProperties();
        Iterator iterator = props.keySet().iterator();
        if (translationStartStr != null && translationStartStr.trim().length() > 0 && translationEndStr != null && translationEndStr.trim().length() > 0) {
            int genomicTranslationStartPos = Integer.parseInt(translationStartStr);
            int genomicTranslationEndPos = Integer.parseInt(translationEndStr);
            transcript.setTranslationStart(genomicTranslationStartPos);
            transcript.setTranslationEnd(genomicTranslationEndPos);
            transcript.removeProperty(TagHandler.TRANSLATION_START);
            transcript.removeProperty(TagHandler.TRANSLATION_END);
        }
    }

    public String getFullName() {
        return "otter:sequence_set:locus:transcript";
    }

    public String getLeafName() {
        return "transcript";
    }
}

