/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.otter.parser;

import apollo.dataadapter.NotImplementedException;
import apollo.dataadapter.otter.parser.TagHandler;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AssemblyFeature;
import apollo.datamodel.Comment;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.Evidence;
import apollo.datamodel.Exon;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.Transcript;
import apollo.editor.UserName;
import apollo.util.Visitor;
import java.util.Iterator;

public class OtterXMLRenderingVisitor
implements Visitor {
    private int indent = 0;
    private StringBuffer returnBuffer = new StringBuffer();
    private String indentString = "";
    private static String[] genePropNames = new String[]{TagHandler.AUTHOR, TagHandler.AUTHOR_EMAIL};
    private static String[] transcriptPropNames = new String[]{TagHandler.CDS_START_NOT_FOUND, TagHandler.CDS_END_NOT_FOUND, TagHandler.MRNA_START_NOT_FOUND, TagHandler.MRNA_END_NOT_FOUND};

    private int getIndent() {
        return this.indent;
    }

    private void incrementIndent() {
        this.indentString = this.indentString + TagHandler.INDENT;
        ++this.indent;
    }

    private void decrementIndent() {
        --this.indent;
        if (this.indent >= 1) {
            this.indentString = this.indentString.substring(0, this.indentString.length() - 2);
        }
    }

    private String getIndentString() {
        return this.indentString;
    }

    public StringBuffer getReturnBuffer() {
        return this.returnBuffer;
    }

    private void setReturnBuffer(StringBuffer newValue) {
        this.returnBuffer = newValue;
    }

    private StringBuffer append(String append) {
        return this.getReturnBuffer().append(append);
    }

    public void visit(SeqFeature feature) {
        throw new NotImplementedException("This is not implemented");
    }

    private StringBuffer open(String tag) {
        return this.append(TagHandler.LEFT).append(tag).append(TagHandler.RIGHT);
    }

    private StringBuffer close(String tag) {
        return this.append(TagHandler.LEFT).append(TagHandler.SLASH).append(tag).append(TagHandler.RIGHT);
    }

    private StringBuffer retrn() {
        return this.append(TagHandler.RETURN);
    }

    private void wrap(String tag, String value) {
        this.append(this.getIndentString());
        this.open(tag).append(value);
        this.close(tag);
        this.retrn();
    }

    private void wrapPropertiesForFeature(SeqFeature feature, String[] propNames) {
        for (int i = 0; i < propNames.length; ++i) {
            String key = propNames[i];
            if (feature.getProperties().containsKey(key)) {
                String value = feature.getProperty(key);
                this.wrap(key, value);
                continue;
            }
            this.wrap(key, "");
        }
    }

    public void visit(AssemblyFeature feature) {
        System.out.println("Visiting assembly_feature");
        this.append(this.getIndentString());
        this.open(TagHandler.SEQUENCE_FRAGMENT);
        this.retrn();
        this.incrementIndent();
        this.wrap(TagHandler.ID, feature.getId());
        this.wrap(TagHandler.CHROMOSOME, feature.getChromosome());
        this.wrap(TagHandler.ASSEMBLY_START, String.valueOf(feature.getLow()));
        this.wrap(TagHandler.ASSEMBLY_END, String.valueOf(feature.getHigh()));
        this.wrap(TagHandler.FRAGMENT_ORI, String.valueOf(feature.getStrand()));
        this.wrap(TagHandler.FRAGMENT_OFFSET, String.valueOf(feature.getFragmentOffset()));
        if (feature.getAccession() != null) {
            this.wrap(TagHandler.ACCESSION, feature.getAccession());
            this.wrap(TagHandler.VERSION, String.valueOf(feature.getVersion()));
        }
        if (feature.getKeywords() != null) {
            Iterator keywordIterator = feature.getKeywords().iterator();
            while (keywordIterator.hasNext()) {
                this.wrap(TagHandler.KEYWORD, (String)keywordIterator.next());
            }
        }
        if (feature.getRemarks() != null) {
            Iterator remarkIterator = feature.getRemarks().iterator();
            while (remarkIterator.hasNext()) {
                this.wrap(TagHandler.REMARK, (String)remarkIterator.next());
            }
        }
        this.wrapAuthorDetails(feature);
        this.decrementIndent();
        this.append(this.getIndentString());
        this.close(TagHandler.SEQUENCE_FRAGMENT);
        this.retrn();
    }

    public void visit(FeatureSet feature) {
        Iterator featureIterator = feature.getFeatures().iterator();
        while (featureIterator.hasNext()) {
            ((SeqFeature)featureIterator.next()).accept(this);
            this.append(TagHandler.RETURN);
        }
    }

    public void visit(StrandedFeatureSet feature) {
        Iterator featureIterator = feature.getFeatures().iterator();
        this.incrementIndent();
        while (featureIterator.hasNext()) {
            ((SeqFeature)featureIterator.next()).accept(this);
            this.append(TagHandler.RETURN);
        }
        this.decrementIndent();
    }

    public void visit(CurationSet feature) {
        this.open(TagHandler.OTTER);
        this.retrn();
        this.incrementIndent();
        this.append(this.getIndentString());
        this.open(TagHandler.SEQUENCE_SET);
        this.retrn();
        if (feature.getAssemblyType() != null) {
            this.wrap(TagHandler.ASSEMBLY_TYPE, feature.getAssemblyType());
        }
        Iterator featureIterator = feature.getAnnots().getFeatures().iterator();
        this.incrementIndent();
        while (featureIterator.hasNext()) {
            ((SeqFeature)featureIterator.next()).accept(this);
            this.append(TagHandler.RETURN);
        }
        this.decrementIndent();
        this.append(this.getIndentString());
        this.close(TagHandler.SEQUENCE_SET);
        this.retrn();
        this.decrementIndent();
        this.close(TagHandler.OTTER);
    }

    private void wrapAuthorDetails(SeqFeature feature) {
        if (feature.getProperties().containsKey(TagHandler.AUTHOR)) {
            this.wrap(TagHandler.AUTHOR, feature.getProperty(TagHandler.AUTHOR));
        } else {
            this.wrap(TagHandler.AUTHOR, UserName.getUserName());
        }
        if (feature.getProperties().containsKey(TagHandler.AUTHOR_EMAIL)) {
            this.wrap(TagHandler.AUTHOR_EMAIL, feature.getProperty(TagHandler.AUTHOR_EMAIL));
        } else {
            this.wrap(TagHandler.AUTHOR_EMAIL, UserName.getUserName() + "@sanger.ac.uk");
        }
    }

    public void visit(AnnotatedFeature feature) {
        this.append(this.getIndentString());
        this.open(TagHandler.LOCUS);
        this.retrn();
        this.incrementIndent();
        this.wrap(TagHandler.LOCUS_TYPE, feature.getTopLevelType());
        Iterator dbxrefs = feature.getDbXrefs().iterator();
        boolean foundId = false;
        while (dbxrefs.hasNext()) {
            DbXref dbx = (DbXref)dbxrefs.next();
            if (!dbx.getIdType().equals("OtterId")) continue;
            this.wrap(TagHandler.STABLE_ID, dbx.getIdValue());
            foundId = true;
        }
        if (!foundId) {
            this.wrap(TagHandler.STABLE_ID, "");
        }
        this.wrap(TagHandler.NAME, feature.getName());
        Iterator synonyms = feature.getSynonyms().iterator();
        while (synonyms.hasNext()) {
            this.wrap(TagHandler.SYNONYM, (String)synonyms.next());
        }
        Iterator comments = feature.getComments().iterator();
        while (comments.hasNext()) {
            this.wrap(TagHandler.REMARK, ((Comment)comments.next()).getText());
        }
        this.wrapAuthorDetails(feature);
        if (feature.getProperties().containsKey(TagHandler.KNOWN)) {
            this.wrap(TagHandler.KNOWN, feature.getProperty(TagHandler.KNOWN));
        }
        Iterator featureIterator = feature.getFeatures().iterator();
        while (featureIterator.hasNext()) {
            ((SeqFeature)featureIterator.next()).accept(this);
            this.append(TagHandler.RETURN);
        }
        this.decrementIndent();
        this.append(this.getIndentString());
        this.close(TagHandler.LOCUS);
        this.retrn();
    }

    public void visit(Transcript feature) {
        Iterator featureIterator = feature.getFeatures().iterator();
        Iterator evidenceIterator = feature.getEvidence().iterator();
        this.append(this.getIndentString());
        this.open(TagHandler.TRANSCRIPT);
        this.retrn();
        this.incrementIndent();
        Iterator dbxrefs = feature.getDbXrefs().iterator();
        boolean foundId = false;
        while (dbxrefs.hasNext()) {
            DbXref dbx = (DbXref)dbxrefs.next();
            if (!dbx.getIdType().equals("OtterId")) continue;
            this.wrap(TagHandler.STABLE_ID, dbx.getIdValue());
            foundId = true;
        }
        if (!foundId) {
            this.wrap(TagHandler.STABLE_ID, "");
        }
        this.wrap(TagHandler.NAME, feature.getName());
        this.wrapAuthorDetails(feature);
        Iterator comments = feature.getComments().iterator();
        while (comments.hasNext()) {
            this.wrap(TagHandler.REMARK, ((Comment)comments.next()).getText());
        }
        this.wrap(TagHandler.TRANSCRIPT_CLASS, feature.getTopLevelType());
        this.wrapPropertiesForFeature(feature, transcriptPropNames);
        while (evidenceIterator.hasNext()) {
            Evidence evidence = (Evidence)evidenceIterator.next();
            evidence.accept(this);
        }
        if (feature.getTranslationStart() != 0) {
            if (feature.getTranslationEnd() == 0) {
                feature.setTranslationEndNoPhase(feature.getEnd());
            }
            this.wrap(TagHandler.TRANSLATION_START, String.valueOf(feature.getTranslationStart()));
            this.wrap(TagHandler.TRANSLATION_END, String.valueOf(feature.getTranslationEnd()));
            boolean foundTranslationId = false;
            dbxrefs = feature.getDbXrefs().iterator();
            while (dbxrefs.hasNext()) {
                DbXref dbx = (DbXref)dbxrefs.next();
                if (!dbx.getIdType().equals("OtterTranslationId")) continue;
                this.wrap(TagHandler.TRANSLATION_STABLE_ID, dbx.getIdValue());
                foundTranslationId = true;
            }
            if (!foundTranslationId) {
                this.wrap(TagHandler.TRANSLATION_STABLE_ID, "");
            }
        }
        while (featureIterator.hasNext()) {
            ((SeqFeature)featureIterator.next()).accept(this);
            this.append(TagHandler.RETURN);
        }
        this.decrementIndent();
        this.append(this.getIndentString());
        this.close(TagHandler.TRANSCRIPT);
        this.retrn();
    }

    public void visit(Exon feature) {
        this.append(this.getIndentString());
        this.open(TagHandler.EXON);
        this.retrn();
        this.incrementIndent();
        this.wrap(TagHandler.STABLE_ID, feature.getProperty("OtterStableId"));
        this.wrap(TagHandler.START, String.valueOf(feature.getLow()));
        this.wrap(TagHandler.END, String.valueOf(feature.getHigh()));
        this.wrap(TagHandler.STRAND, String.valueOf(feature.getStrand()));
        int exonType = feature.getCodingProperties();
        if (exonType == 1 || exonType == 3) {
            this.wrap(TagHandler.FRAME, "0");
        } else if (exonType == 4 || exonType == 2) {
            this.wrap(TagHandler.FRAME, String.valueOf(feature.getPhase()));
        }
        this.decrementIndent();
        this.append(this.getIndentString());
        this.close(TagHandler.EXON);
        this.retrn();
    }

    public void visit(Evidence evidence) {
        this.append(this.getIndentString());
        this.open(TagHandler.EVIDENCE);
        this.retrn();
        this.incrementIndent();
        this.wrap(TagHandler.NAME, evidence.getSetId());
        this.wrap(TagHandler.TYPE, evidence.getDbType());
        this.decrementIndent();
        this.append(this.getIndentString());
        this.close(TagHandler.EVIDENCE);
        this.retrn();
    }
}

