/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.genbank;

import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.DbXref;
import java.util.Vector;

public class XrefUtil {
    String id_regex = "";
    Vector dbkeys;
    String dbname = "";

    public XrefUtil(String user_input) {
        try {
            String[] tokens = user_input.split(":");
            String keys = tokens[0];
            this.dbname = tokens[1];
            this.id_regex = tokens[2];
            tokens = keys.split(",");
            for (int i = 0; i < tokens.length; ++i) {
                if (this.dbkeys == null) {
                    this.dbkeys = new Vector(tokens.length);
                }
                this.dbkeys.addElement(tokens[i]);
            }
        }
        catch (Exception e) {
            System.out.println("Failed parsing " + user_input + " because of " + e.getMessage());
            System.out.println("dbname " + this.dbname + " id format " + this.id_regex);
        }
    }

    protected String getGenBankXref(AnnotatedFeatureI gene) {
        StringBuffer buf = new StringBuffer();
        Vector xrefs = gene.getDbXrefs();
        for (int i = 0; i < xrefs.size(); ++i) {
            String id;
            DbXref xref = (DbXref)xrefs.elementAt(i);
            boolean match = false;
            for (int j = 0; j < this.dbkeys.size() && !match; ++j) {
                String db_key = (String)this.dbkeys.elementAt(j);
                match = xref.getDbName().equalsIgnoreCase(db_key);
            }
            if (!match || !(match = (id = xref.getIdValue()).matches(this.id_regex))) continue;
            if (id.indexOf(58) > 0) {
                buf.append("\t\t\tdb_xref\t" + id + "\n");
                continue;
            }
            buf.append("\t\t\tdb_xref\t" + this.dbname + ":" + id + "\n");
        }
        return buf.toString();
    }
}

