/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.gamexml;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.bdgp.xml.XMLElement;
import org.bdgp.xml.XML_util;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLParser
implements ContentHandler {
    XMLReader xml_reader = null;
    String default_parser_name = "";
    protected XMLElement root_element = null;
    private XMLElement current_element = null;
    int element_count = 0;
    Stack element_chain;

    public XMLParser() {
    }

    public XMLParser(int initial_count) {
        this.element_count = initial_count;
    }

    public XMLElement getRootElement() {
        return this.root_element;
    }

    public XMLElement readXML(String doc_url_string) {
        URL doc_url = null;
        try {
            doc_url = new URL(doc_url_string);
            this.readXML(doc_url);
        }
        catch (Exception ex1) {
            try {
                FileInputStream xml_stream = new FileInputStream(doc_url_string);
                BufferedInputStream bis = new BufferedInputStream(xml_stream);
                this.readXML(bis);
            }
            catch (Exception ex2) {
                System.err.println("caught Exception in readXML(doc_url_string): ");
                System.out.println(ex2.getMessage());
                ex2.printStackTrace();
                this.clean();
            }
        }
        return this.root_element;
    }

    public XMLElement readXML(URL doc_url) {
        InputStream is = null;
        BufferedInputStream bis = null;
        try {
            is = doc_url.openStream();
            try {
                bis = new BufferedInputStream(is);
                try {
                    this.readXML(bis);
                }
                catch (Exception ex) {
                    System.err.println("Failed to read XML from " + doc_url + ": " + ex);
                    this.clean();
                }
            }
            catch (Exception ex) {
                System.err.println("caught Exception in BufferedInputStream for " + doc_url + ": " + ex);
                this.clean();
            }
        }
        catch (Exception ex) {
            this.clean();
        }
        return this.root_element;
    }

    public XMLElement readXML(InputStream istream) {
        block9: {
            this.element_chain = new Stack();
            this.clean();
            try {
                SAXParser saxParser;
                if (this.xml_reader != null) break block9;
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setValidating(false);
                try {
                    saxParser = spf.newSAXParser();
                }
                catch (ParserConfigurationException e) {
                    throw new IOException("Couldn't load parser");
                }
                this.xml_reader = saxParser.getXMLReader();
                try {
                    this.xml_reader.setContentHandler(this);
                    try {
                        this.xml_reader.parse(new InputSource(istream));
                    }
                    catch (Exception e) {
                        String el = "";
                        if (this.current_element != null) {
                            el = ", current_element = " + this.current_element.getID();
                        }
                        System.err.println("Fatal Error near element # " + this.element_count + ", " + el + ",\nerror = " + e.getMessage());
                        e.printStackTrace();
                        this.clean();
                    }
                }
                catch (Exception e) {
                    System.err.println("Fatal Error in xml_reader.setDocumentHandler: " + e.getMessage());
                }
            }
            catch (Exception e) {
                System.err.println("Fatal Error in xml_reader new: " + e.getMessage());
            }
        }
        return this.root_element;
    }

    public void setParser(XMLReader xml_reader) {
        this.xml_reader = xml_reader;
    }

    public void startElement(String uri, String local_name, String name, Attributes atts) {
        try {
            XMLElement parent_element = this.current_element;
            this.current_element = new XMLElement(name);
            if (parent_element == null) {
                this.root_element = this.current_element;
                System.err.println("Starting XML parse");
            } else {
                this.element_chain.push(parent_element);
                this.current_element.setParent(parent_element);
            }
            ++this.element_count;
            this.current_element.setAttributes(atts, this.element_count);
        }
        catch (Exception ex) {
            System.err.println("Exception parsing " + name + " " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void endElement(String uri, String local_name, String name) {
        if (this.current_element != null && this.current_element.getCharData() != null) {
            this.current_element.setCharData(this.current_element.getCharData().trim());
        }
        if (!this.element_chain.empty()) {
            this.current_element = (XMLElement)this.element_chain.pop();
        }
    }

    public void characters(char[] ch, int start, int length) {
        String char_data;
        if (this.current_element.getType().equalsIgnoreCase("residues")) {
            char_data = XML_util.filterWhiteSpace((char[])ch, (int)start, (int)length);
            char_data = char_data.toUpperCase();
        } else {
            char_data = new String(ch, start, length);
        }
        if (char_data != null && !char_data.equals("")) {
            this.current_element.appendCharData(char_data);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void doctype(String name, String publicID, String systemID) {
    }

    public void processingInstruction(String name, String remainder) {
    }

    public void skippedEntity(String name) throws SAXException {
        System.out.println("Skipped XML entity " + name);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void printAttributes(Attributes atts) {
        int max = atts.getLength();
        String allatts = "     Attributes: ";
        if (max == 0) {
            System.err.println("     [Attributes not available]");
        }
        for (int i = 0; i < max; ++i) {
            String aname = atts.getLocalName(i);
            String special = atts.getType(i);
            if (special == null) {
                special = "";
            }
            String curatt = aname + "=\"" + atts.getValue(aname) + '\"' + special;
            allatts = allatts + curatt + ", ";
        }
        System.err.println(allatts);
    }

    public void clean() {
        this.current_element = null;
        this.root_element = null;
        System.gc();
    }
}

