/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj19;

import apollo.datamodel.Range;
import apollo.datamodel.SequenceI;
import apollo.datamodel.seq.AbstractLazySequence;
import apollo.datamodel.seq.LazySequenceI;
import apollo.gui.Controller;
import org.ensembl19.datamodel.AssemblyLocation;
import org.ensembl19.datamodel.LinearLocation;
import org.ensembl19.datamodel.Location;
import org.ensembl19.datamodel.Sequence;
import org.ensembl19.driver.DriverManager;
import org.ensembl19.driver.SequenceAdaptor;

public class EnsJSequence
extends AbstractLazySequence
implements LazySequenceI {
    private Location location;
    private String driverPath;

    public EnsJSequence(String id, Controller c, Location loc, String driverPath) {
        super(id, c);
        this.location = loc;
        this.setRange(new Range("dummy", loc.getStart(), loc.getEnd()));
        this.setDriverPath(driverPath);
        this.setLength(loc.getLength());
    }

    public void setDriverPath(String path) {
        this.driverPath = path;
    }

    private LinearLocation derivedLocation(int start, int end) {
        LinearLocation subLoc = (LinearLocation)this.location.copy();
        subLoc.setStart(start);
        subLoc.setEnd(end);
        return subLoc;
    }

    public SequenceI getSubSequence(int start, int end) {
        return new EnsJSequence(this.getName(), this.llco.getController(), (Location)this.derivedLocation(start, end), this.driverPath);
    }

    protected String getResiduesFromSourceImpl(int start, int end) {
        try {
            SequenceAdaptor sa = (SequenceAdaptor)DriverManager.get((String)this.driverPath).getAdaptor("sequence");
            LinearLocation loc = this.derivedLocation(start, end);
            Sequence seq = sa.fetch((Location)loc);
            String s = seq.getString();
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed getting sequence residues");
            return null;
        }
    }

    public static void main(String[] argv) throws Exception {
        DriverManager.load((String)"org/ensembl/conf/current_driver.conf:org/ensembl/conf/kaka_mysql_server.conf");
        Controller c = new Controller();
        EnsJSequence seq = new EnsJSequence("Dummy", c, (Location)new AssemblyLocation("22", 20000000, 20100000, 0), "current");
        SequenceAdaptor sa = (SequenceAdaptor)DriverManager.get((String)"current").getAdaptor("sequence");
        seq.getCacher().setMinChunkSize(100);
        System.out.println("Have sequence. Dumping regions");
        String processedSeq = seq.getResidues(1, 10);
        String rawSeq = sa.fetch((Location)new AssemblyLocation("22", 20000000, 20000009, 0)).getString();
        String diff = rawSeq.equals(processedSeq) ? "SAME" : "protected = " + processedSeq + "\nraw = " + rawSeq;
        System.out.println("Sequence first 10 = " + diff);
        processedSeq = seq.getResidues(100, 110);
        rawSeq = sa.fetch((Location)new AssemblyLocation("22", 20000099, 20000109, 0)).getString();
        diff = rawSeq.equals(processedSeq) ? "SAME" : "protected = " + processedSeq + "\nraw = " + rawSeq;
        System.out.println("Sequence 100-110 = " + diff);
        processedSeq = seq.getResidues(10000, 11010);
        rawSeq = sa.fetch((Location)new AssemblyLocation("22", 20009999, 20011009, 0)).getString();
        diff = rawSeq.equals(processedSeq) ? "SAME" : "protected = " + processedSeq + "\nraw = " + rawSeq;
        System.out.println("Sequence 10000-11010 = " + diff);
        processedSeq = seq.getResidues(1, 12010);
        rawSeq = sa.fetch((Location)new AssemblyLocation("22", 20000000, 20012009, 0)).getString();
        diff = rawSeq.equals(processedSeq) ? "SAME" : "protected = " + processedSeq + "\nraw = " + rawSeq;
        System.out.println("Sequence 1-12010 = " + diff);
        processedSeq = seq.getResidues(12010, 1);
        rawSeq = sa.fetch((Location)new AssemblyLocation("22", 20000000, 20012009, -1)).getString();
        diff = rawSeq.equals(processedSeq) ? "SAME" : "protected = " + processedSeq + "\nraw = " + rawSeq;
        System.out.println("Sequence 12010-1 = " + diff);
    }
}

