/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj19;

import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.datamodel.Range;
import apollo.datamodel.SequenceI;
import apollo.datamodel.seq.AbstractLazySequence;
import apollo.datamodel.seq.LazySequenceI;
import apollo.gui.Controller;
import java.util.Properties;
import org.ensembl19.datamodel.LinearLocation;
import org.ensembl19.datamodel.Location;
import org.ensembl19.datamodel.Sequence;
import org.ensembl19.driver.AdaptorException;
import org.ensembl19.driver.ConfigurationException;
import org.ensembl19.driver.Driver;
import org.ensembl19.driver.DriverManager;
import org.ensembl19.driver.SequenceAdaptor;

public class AlternateEnsJSequence
extends AbstractLazySequence
implements LazySequenceI {
    private LinearLocation location;
    private Properties driverProperties;
    private transient Driver driver;

    public AlternateEnsJSequence(String id, Controller c, LinearLocation loc, Properties driverProperties) {
        super(id, c);
        this.location = loc;
        this.setRange(new Range("dummy", loc.getStart(), loc.getEnd()));
        this.setDriverProperties(driverProperties);
        this.setLength(loc.getLength());
    }

    public void setDriverProperties(Properties driverProperties) {
        this.driverProperties = driverProperties;
    }

    public Properties getDriverProperties() {
        return this.driverProperties;
    }

    private Driver getDriver() {
        return this.driver;
    }

    private void setDriver(Driver newValue) {
        this.driver = newValue;
    }

    private LinearLocation derivedLocation(int start, int end) {
        LinearLocation subLoc = (LinearLocation)this.location.copy();
        subLoc.setStart(start);
        subLoc.setEnd(end);
        return subLoc;
    }

    public SequenceI getSubSequence(int start, int end) {
        return new AlternateEnsJSequence(this.getName(), this.llco.getController(), this.derivedLocation(start, end), this.getDriverProperties());
    }

    protected String getResiduesFromSourceImpl(int start, int end) {
        SequenceAdaptor sa = null;
        try {
            if (this.getDriver() == null) {
                this.setDriver(DriverManager.load((Properties)this.getDriverProperties()));
            }
            sa = (SequenceAdaptor)this.getDriver().getAdaptor("sequence");
            LinearLocation loc = this.derivedLocation(start, end);
            loc.setStrand(1);
            Sequence seq = sa.fetch((Location)loc);
            String s = seq.getString();
            return s;
        }
        catch (AdaptorException e) {
            throw new NonFatalDataAdapterException("failed to get sequence due to data problem: " + e.getMessage());
        }
        catch (ConfigurationException e) {
            throw new NonFatalDataAdapterException("failed to get sequence due to configuration problem: " + e.getMessage());
        }
    }
}

