/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj.view;

import apollo.dataadapter.ensj.EnsJAdapterGUI;
import apollo.dataadapter.ensj.model.Model;
import apollo.dataadapter.ensj.view.AnnotationsPanel;
import apollo.dataadapter.ensj.view.DatabasePanel;
import apollo.dataadapter.ensj.view.LocationPanel;
import apollo.dataadapter.ensj.view.TypesPanel;
import apollo.util.GuiUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class View
extends JPanel {
    private EnsJAdapterGUI _adapterGUI;
    private LocationPanel _locationPanel;
    private TypesPanel _typesPanel;
    private DatabasePanel _databasePanel;
    private AnnotationsPanel _annotationsPanel;
    public static final String SHOW_TYPES_LABEL = "Show / Hide Types...";
    public static final String SHOW_DATABASES_LABEL = "Show / Hide Databases...";
    public static final String SHOW_ANNOTATIONS_LABEL = "Show / Hide Annotations...";
    private JButton _typesButton = new JButton("Show / Hide Types...");
    private JButton _databaseButton = new JButton("Show / Hide Databases...");
    private JButton _annotationsButton = new JButton("Show / Hide Annotations...");
    static /* synthetic */ Class class$javax$swing$JScrollPane;
    static /* synthetic */ Class class$javax$swing$JDialog;

    public View(EnsJAdapterGUI gui) {
        this._adapterGUI = gui;
    }

    public void initialiseView() {
        this.setLocationPanel(new LocationPanel(this));
        this.setTypesPanel(new TypesPanel(this));
        this.setDatabasePanel(new DatabasePanel(this));
        this.setAnnotationsPanel(new AnnotationsPanel(this));
        this.setLayout(new GridBagLayout());
        LocationPanel locationPanel = this.getLocationPanel();
        locationPanel.setBorder(BorderFactory.createTitledBorder("Location"));
        this.add((Component)locationPanel, GuiUtil.makeConstraintAt(0, 0, 1));
        this.add((Component)this.createPanelContaining(this.getTypesButton(), this.getTypesPanel(), "Types"), GuiUtil.makeConstraintAt(0, 1, 1));
        this.getAdapterGUI().addActionRouter(this.getTypesButton(), "HIDE_OR_SHOW_TYPES");
        this.add((Component)this.createPanelContaining(this.getDatabaseButton(), this.getDatabasePanel(), "Databases"), GuiUtil.makeConstraintAt(0, 2, 1));
        this.getAdapterGUI().addActionRouter(this.getDatabaseButton(), "HIDE_OR_SHOW_DATABASE");
    }

    private JPanel createPanelContaining(JButton hideButton, JPanel panel, String borderLabel) {
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new GridBagLayout());
        newPanel.add((Component)hideButton, GuiUtil.makeConstraintAt(0, 0, 1));
        newPanel.add((Component)panel, GuiUtil.makeConstraintAt(0, 1, 1));
        newPanel.setBorder(BorderFactory.createTitledBorder(borderLabel));
        return newPanel;
    }

    public void update(Model model) {
        this.getLocationPanel().update(model);
        this.getTypesPanel().update(model);
        this.getDatabasePanel().update(model);
        this.getAnnotationsPanel().update(model);
    }

    public void read(Model model) {
        JDialog dialog;
        JScrollPane scrollpane = (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = View.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, this);
        if (model.isTypesPanelVisible()) {
            this.getTypesPanel().setVisible(true);
        } else {
            this.getTypesPanel().setVisible(false);
        }
        if (model.isDatabasePanelVisible()) {
            this.getDatabasePanel().setVisible(true);
        } else {
            this.getDatabasePanel().setVisible(false);
        }
        if (model.isAnnotationsPanelVisible()) {
            this.getAnnotationsPanel().setVisible(true);
        } else {
            this.getAnnotationsPanel().setVisible(false);
        }
        if (model.isLocationsPanelVisible()) {
            this.getLocationPanel().setVisible(true);
        } else {
            this.getLocationPanel().setVisible(false);
        }
        if (scrollpane == null && (dialog = (JDialog)SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = View.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, this)) != null) {
            dialog.pack();
        }
        this.getLocationPanel().read(model);
        this.getTypesPanel().read(model);
        this.getDatabasePanel().read(model);
        this.getAnnotationsPanel().read(model);
    }

    private LocationPanel getLocationPanel() {
        return this._locationPanel;
    }

    private void setLocationPanel(LocationPanel panel) {
        this._locationPanel = panel;
    }

    private TypesPanel getTypesPanel() {
        return this._typesPanel;
    }

    private void setTypesPanel(TypesPanel panel) {
        this._typesPanel = panel;
    }

    private DatabasePanel getDatabasePanel() {
        return this._databasePanel;
    }

    private void setDatabasePanel(DatabasePanel panel) {
        this._databasePanel = panel;
    }

    private AnnotationsPanel getAnnotationsPanel() {
        return this._annotationsPanel;
    }

    private void setAnnotationsPanel(AnnotationsPanel panel) {
        this._annotationsPanel = panel;
    }

    private JButton getTypesButton() {
        return this._typesButton;
    }

    private JButton getDatabaseButton() {
        return this._databaseButton;
    }

    private JButton getAnnotationsButton() {
        return this._annotationsButton;
    }

    public EnsJAdapterGUI getAdapterGUI() {
        return this._adapterGUI;
    }

    public void displayMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

