/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj.view;

import apollo.dataadapter.ensj.model.Model;
import apollo.dataadapter.ensj.model.TypesModel;
import apollo.dataadapter.ensj.view.View;
import apollo.util.GuiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TypesPanel
extends JPanel {
    private View _view;
    public static final String GENE_LABEL = "Genes";
    public static final String DNA_PROTEIN_ALIGN_LABEL = "Dna Protein Alignments";
    public static final String DNA_DNA_ALIGN_LABEL = "Dna Dna Alignments";
    public static final String PROTEIN_ANNOTATIONS_LABEL = "Protein Annotations";
    public static final String SIMPLE_FEATURE_LABEL = "Simple Features";
    public static final String REPEAT_LABEL = "Repeats";
    public static final String AB_INITIO_LABEL = "Ab Initio Predictions";
    private JCheckBox _genesCheckBox = new JCheckBox("Genes");
    private JButton _geneTypesButton = new JButton("Gene Types...");
    private JCheckBox _dnaProteinAlignmentsCheckBox = new JCheckBox("Dna Protein Alignments");
    private JButton _dnaProteinAlignmentTypesButton = new JButton("Protein Align Types...");
    private JCheckBox _dnaDnaAlignmentsCheckBox = new JCheckBox("Dna Dna Alignments");
    private JButton _dnaDnaAlignmentTypesButton = new JButton("Dna Align Types...");
    private JCheckBox _simpleFeaturesCheckBox = new JCheckBox("Simple Features");
    private JButton _simpleFeaturesTypesButton = new JButton("Simple Feature Types...");
    private JCheckBox _proteinAnnotationsCheckBox = new JCheckBox("Protein Annotations");
    private JCheckBox _repeatsCheckBox = new JCheckBox("Repeats");
    private JCheckBox _abInitioPredictionsCheckBox = new JCheckBox("Ab Initio Predictions");
    private JButton _predictionTypesButton = new JButton("Ab Initio Types...");
    private JList _geneTypesList = new JList();
    private JList _dnaTypesList = new JList();
    private JList _proteinTypesList = new JList();
    private JList _simpleTypesList = new JList();
    private JList _abInitioTypesList = new JList();
    private JScrollPane _geneTypesPane = new JScrollPane(this._geneTypesList);
    private JScrollPane _dnaTypesPane = new JScrollPane(this._dnaTypesList);
    private JScrollPane _proteinTypesPane = new JScrollPane(this._proteinTypesList);
    private JScrollPane _simpleTypesPane = new JScrollPane(this._simpleTypesList);
    private JScrollPane _abInitioTypesPane = new JScrollPane(this._abInitioTypesList);

    public TypesPanel(View view) {
        this._view = view;
        this.initialiseGUI();
    }

    private View getView() {
        return this._view;
    }

    public void initialiseGUI() {
        this.setLayout(new GridBagLayout());
        Dimension listSize = new Dimension(150, 160);
        this.add((Component)this.getGenesCheckBox(), GuiUtil.makeConstraintAt(0, 0, 10, true));
        this.add((Component)this.getGeneTypesButton(), GuiUtil.makeConstraintAt(1, 0, 10, true));
        this.getView().getAdapterGUI().addActionRouter(this.getGeneTypesButton(), "SHOW_GENE_COUNTS_BY_TYPE");
        this.add((Component)this.getDnaProteinAlignmentsCheckBox(), GuiUtil.makeConstraintAt(0, 1, 10, true));
        this.add((Component)this.getDnaProteinAlignmentTypesButton(), GuiUtil.makeConstraintAt(1, 1, 10, true));
        this.getView().getAdapterGUI().addActionRouter(this.getDnaProteinAlignmentTypesButton(), "SHOW_DNA_PROTEIN_COUNTS_BY_TYPE");
        this.add((Component)this.getDnaDnaAlignmentsCheckBox(), GuiUtil.makeConstraintAt(0, 2, 10, true));
        this.add((Component)this.getDnaDnaAlignmentTypesButton(), GuiUtil.makeConstraintAt(1, 2, 10, true));
        this.getView().getAdapterGUI().addActionRouter(this.getDnaDnaAlignmentTypesButton(), "SHOW_DNA_DNA_COUNTS_BY_TYPE");
        this.add((Component)this.getSimpleFeaturesCheckBox(), GuiUtil.makeConstraintAt(0, 3, 10, true));
        this.add((Component)this.getSimpleFeaturesTypesButton(), GuiUtil.makeConstraintAt(1, 3, 10, true));
        this.getView().getAdapterGUI().addActionRouter(this.getSimpleFeaturesTypesButton(), "SHOW_SIMPLE_FEATURE_COUNTS_BY_TYPE");
        this.add((Component)this.getProteinAnnotationsCheckBox(), GuiUtil.makeConstraintAt(0, 4, 10, true));
        this.add((Component)this.getRepeatsCheckBox(), GuiUtil.makeConstraintAt(0, 5, 10, true));
        this.add((Component)this.getAbInitioPredictionsCheckBox(), GuiUtil.makeConstraintAt(0, 6, 10, true));
        this.add((Component)this.getPredictionTypesButton(), GuiUtil.makeConstraintAt(1, 6, 10, true));
        this.getView().getAdapterGUI().addActionRouter(this.getPredictionTypesButton(), "SHOW_AB_INITIO_COUNTS_BY_TYPE");
        GridBagConstraints constraints = GuiUtil.makeConstraintAt(2, 0, 1, true);
        constraints.gridheight = 8;
        this.getGeneTypesPane().setPreferredSize(listSize);
        this.getDnaTypesPane().setPreferredSize(listSize);
        this.getProteinTypesPane().setPreferredSize(listSize);
        this.getSimpleTypesPane().setPreferredSize(listSize);
        this.getAbInitioTypesPane().setPreferredSize(listSize);
        this.getGeneTypesPane().setMinimumSize(listSize);
        this.getDnaTypesPane().setMinimumSize(listSize);
        this.getProteinTypesPane().setMinimumSize(listSize);
        this.getSimpleTypesPane().setMinimumSize(listSize);
        this.getAbInitioTypesPane().setMinimumSize(listSize);
        this.add((Component)this.getGeneTypesPane(), constraints);
        this.add((Component)this.getDnaTypesPane(), constraints);
        this.add((Component)this.getProteinTypesPane(), constraints);
        this.add((Component)this.getSimpleTypesPane(), constraints);
        this.add((Component)this.getAbInitioTypesPane(), constraints);
        this.getGeneTypesPane().setVisible(false);
        this.getDnaTypesPane().setVisible(false);
        this.getProteinTypesPane().setVisible(false);
        this.getSimpleTypesPane().setVisible(false);
        this.getAbInitioTypesPane().setVisible(false);
    }

    public void update(Model model) {
        TypesModel myModel = model.getTypesModel();
        myModel.setIncludeGenes(this.getCheckBoxString(this.getGenesCheckBox()));
        myModel.setIncludeDnaProteinAlignments(this.getCheckBoxString(this.getDnaProteinAlignmentsCheckBox()));
        myModel.setIncludeDnaDnaAlignments(this.getCheckBoxString(this.getDnaDnaAlignmentsCheckBox()));
        myModel.setIncludeProteinAnnotations(this.getCheckBoxString(this.getProteinAnnotationsCheckBox()));
        myModel.setIncludeSimpleFeatures(this.getCheckBoxString(this.getSimpleFeaturesCheckBox()));
        myModel.setIncludeRepeats(this.getCheckBoxString(this.getRepeatsCheckBox()));
        myModel.setIncludeAbInitioPredictions(this.getCheckBoxString(this.getAbInitioPredictionsCheckBox()));
        if (myModel.isGeneTypeCountInitialised()) {
            myModel.setSelectedGeneTypes(Arrays.asList(this.getGeneTypesList().getSelectedValues()));
        }
        if (myModel.isDnaProteinAlignmentTypeCountInitialised()) {
            myModel.setSelectedDnaProteinAlignTypes(Arrays.asList(this.getProteinTypesList().getSelectedValues()));
        }
        if (myModel.isDnaDnaAlignmentTypeCountInitialised()) {
            myModel.setSelectedDnaDnaAlignTypes(Arrays.asList(this.getDnaTypesList().getSelectedValues()));
        }
        if (myModel.isSimpleFeatureTypeCountInitialised()) {
            myModel.setSelectedSimpleFeatureTypes(Arrays.asList(this.getSimpleTypesList().getSelectedValues()));
        }
        if (myModel.isAbInitioTypeCountInitialised()) {
            myModel.setSelectedPredictionTypes(Arrays.asList(this.getAbInitioTypesList().getSelectedValues()));
        }
    }

    public void read(Model model) {
        TypesModel myModel = model.getTypesModel();
        this.setCheckBoxFromString(this.getGenesCheckBox(), myModel.includeGenes());
        this.getGenesCheckBox().setText("Genes (" + myModel.getGeneCount() + ")");
        this.setCheckBoxFromString(this.getDnaProteinAlignmentsCheckBox(), myModel.includeDnaProteinAlignments());
        this.getDnaProteinAlignmentsCheckBox().setText("Dna Protein Alignments (" + myModel.getDnaProteinAlignmentCount() + ")");
        this.setCheckBoxFromString(this.getDnaDnaAlignmentsCheckBox(), myModel.includeDnaDnaAlignments());
        this.getDnaDnaAlignmentsCheckBox().setText("Dna Dna Alignments (" + myModel.getDnaDnaAlignmentCount() + ")");
        this.setCheckBoxFromString(this.getSimpleFeaturesCheckBox(), myModel.includeSimpleFeatures());
        this.getSimpleFeaturesCheckBox().setText("Simple Features (" + myModel.getSimpleFeatureCount() + ")");
        this.setCheckBoxFromString(this.getProteinAnnotationsCheckBox(), myModel.includeProteinAnnotations());
        this.getProteinAnnotationsCheckBox().setText("Protein Annotations (" + myModel.getProteinAnnotationCount() + ")");
        this.setCheckBoxFromString(this.getRepeatsCheckBox(), myModel.includeRepeats());
        this.getRepeatsCheckBox().setText("Repeats (" + myModel.getRepeatCount() + ")");
        this.setCheckBoxFromString(this.getAbInitioPredictionsCheckBox(), myModel.includeAbInitioPredictions());
        this.getAbInitioPredictionsCheckBox().setText("Ab Initio Predictions (" + myModel.getAbInitioPredictionCount() + ")");
        if (myModel.isGeneTypeCountInitialised()) {
            this.getGeneTypesList().setListData(new Vector(myModel.getGeneTypes()));
            this.selectValuesInList(this.getGeneTypesList(), myModel.getGeneTypes(), myModel.getSelectedGeneTypes());
        }
        if (myModel.isDnaProteinAlignmentTypeCountInitialised()) {
            this.getProteinTypesList().setListData(new Vector(myModel.getDnaProteinAlignTypes()));
            this.selectValuesInList(this.getProteinTypesList(), myModel.getDnaProteinAlignTypes(), myModel.getSelectedDnaProteinAlignTypes());
        }
        if (myModel.isDnaDnaAlignmentTypeCountInitialised()) {
            this.getDnaTypesList().setListData(new Vector(myModel.getDnaDnaAlignTypes()));
            this.selectValuesInList(this.getDnaTypesList(), myModel.getDnaDnaAlignTypes(), myModel.getSelectedDnaDnaAlignTypes());
        }
        if (myModel.isSimpleFeatureTypeCountInitialised()) {
            this.getSimpleTypesList().setListData(new Vector(myModel.getSimpleFeatureTypes()));
            this.selectValuesInList(this.getSimpleTypesList(), myModel.getSimpleFeatureTypes(), myModel.getSelectedSimpleFeatureTypes());
        }
        if (myModel.isAbInitioTypeCountInitialised()) {
            this.getAbInitioTypesList().setListData(new Vector(myModel.getPredictionTypes()));
            this.selectValuesInList(this.getAbInitioTypesList(), myModel.getPredictionTypes(), myModel.getSelectedPredictionTypes());
        }
        this.getGeneTypesPane().setVisible(false);
        this.getProteinTypesPane().setVisible(false);
        this.getDnaTypesPane().setVisible(false);
        this.getSimpleTypesPane().setVisible(false);
        this.getAbInitioTypesPane().setVisible(false);
        if (myModel.getTypePanelToShow().equals("GENE")) {
            this.getGeneTypesPane().setVisible(true);
        } else if (myModel.getTypePanelToShow().equals("DNAPROTEIN")) {
            this.getProteinTypesPane().setVisible(true);
        } else if (myModel.getTypePanelToShow().equals("DNADNA")) {
            this.getDnaTypesPane().setVisible(true);
        } else if (myModel.getTypePanelToShow().equals("SIMPLEFEATURE")) {
            this.getSimpleTypesPane().setVisible(true);
        } else if (myModel.getTypePanelToShow().equals("ABINITIO")) {
            this.getAbInitioTypesPane().setVisible(true);
        }
    }

    private void selectValuesInList(JList list, List allValues, List selectionList) {
        Iterator values = selectionList.iterator();
        ArrayList<Integer> selectedPositions = new ArrayList<Integer>();
        boolean counter = false;
        boolean foundASelection = selectionList.size() > 0;
        int[] selectionArray = null;
        while (values.hasNext()) {
            Object selectedValue = values.next();
            int position = allValues.indexOf(selectedValue);
            selectedPositions.add(new Integer(position));
        }
        if (foundASelection) {
            selectionArray = new int[selectedPositions.size()];
            for (int i = 0; i < selectedPositions.size(); ++i) {
                selectionArray[i] = (Integer)selectedPositions.get(i);
            }
            list.setSelectedIndices(selectionArray);
        } else {
            list.clearSelection();
        }
    }

    private String getCheckBoxString(JCheckBox box) {
        if (box.isSelected()) {
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    private void setCheckBoxFromString(JCheckBox box, String value) {
        if (Boolean.TRUE.toString().equals(value)) {
            box.setSelected(true);
        } else {
            box.setSelected(false);
        }
    }

    private JCheckBox getGenesCheckBox() {
        return this._genesCheckBox;
    }

    private JCheckBox getDnaProteinAlignmentsCheckBox() {
        return this._dnaProteinAlignmentsCheckBox;
    }

    private JCheckBox getDnaDnaAlignmentsCheckBox() {
        return this._dnaDnaAlignmentsCheckBox;
    }

    private JCheckBox getSimpleFeaturesCheckBox() {
        return this._simpleFeaturesCheckBox;
    }

    private JCheckBox getRepeatsCheckBox() {
        return this._repeatsCheckBox;
    }

    private JCheckBox getProteinAnnotationsCheckBox() {
        return this._proteinAnnotationsCheckBox;
    }

    private JCheckBox getAbInitioPredictionsCheckBox() {
        return this._abInitioPredictionsCheckBox;
    }

    private JButton getGeneTypesButton() {
        return this._geneTypesButton;
    }

    private JButton getDnaProteinAlignmentTypesButton() {
        return this._dnaProteinAlignmentTypesButton;
    }

    private JButton getDnaDnaAlignmentTypesButton() {
        return this._dnaDnaAlignmentTypesButton;
    }

    private JButton getSimpleFeaturesTypesButton() {
        return this._simpleFeaturesTypesButton;
    }

    private JButton getPredictionTypesButton() {
        return this._predictionTypesButton;
    }

    private JList getGeneTypesList() {
        return this._geneTypesList;
    }

    private void setGeneTypesList(JList list) {
        this._geneTypesList = list;
    }

    private JScrollPane getGeneTypesPane() {
        return this._geneTypesPane;
    }

    private JList getDnaTypesList() {
        return this._dnaTypesList;
    }

    private void setDnaTypesList(JList list) {
        this._dnaTypesList = list;
    }

    private JScrollPane getDnaTypesPane() {
        return this._dnaTypesPane;
    }

    private JList getProteinTypesList() {
        return this._proteinTypesList;
    }

    private void setProteinTypesList(JList list) {
        this._proteinTypesList = list;
    }

    private JScrollPane getProteinTypesPane() {
        return this._proteinTypesPane;
    }

    private JList getSimpleTypesList() {
        return this._simpleTypesList;
    }

    private void setSimpleTypesList(JList list) {
        this._simpleTypesList = list;
    }

    private JScrollPane getSimpleTypesPane() {
        return this._simpleTypesPane;
    }

    private JList getAbInitioTypesList() {
        return this._abInitioTypesList;
    }

    private void setAbInitioTypesList(JList list) {
        this._abInitioTypesList = list;
    }

    private JScrollPane getAbInitioTypesPane() {
        return this._abInitioTypesPane;
    }
}

