/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj.controller;

import apollo.dataadapter.ensj.controller.Controller;
import apollo.dataadapter.ensj.controller.EventHandler;
import apollo.dataadapter.ensj.model.LocationModel;
import apollo.dataadapter.ensj.model.Model;
import java.util.ArrayList;

public class SelectSeqRegionHandler
extends EventHandler {
    public SelectSeqRegionHandler(Controller controller, String key) {
        super(controller, key);
    }

    public void doAction(Model model) {
        this.doUpdate();
        LocationModel locationModel = model.getLocationModel();
        String selectedSeqRegion = locationModel.getSelectedSeqRegion();
        if (!this.isNull(selectedSeqRegion)) {
            String length;
            String csString;
            if (this.isNull(locationModel.getSelectedCoordSystem())) {
                if (!locationModel.isCoordSystemInitialised()) {
                    this.log("Coord systems not initialised - finding and populating");
                    locationModel.setCoordSystems(this.findCoordinateSystems(this.getConnectionForModel(model)));
                    locationModel.setCoordSystemInitialised(true);
                    locationModel.setSeqRegions(new ArrayList());
                    locationModel.setSeqRegionInitialised(false);
                }
                if ((csString = this.findCoordSystemForNamedSeqRegion(model)) != null) {
                    locationModel.setSelectedCoordSystem(csString);
                    this.findSeqRegions(model);
                }
            }
            if ((length = String.valueOf(locationModel.getSeqRegionToLengthsMap().get(selectedSeqRegion))) == null || length.equals("null")) {
                if (!locationModel.isCoordSystemInitialised()) {
                    this.log("Coord systems not initialised - finding and populating");
                    locationModel.setCoordSystems(this.findCoordinateSystems(this.getConnectionForModel(model)));
                    locationModel.setCoordSystemInitialised(true);
                    locationModel.setSeqRegions(new ArrayList());
                    locationModel.setSeqRegionInitialised(false);
                }
                if ((csString = this.findCoordSystemForNamedSeqRegion(model)) != null) {
                    locationModel.setSelectedCoordSystem(csString);
                    this.findSeqRegions(model);
                    length = String.valueOf(locationModel.getSeqRegionToLengthsMap().get(selectedSeqRegion));
                }
            }
            model.getLocationModel().setStart("1");
            model.getLocationModel().setEnd(length);
        }
        this.doRead();
    }
}

