/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj.controller;

import apollo.dataadapter.ensj.FatalException;
import apollo.dataadapter.ensj.NonFatalException;
import apollo.dataadapter.ensj.controller.ActionEventRouter;
import apollo.dataadapter.ensj.controller.ChangeDatabaseHandler;
import apollo.dataadapter.ensj.controller.ClearSeqRegionsHandler;
import apollo.dataadapter.ensj.controller.EventHandler;
import apollo.dataadapter.ensj.controller.FindCoordSystemsHandler;
import apollo.dataadapter.ensj.controller.FindEnsemblDatabaseNamesHandler;
import apollo.dataadapter.ensj.controller.FindSeqRegionsHandler;
import apollo.dataadapter.ensj.controller.HideShowAnnotationsHandler;
import apollo.dataadapter.ensj.controller.HideShowDatabasesHandler;
import apollo.dataadapter.ensj.controller.HideShowLocationsHandler;
import apollo.dataadapter.ensj.controller.HideShowTypesHandler;
import apollo.dataadapter.ensj.controller.KeyEventRouter;
import apollo.dataadapter.ensj.controller.LoadSeqRegionByHistoryHandler;
import apollo.dataadapter.ensj.controller.PopupRouter;
import apollo.dataadapter.ensj.controller.ReadHandler;
import apollo.dataadapter.ensj.controller.SelectNewEnsemblDatabaseHandler;
import apollo.dataadapter.ensj.controller.SelectSeqRegionHandler;
import apollo.dataadapter.ensj.controller.ShowAbInitioCountsByTypeHandler;
import apollo.dataadapter.ensj.controller.ShowDnaDnaAlignCountsByTypeHandler;
import apollo.dataadapter.ensj.controller.ShowDnaProteinAlignCountsByTypeHandler;
import apollo.dataadapter.ensj.controller.ShowGeneCountsByTypeHandler;
import apollo.dataadapter.ensj.controller.ShowSimpleFeatureCountsByTypeHandler;
import apollo.dataadapter.ensj.controller.UpdateHandler;
import apollo.dataadapter.ensj.controller.UseSeqRegionLocationHandler;
import apollo.dataadapter.ensj.controller.UseStableIDLocationHandler;
import apollo.dataadapter.ensj.model.Model;
import apollo.dataadapter.ensj.view.View;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class Controller {
    private Model _model;
    private View _view;
    private HashMap _handlers = new HashMap();
    private boolean _isBusyHandlingEvent;
    public static final String UPDATE = "UPDATE";
    public static final String READ = "READ";
    public static final String HIDE_OR_SHOW_TYPES = "HIDE_OR_SHOW_TYPES";
    public static final String HIDE_OR_SHOW_DATABASE = "HIDE_OR_SHOW_DATABASE";
    public static final String HIDE_OR_SHOW_LOCATION = "HIDE_OR_SHOW_LOCATION";
    public static final String HIDE_OR_SHOW_ANNOTATIONS = "HIDE_OR_SHOW_ANNOTATIONS";
    public static final String OPEN_FILE_CHOOSER = "OPEN_FILE_CHOOSER";
    public static final String USE_STABLE_ID_LOCATION = "USE_STABLE_ID_LOCATION";
    public static final String USE_SEQ_REGION_LOCATION = "USE_SEQ_REGION_LOCATION";
    public static final String FIND_ENSEMBL_DATABASE_NAMES = "FIND_ENSEMBL_DATABASE_NAMES";
    public static final String FIND_COORD_SYSTEMS = "FIND_COORD_SYSTEMS";
    public static final String FIND_SEQ_REGIONS = "FIND_SEQ_REGIONS";
    public static final String FIND_START_ENDS = "FIND_START_ENDS";
    public static final String CHANGE_DATABASE = "CHANGE_DATABASE";
    public static final String CLEAR_SEQ_REGIONS = "CLEAR_SEQ_REGIONS";
    public static final String SELECT_SEQ_REGION = "SELECT_SEQ_REGION";
    public static final String LOAD_SEQ_REGION_BY_HISTORY = "LOAD_SEQ_REGION_BY_HISTORY";
    public static final String SELECT_NEW_ENSEMBL_DATABASE = "SELECT_NEW_ENSEMBL_DATABASE";
    public static final String SHOW_GENE_COUNTS_BY_TYPE = "SHOW_GENE_COUNTS_BY_TYPE";
    public static final String SHOW_DNA_PROTEIN_COUNTS_BY_TYPE = "SHOW_DNA_PROTEIN_COUNTS_BY_TYPE";
    public static final String SHOW_DNA_DNA_COUNTS_BY_TYPE = "SHOW_DNA_DNA_COUNTS_BY_TYPE";
    public static final String SHOW_SIMPLE_FEATURE_COUNTS_BY_TYPE = "SHOW_SIMPLE_FEATURE_COUNTS_BY_TYPE";
    public static final String SHOW_AB_INITIO_COUNTS_BY_TYPE = "SHOW_AB_INITIO_COUNTS_BY_TYPE";

    public Controller(Model model, View view) {
        this._model = model;
        this._view = view;
        this.createHandlers();
    }

    public Model getModel() {
        return this._model;
    }

    public View getView() {
        return this._view;
    }

    public void addKeyRouter(JTextField textField, String handlerKey) {
        textField.addKeyListener(new KeyEventRouter(this, handlerKey));
    }

    public void addKeyRouter(Component component, String handlerKey) {
        component.addKeyListener(new KeyEventRouter(this, handlerKey));
    }

    public void addKeyRouter(JComboBox dropDown, String handlerKey) {
        dropDown.addKeyListener(new KeyEventRouter(this, handlerKey));
    }

    public void addActionRouter(JButton button, String handlerKey) {
        button.addActionListener(new ActionEventRouter(this, handlerKey));
    }

    public void addActionRouter(JComboBox dropDown, String handlerKey) {
        dropDown.addActionListener(new ActionEventRouter(this, handlerKey));
    }

    public void addPopupRouter(JComboBox dropDown, String handlerKey) {
        dropDown.addPopupMenuListener(new PopupRouter(this, handlerKey));
    }

    private void createHandlers() {
        this.getHandlers().put(READ, new ReadHandler(this, READ));
        this.getHandlers().put(UPDATE, new UpdateHandler(this, UPDATE));
        this.getHandlers().put(HIDE_OR_SHOW_TYPES, new HideShowTypesHandler(this, HIDE_OR_SHOW_TYPES));
        this.getHandlers().put(HIDE_OR_SHOW_DATABASE, new HideShowDatabasesHandler(this, HIDE_OR_SHOW_DATABASE));
        this.getHandlers().put(HIDE_OR_SHOW_ANNOTATIONS, new HideShowAnnotationsHandler(this, HIDE_OR_SHOW_ANNOTATIONS));
        this.getHandlers().put(HIDE_OR_SHOW_LOCATION, new HideShowLocationsHandler(this, HIDE_OR_SHOW_LOCATION));
        this.getHandlers().put(USE_STABLE_ID_LOCATION, new UseStableIDLocationHandler(this, USE_STABLE_ID_LOCATION));
        this.getHandlers().put(USE_SEQ_REGION_LOCATION, new UseSeqRegionLocationHandler(this, USE_SEQ_REGION_LOCATION));
        this.getHandlers().put(CHANGE_DATABASE, new ChangeDatabaseHandler(this, CHANGE_DATABASE));
        this.getHandlers().put(FIND_ENSEMBL_DATABASE_NAMES, new FindEnsemblDatabaseNamesHandler(this, FIND_ENSEMBL_DATABASE_NAMES));
        this.getHandlers().put(FIND_COORD_SYSTEMS, new FindCoordSystemsHandler(this, FIND_COORD_SYSTEMS));
        this.getHandlers().put(FIND_SEQ_REGIONS, new FindSeqRegionsHandler(this, FIND_SEQ_REGIONS));
        this.getHandlers().put(CLEAR_SEQ_REGIONS, new ClearSeqRegionsHandler(this, CLEAR_SEQ_REGIONS));
        this.getHandlers().put(LOAD_SEQ_REGION_BY_HISTORY, new LoadSeqRegionByHistoryHandler(this, LOAD_SEQ_REGION_BY_HISTORY));
        this.getHandlers().put(SELECT_SEQ_REGION, new SelectSeqRegionHandler(this, SELECT_SEQ_REGION));
        this.getHandlers().put(SELECT_NEW_ENSEMBL_DATABASE, new SelectNewEnsemblDatabaseHandler(this, SELECT_NEW_ENSEMBL_DATABASE));
        this.getHandlers().put(SHOW_GENE_COUNTS_BY_TYPE, new ShowGeneCountsByTypeHandler(this, SHOW_GENE_COUNTS_BY_TYPE));
        this.getHandlers().put(SHOW_DNA_PROTEIN_COUNTS_BY_TYPE, new ShowDnaProteinAlignCountsByTypeHandler(this, SHOW_DNA_PROTEIN_COUNTS_BY_TYPE));
        this.getHandlers().put(SHOW_DNA_DNA_COUNTS_BY_TYPE, new ShowDnaDnaAlignCountsByTypeHandler(this, SHOW_DNA_DNA_COUNTS_BY_TYPE));
        this.getHandlers().put(SHOW_SIMPLE_FEATURE_COUNTS_BY_TYPE, new ShowSimpleFeatureCountsByTypeHandler(this, SHOW_SIMPLE_FEATURE_COUNTS_BY_TYPE));
        this.getHandlers().put(SHOW_AB_INITIO_COUNTS_BY_TYPE, new ShowAbInitioCountsByTypeHandler(this, SHOW_AB_INITIO_COUNTS_BY_TYPE));
    }

    private EventHandler getHandler(String handlerKey) {
        EventHandler handler = (EventHandler)this.getHandlers().get(handlerKey);
        if (handler == null) {
            throw new FatalException("EventHandler not found for key: " + handlerKey);
        }
        return handler;
    }

    HashMap getHandlers() {
        return this._handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEventForKey(String key) {
        this.log("Received a request for " + key + " event...");
        if (this.isBusyHandlingEvent()) {
            this.log("...ignoring because we're busy");
            return;
        }
        this.log("...processing event for key: " + key);
        try {
            this.setBusyHandlingEvent(true);
            this.getHandler(key).doAction(this.getModel());
        }
        catch (NonFatalException exception) {
            this.log("NonFatalException: " + exception.getMessage());
            exception.printStackTrace();
            this.displayMessage(exception.getMessage());
        }
        catch (FatalException exception) {
            this.log("FatalException: " + exception.getMessage());
            exception.printStackTrace();
            this.displayMessage(exception.getMessage());
        }
        finally {
            this.log("Finished processing event for key: " + key);
            this.setBusyHandlingEvent(false);
        }
    }

    public void displayMessage(String message) {
        this.getView().displayMessage(message);
    }

    public void doRead() {
        this.log("Reading view");
        this.getView().read(this.getModel());
        this.log("Finished Reading view");
    }

    public void doUpdate() {
        this.log("Updating view");
        this.getView().update(this.getModel());
        this.log("Finished Updating view");
    }

    private boolean isBusyHandlingEvent() {
        return this._isBusyHandlingEvent;
    }

    private void setBusyHandlingEvent(boolean value) {
        this._isBusyHandlingEvent = value;
    }

    public void log(String message) {
    }
}

