/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj;

import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import java.util.Vector;

public class DataModelConversionUtil {
    public static void resetTranslationStartsAndStops(SeqFeatureI sf) {
        if (sf.getNumberOfChildren() != 0) {
            FeatureSetI fs = (FeatureSetI)sf;
            if (fs.getTranslationStart() != 0) {
                String stop_codon;
                fs.setTranslationStart(fs.getTranslationStart());
                if (fs.getStartCodon() != null && !fs.getStartCodon().equals("ATG") && fs.getFeaturePosition(fs.getTranslationStart()) < 4) {
                    fs.setMissing5prime(true);
                }
                if ((stop_codon = fs.getRefSequence().getResidues(fs.getTranslationEnd() - 2 * fs.getStrand(), fs.getTranslationEnd())) != null) {
                    if (stop_codon.equals("TGA") || stop_codon.equals("TAG") || stop_codon.equals("TAA")) {
                        System.out.println("stop = " + stop_codon);
                        fs.setTranslationEnd(fs.getTranslationEnd() - 2 * fs.getStrand());
                    } else {
                        System.out.println("Missed stop = " + stop_codon);
                        fs.setMissing3prime(true);
                    }
                }
            } else {
                Vector feats = fs.getFeatures();
                for (int i = 0; i < feats.size(); ++i) {
                    DataModelConversionUtil.resetTranslationStartsAndStops((SeqFeatureI)feats.get(i));
                }
            }
        }
    }
}

