/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.das.simple;

import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.das.DASDsn;
import apollo.dataadapter.das.DASFeature;
import apollo.dataadapter.das.DASSegment;
import apollo.dataadapter.das.DASServerI;
import apollo.dataadapter.das.simple.SimpleDASFeature;
import apollo.dataadapter.das.simple.SimpleDASSegment;
import apollo.dataadapter.das.simple.SimpleDASServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DASFeatureContentHandler
extends DefaultHandler {
    private String mode;
    private Stack modeStack = new Stack();
    private List featureArray = new ArrayList();
    private String DASGFF = "DASGFF";
    private String SEGMENT = "SEGMENT";
    private String FEATURE = "FEATURE";
    private String TYPE = "TYPE";
    private String METHOD = "METHOD";
    private String START = "START";
    private String END = "END";
    private String SCORE = "SCORE";
    private String ORIENTATION = "ORIENTATION";
    private String PHASE = "PHASE";
    private String NOTE = "NOTE";
    private String GROUP = "GROUP";
    private String TARGET = "TARGET";
    private String GROUPTARGET = "GROUPTARGET";
    private String LABEL = "label";
    private String ID = "id";
    private String SEGMENT_ID = "id";
    private String SEGMENT_START = "start";
    private String SEGMENT_STOP = "stop";
    private String METHOD_ID = "id";
    private String TYPE_ID = "id";
    private String TYPE_CATEGORY = "category";
    private String TYPE_REFERENCE = "reference";
    private String TYPE_SUBPARTS = "subparts";
    private String TARGET_ID = "id";
    private String TARGET_START = "start";
    private String TARGET_STOP = "stop";
    private String GROUP_ID = "id";
    private String GROUP_TARGET_START = "start";
    private String GROUP_TARGET_STOP = "stop";
    private DASFeature currentFeature;
    private DASSegment currentSegment;
    public DASServerI server;
    public HashMap parentFeatures;
    public HashMap segments;
    public DASDsn dsn;
    public HashMap segmentsToBeRequested = new HashMap();
    public HashMap parentFeaturesOfSegmentsToBeRequested = new HashMap();
    private static boolean print = true;
    private long globalStart;
    private long globalEnd;

    public DASFeatureContentHandler() {
    }

    public DASFeatureContentHandler(DASServerI theServer, DASDsn theDsn, HashMap theSegments, HashMap theParentFeatures, long theGlobalStart, long theGlobalEnd) {
        this.server = theServer;
        this.dsn = theDsn;
        this.segments = theSegments;
        this.parentFeatures = theParentFeatures;
        this.globalStart = theGlobalStart;
        this.globalEnd = theGlobalEnd;
    }

    private long getGlobalStart() {
        return this.globalStart;
    }

    private long getGlobalEnd() {
        return this.globalEnd;
    }

    private DASServerI getServer() {
        return this.server;
    }

    private HashMap getSegments() {
        return this.segments;
    }

    private DASDsn getDSN() {
        return this.dsn;
    }

    private void setSegments(HashMap theSegments) {
        this.segments = theSegments;
    }

    private void setDSN(DASDsn theDSN) {
        this.dsn = theDSN;
    }

    private HashMap getSegmentsToBeRequested() {
        return this.segmentsToBeRequested;
    }

    private HashMap getParentFeaturesOfSegmentsToBeRequested() {
        return this.parentFeaturesOfSegmentsToBeRequested;
    }

    private HashMap getParentFeatures() {
        return this.parentFeatures;
    }

    private DASFeature getCurrentFeature() {
        return this.currentFeature;
    }

    private void setCurrentFeature(DASFeature theFeature) {
        this.currentFeature = theFeature;
    }

    private DASSegment getCurrentSegment() {
        return this.currentSegment;
    }

    private void setCurrentSegment(DASSegment theSegment) {
        this.currentSegment = theSegment;
    }

    private void addFeature(DASFeature theFeature) {
        this.getFeatures().add(theFeature);
    }

    public List getFeatures() {
        return this.featureArray;
    }

    private Stack getModeStack() {
        return this.modeStack;
    }

    private void setMode(String theMode) {
        this.getModeStack().push(theMode);
    }

    private String getMode() {
        if (!this.getModeStack().isEmpty()) {
            return (String)this.getModeStack().peek();
        }
        return null;
    }

    private void closeMode() {
        if (!this.getModeStack().isEmpty()) {
            this.getModeStack().pop();
        }
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.DASGFF.equals(localName)) {
            this.setMode(this.DASGFF);
        } else if (this.SEGMENT.equals(localName)) {
            this.setMode(this.SEGMENT);
            this.setCurrentSegment(new SimpleDASSegment(attributes.getValue(this.SEGMENT_ID), attributes.getValue(this.SEGMENT_ID), attributes.getValue(this.SEGMENT_START), attributes.getValue(this.SEGMENT_STOP), "", "", ""));
        } else if (this.FEATURE.equals(localName)) {
            this.setMode(this.FEATURE);
            this.setCurrentFeature(new SimpleDASFeature(attributes.getValue(this.ID)));
            this.getCurrentFeature().setId(attributes.getValue(this.ID));
            this.getCurrentFeature().setLabel(attributes.getValue(this.LABEL));
        } else if (this.TYPE.equals(localName)) {
            this.setMode(this.TYPE);
            this.getCurrentFeature().setTypeId(attributes.getValue(this.TYPE_ID));
            this.getCurrentFeature().setTypeCategory(attributes.getValue(this.TYPE_CATEGORY));
            this.getCurrentFeature().setTypeReference(attributes.getValue(this.TYPE_REFERENCE));
            this.getCurrentFeature().setTypeSubparts(attributes.getValue(this.TYPE_SUBPARTS));
        } else if (this.METHOD.equals(localName)) {
            this.setMode(this.METHOD);
            this.getCurrentFeature().setMethodId(attributes.getValue(this.METHOD_ID));
        } else if (this.START.equals(localName)) {
            this.setMode(this.START);
        } else if (this.END.equals(localName)) {
            this.setMode(this.END);
        } else if (this.ORIENTATION.equals(localName)) {
            this.setMode(this.ORIENTATION);
        } else if (this.PHASE.equals(localName)) {
            this.setMode(this.PHASE);
        } else if (this.NOTE.equals(localName)) {
            this.setMode(this.NOTE);
        } else if (this.GROUP.equals(localName)) {
            this.setMode(this.GROUP);
            this.getCurrentFeature().setGroupId(attributes.getValue(this.GROUP_ID));
        } else if (this.TARGET.equals(localName)) {
            if (this.getMode().equals(this.FEATURE)) {
                this.setMode(this.TARGET);
                this.getCurrentFeature().setTargetId(attributes.getValue(this.TARGET_ID));
                this.getCurrentFeature().setTargetStart(attributes.getValue(this.TARGET_START));
                this.getCurrentFeature().setTargetStop(attributes.getValue(this.TARGET_STOP));
            } else if (this.getMode().equals(this.GROUP)) {
                this.setMode(this.GROUPTARGET);
                this.getCurrentFeature().setGroupTargetStart(attributes.getValue(this.GROUP_TARGET_START));
                this.getCurrentFeature().setGroupTargetStop(attributes.getValue(this.GROUP_TARGET_STOP));
            } else {
                throw new NonFatalDataAdapterException("TARGET element found as a child to neither FEATURE nor GROUP!");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mapCurrentFeatureCoordinatesToParentFeature(DASFeature theCurrentFeature, DASFeature theParentFeature, DASSegment theParentSegment) {
        int parentStart = Integer.valueOf(theParentFeature.getStart());
        int parentEnd = Integer.valueOf(theParentFeature.getEnd());
        int windowStart = Integer.valueOf(theParentSegment.getStart());
        int localStart = Integer.valueOf(theCurrentFeature.getStart());
        int localEnd = Integer.valueOf(theCurrentFeature.getEnd());
        if (theParentFeature == null) return;
        if (theParentFeature.getOrientation().equals("+")) {
            theCurrentFeature.setStart(String.valueOf(parentStart + localStart - windowStart));
            theCurrentFeature.setEnd(String.valueOf(parentStart + localEnd - windowStart));
            if (theCurrentFeature.getOrientation().equals("+")) {
                theCurrentFeature.setOrientation("+");
                return;
            } else if (theCurrentFeature.getOrientation().equals("-")) {
                theCurrentFeature.setOrientation("-");
                return;
            } else {
                if (!theCurrentFeature.getOrientation().equals("0")) throw new NonFatalDataAdapterException("Feature with undefined orientation: " + this.currentFeature);
                theCurrentFeature.setOrientation("0");
            }
            return;
        } else {
            if (!theParentFeature.getOrientation().equals("-")) throw new NonFatalDataAdapterException("Parent Feature with undefined orientation: " + theParentFeature);
            theCurrentFeature.setStart(String.valueOf(parentEnd - localEnd + windowStart));
            theCurrentFeature.setEnd(String.valueOf(parentEnd - localStart + windowStart));
            if (theCurrentFeature.getOrientation().equals("+")) {
                theCurrentFeature.setOrientation("-");
                return;
            } else if (theCurrentFeature.getOrientation().equals("-")) {
                theCurrentFeature.setOrientation("+");
                return;
            } else {
                if (!theCurrentFeature.getOrientation().equals("0")) throw new NonFatalDataAdapterException("Child Feature with undefined orientation: " + this.currentFeature);
                theCurrentFeature.setOrientation("0");
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (this.DASGFF.equals(localName)) {
            if (this.getSegmentsToBeRequested().size() > 0) {
                this.getFeatures().addAll(((SimpleDASServer)this.getServer()).getFeatures(this.getDSN(), this.getSegmentsToBeRequested(), this.getParentFeaturesOfSegmentsToBeRequested(), this.getGlobalStart(), this.getGlobalEnd()));
            }
        } else if (this.SEGMENT.equals(localName)) {
            this.setCurrentSegment(null);
            this.closeMode();
        } else if (this.FEATURE.equals(localName)) {
            boolean hasSubcomponents;
            DASFeature theCurrentFeature = this.getCurrentFeature();
            if (this.getParentFeatures().get(this.getCurrentSegment().getId()) != null) {
                this.mapCurrentFeatureCoordinatesToParentFeature(theCurrentFeature, (DASFeature)this.getParentFeatures().get(this.getCurrentSegment().getId()), (DASSegment)this.getSegments().get(this.getCurrentSegment().getId()));
            }
            boolean liesWhollyOutsideRange = (long)Integer.valueOf(theCurrentFeature.getEnd()).intValue() < this.getGlobalStart() || (long)Integer.valueOf(theCurrentFeature.getStart()).intValue() > this.getGlobalEnd();
            boolean liesPartlyOutsideRange = liesWhollyOutsideRange || (long)Integer.valueOf(theCurrentFeature.getStart()).intValue() < this.getGlobalStart() && (long)Integer.valueOf(theCurrentFeature.getEnd()).intValue() >= this.getGlobalStart() || (long)Integer.valueOf(theCurrentFeature.getEnd()).intValue() > this.getGlobalEnd() && (long)Integer.valueOf(theCurrentFeature.getStart()).intValue() <= this.getGlobalEnd();
            boolean bl = hasSubcomponents = theCurrentFeature.getTypeReference() != null && theCurrentFeature.getTypeReference().equals("yes") || theCurrentFeature.getTypeSubparts() != null && theCurrentFeature.getTypeSubparts().equals("yes");
            if (hasSubcomponents) {
                if (!liesWhollyOutsideRange && theCurrentFeature.getTargetId() != null && theCurrentFeature.getTargetId().trim().length() > 0) {
                    this.getSegmentsToBeRequested().put(theCurrentFeature.getTargetId(), new SimpleDASSegment(theCurrentFeature.getTargetId(), theCurrentFeature.getTargetId(), theCurrentFeature.getTargetStart(), theCurrentFeature.getTargetStop(), "", "", ""));
                    this.getParentFeaturesOfSegmentsToBeRequested().put(theCurrentFeature.getTargetId(), theCurrentFeature);
                    this.addFeature(theCurrentFeature);
                }
            } else if (!liesPartlyOutsideRange) {
                this.addFeature(theCurrentFeature);
            }
            this.setCurrentFeature(null);
            this.closeMode();
        } else if (this.METHOD.equals(localName)) {
            this.closeMode();
        } else if (this.START.equals(localName)) {
            this.closeMode();
        } else if (this.END.equals(localName)) {
            this.closeMode();
        } else if (this.SCORE.equals(localName)) {
            this.closeMode();
        } else if (this.ORIENTATION.equals(localName)) {
            this.closeMode();
        } else if (this.PHASE.equals(localName)) {
            this.closeMode();
        } else if (this.NOTE.equals(localName)) {
            this.closeMode();
        } else if (this.TARGET.equals(localName)) {
            this.closeMode();
        } else if (this.GROUP.equals(localName)) {
            this.closeMode();
        } else if (this.GROUPTARGET.equals(localName)) {
            this.closeMode();
        }
    }

    public void characters(char[] text, int start, int length) throws SAXException {
        String characters = new StringBuffer().append(text, start, length).toString();
        String mode = this.getMode();
        DASFeature feature = this.getCurrentFeature();
        if (mode != null && feature != null) {
            if (mode.equals(this.TYPE)) {
                feature.setTypeLabel(characters);
            } else if (mode.equals(this.METHOD)) {
                feature.setMethodLabel(characters);
            } else if (mode.equals(this.START)) {
                feature.setStart(characters);
            } else if (mode.equals(this.END)) {
                feature.setEnd(characters);
            } else if (mode.equals(this.SCORE)) {
                feature.setScore(characters);
            } else if (mode.equals(this.ORIENTATION)) {
                feature.setOrientation(characters);
            } else if (mode.equals(this.PHASE)) {
                feature.setPhase(characters);
            } else if (mode.equals(this.NOTE)) {
                feature.setNote(characters);
            }
        }
    }
}

