/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chadoxml;

import apollo.config.Config;
import apollo.dataadapter.TransactionOutputAdapter;
import apollo.dataadapter.TransactionTransformer;
import apollo.dataadapter.chado.ChadoTransaction;
import apollo.dataadapter.chado.ChadoTransactionTransformer;
import apollo.dataadapter.chadoxml.ChadoTransactionXMLTemplate;
import apollo.util.IOUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChadoTransactionXMLWriter
extends TransactionOutputAdapter {
    private static final String TN_EXT_NAME = ".ctn";

    public void setTarget(Object target) {
        if (!(target instanceof String)) {
            throw new IllegalArgumentException("ChadoTransactionXMLWriter.setTarget(): target should be a file name.");
        }
        super.setTarget(this.parseAnnotFileName(target.toString()));
    }

    private String parseAnnotFileName(String annotFileName) {
        int index1 = annotFileName.indexOf(File.separator);
        int index2 = -1;
        index2 = annotFileName.lastIndexOf(".");
        String tranFileName = index2 == -1 ? annotFileName + TN_EXT_NAME : annotFileName.substring(0, index2) + TN_EXT_NAME;
        return tranFileName;
    }

    protected void commitTransformedTransactions(List chadoTransactions) throws Exception {
        if (chadoTransactions == null) {
            chadoTransactions = new ArrayList();
        }
        System.out.println("Saving " + chadoTransactions.size() + " transaction objects");
        StringBuffer buffer = new StringBuffer();
        String name = "conf" + File.separator + Config.getChadoTemplateName();
        String tmpFileName = IOUtil.findFile(name);
        if (tmpFileName == null) {
            throw new IllegalStateException("ChadoTransactionXML.commitTransactions(): Cannot find xml template for chado transaction.");
        }
        ChadoTransactionXMLTemplate template = new ChadoTransactionXMLTemplate(tmpFileName);
        template.setStartIndent("    ");
        template.setIndent("    ");
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buffer.append(template.getRootStartTag());
        if (chadoTransactions.size() > 0) {
            buffer.append(template.getPreambleString());
            ChadoTransaction ts = ((ChadoTransactionTransformer)this.transformer).createSrcFeatureIDTransaction(this.mapID, this.mapType);
            buffer.append(template.generateElement(ts));
            Iterator it = chadoTransactions.iterator();
            while (it.hasNext()) {
                ts = (ChadoTransaction)it.next();
                buffer.append(template.generateElement(ts));
            }
        }
        buffer.append(template.getRootEndTag());
        this.saveToFile(buffer, (String)this.target);
        System.out.println("Saved Chado transactions to " + this.target);
    }

    private void saveToFile(StringBuffer buffer, String fileName) throws IOException {
        FileWriter fileWriter = new FileWriter(fileName);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(buffer.toString());
        bufferedWriter.close();
        fileWriter.close();
    }

    public void setTransformer(TransactionTransformer transformer) {
        super.setTransformer(transformer);
        if (transformer instanceof ChadoTransactionTransformer) {
            String configFileName = Config.getChadoJdbcAdapterConfigFile();
            if (configFileName == null) {
                System.out.println("cant find chado cfg file -> cant transform transactions to chado");
                return;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = dbf.newDocumentBuilder();
                Document doc = null;
                doc = builder.parse(configFileName);
                Element root = doc.getDocumentElement();
                NodeList list = root.getChildNodes();
                int size = list.getLength();
                for (int i = 0; i < size; ++i) {
                    String isDefault;
                    Node node = list.item(i);
                    if (!node.getNodeName().equals("chadoInstance") || (isDefault = ((Element)node).getAttribute("default")) == null || !isDefault.equals("true")) continue;
                    this.initFeaturesForLevels(node, (ChadoTransactionTransformer)transformer);
                    break;
                }
            }
            catch (Exception e) {
                System.err.println("ChadoTransactionWriter.setTransformer(): " + e);
                e.printStackTrace();
            }
        }
    }

    private void initFeaturesForLevels(Node node, ChadoTransactionTransformer transformer) {
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node tmp = children.item(i);
            String nodeName = tmp.getNodeName();
            if (nodeName.equals("oneLevelAnnotTypes")) {
                transformer.setOneLevelAnnotTypes(this.extractTypes(tmp));
                continue;
            }
            if (nodeName.equals("threeLevelAnnotTypes")) {
                transformer.setThreeLevelAnnotTypes(this.extractTypes(tmp));
                continue;
            }
            if (!nodeName.equals("polypeptideType")) continue;
            transformer.setPolypeptideType(tmp.getFirstChild().getNodeValue());
        }
    }

    private List extractTypes(Node typeNode) {
        NodeList children = typeNode.getChildNodes();
        int size = children.getLength();
        ArrayList<String> rtn = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            Node tmp = children.item(i);
            if (!tmp.getNodeName().equals("type")) continue;
            rtn.add(tmp.getFirstChild().getNodeValue());
        }
        return rtn;
    }
}

