/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado.jdbc;

import apollo.dataadapter.chado.jdbc.ChadoFeatureLoc;
import apollo.dataadapter.chado.jdbc.JdbcChadoAdapter;
import apollo.datamodel.SequenceI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

class FeatureLocImplementation {
    protected int featId;
    private ChadoFeatureLoc featureLoc;
    protected Connection conn;
    protected boolean haveRedundantFeatLocs;
    private int padding = 0;
    private String topLevelFeatName;

    protected FeatureLocImplementation() {
    }

    FeatureLocImplementation(long featId, boolean redundantLocs, Connection conn) {
        this(featId, redundantLocs, conn, 0);
    }

    FeatureLocImplementation(long featId, boolean haveRedundantFeatLocs, Connection conn, int padding) {
        this.featId = (int)featId;
        this.conn = conn;
        this.haveRedundantFeatLocs = haveRedundantFeatLocs;
        this.padding = padding;
    }

    private ChadoFeatureLoc getFeatureLoc() {
        if (this.featureLoc == null) {
            this.featureLoc = new ChadoFeatureLoc(this.featId, this.conn);
        }
        return this.featureLoc;
    }

    int getContainingFeatureId() {
        return this.haveRedundantFeatLocs ? this.featId : this.getFeatureLoc().getSourceFeatureId();
    }

    int getFeatureId() {
        return this.featId;
    }

    void setPadding(int padding) {
        this.padding = padding;
    }

    private boolean noPadding() {
        return this.padding == 0;
    }

    protected boolean featLocSameAsFeatRange() {
        return this.noPadding();
    }

    int getBaseOrientedMinWithPadding() {
        return this.getFeatureLoc().getBaseOrientedMin() - this.padding;
    }

    int getMaxWithPadding() {
        return this.getFeatureLoc().getFmax() + this.padding;
    }

    int getLengthWithPadding() {
        return this.getFeatureLoc().getLength() + 2 * this.padding;
    }

    String getContainingFeatureWhereClause(String featLocTableName) {
        if (this.haveRedundantFeatLocs && this.noPadding()) {
            return "";
        }
        int min = this.getFeatureLoc().getFmin() - this.padding;
        int max = this.getFeatureLoc().getFmax() + this.padding;
        return " AND " + featLocTableName + ".fmax > " + min + " AND " + featLocTableName + ".fmin < " + max + " ";
    }

    boolean hasTopLevelName() {
        return this.topLevelFeatName != null;
    }

    void setTopLevelFeatName(String name) {
        this.topLevelFeatName = name;
    }

    String getTopLevelFeatName() {
        return this.topLevelFeatName;
    }

    SequenceI retrieveSequence(JdbcChadoAdapter adapter) {
        if (this.featLocSameAsFeatRange()) {
            return adapter.getSequence(this.getFeatureId());
        }
        return this.retrieveSequenceUsingFeatLoc(adapter);
    }

    private SequenceI retrieveSequenceUsingFeatLoc(JdbcChadoAdapter adap) {
        String sql = "SELECT f.name, f.organism_id, substring(residues from " + this.getBaseOrientedMinWithPadding() + " for " + this.getLengthWithPadding() + ") as seq " + "FROM feature f " + "WHERE f.feature_id = " + this.getContainingFeatureId();
        JdbcChadoAdapter.debugMsgAndTime("getting seq from parent substring. sql =\n" + sql);
        try {
            ResultSet rs = adap.getConnection().createStatement().executeQuery(sql);
            if (rs.next()) {
                this.setTopLevelFeatName(rs.getString("name"));
                String name = this.getTopLevelFeatName() + ":" + this.getBaseOrientedMinWithPadding() + "-" + this.getMaxWithPadding();
                String residues = rs.getString("seq");
                String organism = adap.getOrganismFullName(rs.getInt("organism_id"));
                return adap.makeSequence(name, residues, organism);
            }
        }
        catch (SQLException sqle) {
            adap.sqlError(sqle, "retrieving parent sequence " + sql);
        }
        return null;
    }
}

