/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.analysis;

import apollo.analysis.filter.AnalysisInput;
import apollo.analysis.filter.Compress;
import apollo.dataadapter.analysis.AlignmentParser;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeaturePairI;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.util.FastaHeader;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Stack;
import org.bdgp.util.DNAUtils;

public class Sim4Parser
extends AlignmentParser {
    boolean complement = false;
    boolean introns_reverse;
    boolean introns_forward;
    int donor_index;
    Stack introns = new Stack();
    int line_number = 0;
    String seq1_line;
    String seq2_line;
    String fasta1_line;
    String fasta2_line;
    AnalysisInput analysis_input;
    private static String[] intron_begin = new String[]{"|>", " >", "->", "|<", " <", "-<"};
    private static String[] intron_end = new String[]{">|", "> ", ">-", "<|", "< ", "<-", ">>>", "<<<"};

    public String load(CurationSet curation, boolean new_curation, InputStream data_stream, AnalysisInput input) {
        this.analysis_input = input;
        this.initLoad(curation, new_curation, data_stream, input);
        if (this.parsed) {
            try {
                while (this.seq2_line != null) {
                    FeatureSetI match = this.setupMatch(curation);
                    if (match != null) {
                        this.introns.clear();
                        this.line = this.grabSpans(match);
                        if (match.size() > 0) {
                            if (this.introns_reverse || this.complement && !this.introns_forward && !this.introns_reverse) {
                                if (!this.complement && this.introns_reverse) {
                                    this.thisIsOdd(match);
                                }
                                this.revIt(match);
                            } else if (this.complement && this.introns_forward) {
                                this.thisIsOdd(match);
                            }
                            if (this.introns_forward || this.introns_reverse) {
                                match.addProperty("sim4_set", "true");
                            }
                            if (match.getStrand() == 1) {
                                this.forward_analysis.addFeature(match, true);
                            } else {
                                this.reverse_analysis.addFeature(match, true);
                            }
                        }
                    } else {
                        this.readLine();
                    }
                    this.findMatch(curation, false);
                }
                this.data.close();
            }
            catch (Exception ex) {
                this.parsed = false;
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        return this.parsed ? this.getAnalysisType() : null;
    }

    public String getProgram() {
        return "sim4";
    }

    public boolean recognizedInput() {
        boolean found = false;
        try {
            this.readLine();
            found = this.findMatch(this.curation, this.new_curation);
            if (found) {
                this.database = this.grabDatabase();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return found;
    }

    private boolean findMatch(CurationSet curation, boolean new_curation) throws ParseException {
        this.seq1_line = null;
        this.seq2_line = null;
        this.fasta1_line = null;
        this.fasta2_line = null;
        try {
            while (this.line != null && this.seq2_line == null) {
                if (this.line.startsWith("seq1 = ")) {
                    this.seq1_line = this.line;
                } else if (this.line.startsWith("seq2 = ") && this.validSeq2(this.line)) {
                    this.seq2_line = this.line;
                }
                this.readLine();
            }
            this.readLine();
            if (this.line != null && this.line.startsWith(">")) {
                this.fasta1_line = this.line;
                this.readLine();
                if (this.line != null && this.line.startsWith(">")) {
                    this.fasta2_line = this.line;
                    this.readLine();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.seq1_line != null && this.seq2_line != null) {
            if (curation.getRefSequence() == null) {
                SequenceI focal_seq;
                int query_length = this.parseLength(this.seq1_line);
                if (this.fasta1_line != null) {
                    focal_seq = this.initSequence(curation, this.fasta1_line, query_length);
                } else {
                    int index = this.seq1_line.lastIndexOf(47);
                    if (index < 0) {
                        index = "seq1 = ".length();
                    }
                    focal_seq = this.initSequence(curation, this.seq1_line.substring(index), query_length);
                }
                this.initCuration(curation, focal_seq);
            }
            return true;
        }
        return false;
    }

    protected int parseLength(String line) throws ParseException {
        String length_str = "";
        int length = 0;
        try {
            length_str = line.substring(line.lastIndexOf(", ") + ", ".length(), line.lastIndexOf(" bp"));
            length = Integer.parseInt(length_str);
        }
        catch (RuntimeException ex) {
            throw new ParseException("Error parsing line, looking for \", bp\":  " + line, this.line_number);
        }
        return length;
    }

    protected String grabDatabase() {
        String db = this.analysis_input.getDatabase();
        if (db == null || db.equals("")) {
            int index = this.seq2_line.lastIndexOf("/") > 0 ? this.seq2_line.lastIndexOf("/") + "/".length() : "seq2 = ".length();
            db = this.seq2_line.substring(index);
            if ((index = db.indexOf(" ")) > 0) {
                db = db.substring(0, index);
            }
            System.out.println("Sim4 parsed out db " + db);
            this.analysis_input.setDatabase(db);
        }
        return db;
    }

    private FeatureSetI setupMatch(CurationSet curation) throws ParseException {
        int length;
        SequenceI seq;
        String header;
        FeatureSetI match = null;
        if (this.fasta2_line == null) {
            try {
                int index = this.seq2_line.indexOf(" (>");
                header = this.seq2_line.substring(index + " (".length(), this.seq2_line.indexOf("), ", index));
            }
            catch (Exception e) {
                throw new ParseException("Error parsing header from " + this.seq2_line, this.line_number);
            }
        } else {
            header = this.fasta2_line;
        }
        FastaHeader temp = new FastaHeader(header);
        String match_name = temp.getSeqId();
        if (match_name.indexOf(curation.getRefSequence().getName()) < 0 && (seq = this.initSequence(curation, header, length = this.parseLength(this.seq2_line))) != null) {
            match = this.initAlignment(seq, 0);
        }
        return match;
    }

    private boolean validSeq2(String line) {
        int open_paren = line.indexOf("(");
        int close_paren = line.lastIndexOf("),");
        return open_paren >= 0 && close_paren >= 0 && open_paren + "(".length() < close_paren;
    }

    private String grabSpans(FeatureSetI match) throws ParseException {
        this.line = "";
        boolean value_found = false;
        boolean keep_it = true;
        this.complement = false;
        this.donor_index = -1;
        SequenceI aligned_seq = match.getHitSequence();
        FeaturePairI prev_span = null;
        int seq_length = aligned_seq.getLength();
        try {
            this.readLine();
            while (this.line != null && !value_found) {
                String untrimmed_line = this.line;
                this.line = this.line.trim();
                if (this.line.startsWith("seq")) {
                    if (prev_span != null) {
                        this.rollCigar(prev_span);
                    }
                    value_found = true;
                } else if (this.line.startsWith(">")) {
                    System.out.println("This should no longer happen");
                } else if (this.line.length() > 0 && this.line.startsWith("(complement)")) {
                    this.complement = true;
                } else if (this.line.indexOf("%") >= 0 && this.line.indexOf("(") >= 0) {
                    FeaturePairI span;
                    int index = this.line.indexOf("-");
                    if ((keep_it &= index > 0) && (span = this.grabSpan(seq_length)) != null && !this.overlapsExisting(match, span)) {
                        if (match.size() == 0) {
                            match.setStrand(span.getStrand());
                        }
                        this.addAlignPair(span, match);
                    }
                } else if (this.line.length() > 0 && untrimmed_line.indexOf("0 ") >= 0 && untrimmed_line.charAt(0) == ' ') {
                    keep_it &= (prev_span = this.grabAlignment(seq_length, match, prev_span)) != null;
                } else if (this.line.length() > 0) {
                    if (this.line.indexOf("The two sequences are not really similar.") >= 0 || this.line.indexOf("Please try an exact aligning method.") >= 0) {
                        System.err.println(match.getHitSequence().getName() + ": sim4 has a warning \"" + this.line + "\"");
                    } else {
                        System.err.println(match.getHitSequence().getName() + ": Don't know how to parse \"" + this.line + "\"");
                    }
                }
                if (value_found) continue;
                this.readLine();
            }
        }
        catch (RuntimeException ex) {
            throw new ParseException("Error parsing " + this.line, this.line_number);
        }
        catch (Exception ex) {
            System.err.println("Could not parse " + this.line + " for " + aligned_seq.getName());
            System.out.println(ex.getMessage());
            keep_it = false;
            ex.printStackTrace();
        }
        if (match.size() > 0) {
            this.setIntrons(match);
        }
        if (!(keep_it &= !this.introns_forward || !this.introns_reverse)) {
            String name = match.getHitSequence().getName();
            while (match.size() > 0) {
                match.deleteFeatureAt(0);
            }
        }
        return this.line;
    }

    private FeaturePairI grabSpan(int seq_length) throws ParseException {
        String before = this.line;
        FeaturePairI span = null;
        try {
            int index = this.line.indexOf("-");
            String seq_start = this.line.substring(0, index);
            this.line = this.line.substring(++index);
            index = this.line.indexOf(" ");
            String seq_end = this.line.substring(0, index);
            index = this.line.indexOf("(");
            this.line = this.line.substring(++index);
            index = this.line.indexOf("-");
            String match_start = this.line.substring(0, index);
            this.line = this.line.substring(++index);
            index = this.line.indexOf(")");
            String match_end = this.line.substring(0, index);
            this.line = this.line.substring(++index);
            index = this.line.indexOf("%");
            String score = this.line.substring(0, index);
            score = score.trim();
            String current_intron = this.line.indexOf("<-") >= 0 ? "reverse" : (this.line.indexOf("->") >= 0 ? "forward" : "");
            this.introns.push(current_intron);
            span = this.initAlignPair();
            int genomic_offset = this.input.getOffset();
            int start = Integer.parseInt(seq_start);
            int end = Integer.parseInt(seq_end);
            span.setStrand(start <= end ? 1 : -1);
            span.setStart(start + genomic_offset);
            span.setEnd(end + genomic_offset);
            start = Integer.parseInt(match_start);
            end = Integer.parseInt(match_end);
            span.setHstrand(start <= end ? 1 : -1);
            span.setHstart(start);
            span.setHend(end);
            span.setScore(Double.valueOf(score));
            span.addScore("identity", span.getScore());
        }
        catch (RuntimeException ex) {
            throw new ParseException("Error parsing " + before, this.line_number);
        }
        return span;
    }

    private void setIntrons(FeatureSetI match) {
        this.introns_reverse = false;
        this.introns_forward = false;
        this.introns.pop();
        int exon_cnt = match.size();
        if (exon_cnt > 1) {
            String name;
            int intron_length;
            int index = exon_cnt - 1;
            FeaturePairI span = (FeaturePairI)match.getFeatureAt(index);
            String dna = span.getResidues();
            if (Compress.isPolyATail(dna, intron_length = Math.abs(span.getStart() - match.getFeatureAt(index - 1).getEnd()), (name = span.getHitFeature().getRefSequence().getName()) + "-span:" + (index + 1), false)) {
                this.debugFeature(match, "Deleting polyA tail from end  intron:exon is " + intron_length + ":" + dna.length() + " dna=" + dna);
                match.deleteFeature(span);
                match.setFlag(true, FeatureSet.POLYA_REMOVED);
                String stuff = (String)this.introns.pop();
            } else {
                span = (FeaturePairI)match.getFeatureAt(0);
                dna = span.getResidues();
                if (Compress.isPolyATail(dna, intron_length = match.size() > 1 ? Math.abs(match.getFeatureAt(1).getStart() - span.getEnd()) : 0, (name = span.getHitFeature().getRefSequence().getName()) + "-span:1", false)) {
                    this.debugFeature(match, "Deleting polyA tail from beginning  intron:exon is " + intron_length + ":" + dna.length() + " dna=" + dna);
                    match.deleteFeature(span);
                    match.setFlag(true, FeatureSet.POLYA_REMOVED);
                    if (!this.introns.empty()) {
                        this.introns.removeElementAt(0);
                    }
                }
            }
        }
        String name = match.getHitSequence().getName();
        while (!this.introns.empty()) {
            String current_intron = (String)this.introns.pop();
            this.introns_forward |= current_intron.equals("forward");
            this.introns_reverse |= current_intron.equals("reverse");
        }
    }

    private int findPositionIndex(String align_line) {
        int index = -1;
        boolean found = false;
        for (int i = 0; i < align_line.length() && !found; ++i) {
            char c = align_line.charAt(i);
            if (Character.isDigit(c)) {
                index = i + 1;
                continue;
            }
            found = index >= 0;
        }
        return index;
    }

    private int parsePosition(String align_line, int space) {
        int pos = 0;
        try {
            pos = space >= 0 ? Integer.parseInt(align_line.substring(0, space).trim()) : Integer.parseInt(align_line);
        }
        catch (Exception e) {
            System.out.println("Unable to parse alignment position from " + align_line + " at " + space);
        }
        return pos;
    }

    private String trimOffPosition(String align_line, int index) {
        if (index >= 0) {
            return align_line.substring(index);
        }
        return " ";
    }

    protected FeaturePairI grabAlignment(int seq_length, FeatureSetI match, FeaturePairI prev_span) throws ParseException {
        String query_line = "";
        String align_line = "";
        String sbjct_line = "";
        if (this.donor_index > 0) {
            this.donor_index = 0;
        }
        FeaturePairI curr_span = null;
        try {
            FeaturePairI s;
            int i;
            boolean debug = false;
            query_line = this.data.readLine();
            ++this.line_number;
            align_line = this.data.readLine();
            ++this.line_number;
            sbjct_line = this.data.readLine();
            ++this.line_number;
            int space = this.findPositionIndex(query_line);
            if (debug) {
                System.out.println("Space is at " + space);
            }
            int query_pos = this.parsePosition(query_line, space);
            int sbjct_pos = this.parsePosition(sbjct_line, space);
            query_line = this.trimOffPosition(query_line, ++space);
            sbjct_line = this.trimOffPosition(sbjct_line, space);
            align_line = this.trimOffPosition(align_line, space);
            align_line = align_line.replace(' ', '-');
            curr_span = (FeaturePairI)match.getFeatureContaining(query_pos);
            if (curr_span == null) {
                for (i = 0; i < match.size() && curr_span == null; ++i) {
                    s = (FeaturePairI)match.getFeatureAt(i);
                    if (!s.getHitFeature().contains(sbjct_pos)) continue;
                    curr_span = s;
                }
            }
            if (curr_span == null) {
                System.out.println("Have no span at " + query_pos + " limits are " + match.getStart() + "-" + match.getEnd() + " " + match.getHitSequence().getName() + " " + match.size() + " spans");
                for (i = 0; i < match.size(); ++i) {
                    s = (FeaturePairI)match.getFeatureAt(i);
                    System.out.println("\t" + s.getStart() + "-" + s.getEnd());
                }
                return null;
            }
            if (prev_span != null && curr_span != prev_span) {
                this.rollCigar(prev_span);
            }
            int query_index = curr_span != null ? match.getFeatureIndex(curr_span) : -1;
            int[] exon_indices = this.exonIndex(align_line, debug);
            int start_index = exon_indices[0];
            int end_index = exon_indices[1];
            while (start_index >= 0) {
                String query_align_str = this.getSubAlign(query_line, start_index, end_index);
                String sbjct_align_str = this.getSubAlign(sbjct_line, start_index, end_index);
                if (debug) {
                    System.out.println(match.getName() + " start_index=" + start_index + " end_index=" + end_index + " in line " + align_line + " parsed out " + query_align_str);
                }
                if (sbjct_align_str.length() > query_align_str.length()) {
                    sbjct_align_str = sbjct_align_str.substring(0, query_align_str.length());
                }
                if (sbjct_align_str.length() < query_align_str.length()) {
                    query_align_str = query_align_str.substring(0, sbjct_align_str.length());
                }
                sbjct_align_str = sbjct_align_str.replace(' ', '-');
                query_align_str = query_align_str.replace(' ', '-');
                if (sbjct_align_str.startsWith(".") || query_align_str.startsWith(".")) {
                    while (sbjct_align_str.startsWith(".") || query_align_str.startsWith(".")) {
                        sbjct_align_str = sbjct_align_str.substring(1);
                        query_align_str = query_align_str.substring(1);
                    }
                }
                if (sbjct_align_str.endsWith(".") || query_align_str.endsWith(".")) {
                    while (sbjct_align_str.endsWith(".") || query_align_str.endsWith(".")) {
                        sbjct_align_str = sbjct_align_str.substring(0, sbjct_align_str.length() - 1);
                        query_align_str = query_align_str.substring(0, query_align_str.length() - 1);
                    }
                }
                this.align_seq = this.align_seq + sbjct_align_str;
                this.coord_seq = this.coord_seq + query_align_str;
                if (end_index >= 0) {
                    align_line = align_line.substring(end_index);
                    query_line = end_index < query_line.length() ? query_line.substring(end_index) : "";
                    sbjct_line = end_index < sbjct_line.length() ? sbjct_line.substring(end_index) : "";
                    query_line = this.padForAlign(query_line, align_line.length());
                    sbjct_line = this.padForAlign(sbjct_line, align_line.length());
                    exon_indices = this.exonIndex(align_line, debug);
                    start_index = exon_indices[0];
                    end_index = exon_indices[1];
                    if (start_index < 0) continue;
                    int span_index = match.getFeatureIndex(curr_span);
                    prev_span = curr_span;
                    this.rollCigar(prev_span);
                    if ((curr_span = (FeaturePairI)match.getFeatureAt(++span_index)) != null) continue;
                    System.out.println(match.getHitSequence().getName() + " with " + match.size() + " spans " + " has alignment\n\t" + query_line + "\n\t" + align_line + "\n\t" + sbjct_line + "\n" + " BUT spans are null " + " span_index is " + span_index);
                    for (int i2 = 0; i2 < match.size(); ++i2) {
                        SeqFeatureI s2 = match.getFeatureAt(i2);
                        System.out.println("\t" + i2 + ". " + s2.getStart() + "-" + s2.getEnd());
                    }
                    continue;
                }
                start_index = -1;
            }
        }
        catch (Exception ex) {
            System.out.println("Error parsing alignment of " + match.getHitSequence().getName() + "\n\t" + query_line + "\n\t" + align_line + "\n\t" + sbjct_line);
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return null;
        }
        return curr_span;
    }

    private String getSubAlign(String align_str, int start_index, int end_index) {
        if (start_index >= align_str.length()) {
            return "";
        }
        return end_index < 0 || end_index >= align_str.length() ? align_str.substring(start_index) : align_str.substring(start_index, end_index);
    }

    private int[] exonIndex(String align_line, boolean debug) {
        int find_it;
        int[] exon_indices = new int[]{0, align_line.length() - 1};
        if (this.donor_index < 0 && (align_line.startsWith("<<<") || align_line.startsWith(">>>"))) {
            this.donor_index = 1;
        }
        if (this.donor_index >= 0) {
            find_it = -1;
            String the_end = "";
            for (int i = 0; i < intron_end.length; ++i) {
                int index = align_line.indexOf(intron_end[i], this.donor_index);
                if (index < 0 || find_it >= 0 && index >= find_it) continue;
                find_it = index;
                the_end = intron_end[i];
            }
            if (find_it >= 0) {
                exon_indices[0] = the_end.length() == 2 ? find_it + 1 : ((find_it += the_end.length()) >= align_line.length() ? -1 : find_it);
                this.donor_index = -1;
            } else {
                exon_indices[0] = -1;
            }
        }
        if (this.donor_index < 0 && exon_indices[0] >= 0) {
            find_it = -1;
            for (int i = 0; i < intron_begin.length; ++i) {
                int index = align_line.indexOf(intron_begin[i], exon_indices[0]);
                if (index < 0 || find_it >= 0 && index >= find_it) continue;
                find_it = align_line.indexOf(">", index) >= 0 ? align_line.indexOf(">", index) : align_line.indexOf("<", index);
            }
            if (find_it >= 0) {
                exon_indices[1] = find_it;
                this.donor_index = 1;
            } else {
                exon_indices[1] = -1;
            }
        }
        return exon_indices;
    }

    private String padForAlign(String str, int length) {
        if (str.length() < length) {
            int pad = length - str.length();
            StringBuffer buf = new StringBuffer(pad);
            for (int i = 0; i < pad; ++i) {
                buf = buf.append(' ');
            }
            return str + buf.toString();
        }
        return str;
    }

    private boolean overlapsExisting(FeatureSetI hit, FeaturePairI new_span) {
        boolean overlaps = false;
        for (int i = 0; i < hit.size() && !overlaps; ++i) {
            FeaturePairI check_span = (FeaturePairI)hit.getFeatureAt(i);
            overlaps = check_span.overlaps(new_span);
            if (!overlaps) continue;
            System.out.println(hit.getHitSequence().getName() + " has overlapping spans.\n\told at " + check_span.getStart() + "-" + check_span.getEnd() + "\n\tnew at " + new_span.getStart() + "-" + new_span.getEnd());
            this.extendWith(check_span, new_span);
            this.extendWith(check_span.getHitFeature(), new_span.getHitFeature());
            hit.adjustEdges();
        }
        return overlaps;
    }

    private void flipflop(FeatureSetI match) {
        for (int i = 0; i < match.size(); ++i) {
            FeaturePairI span = (FeaturePairI)match.getFeatureAt(i);
            SeqFeatureI hit_span = span.getHitFeature();
            this.revAlignment(span, hit_span);
        }
    }

    private void revIt(FeatureSetI match) {
        match.flipFlop();
        SequenceI aligned_seq = match.getHitSequence();
        int seq_length = aligned_seq.getLength();
        for (int i = 0; i < match.size(); ++i) {
            FeaturePairI span = (FeaturePairI)match.getFeatureAt(i);
            SeqFeatureI hit_span = span.getHitFeature();
            int pos1 = seq_length - hit_span.getStart() + 1;
            int pos2 = seq_length - hit_span.getEnd() + 1;
            hit_span.setStrand(pos2 <= pos1 ? 1 : -1);
            hit_span.setStart(pos2);
            hit_span.setEnd(pos1);
            this.revAlignment(span, hit_span);
        }
    }

    private void revAlignment(FeaturePairI span, SeqFeatureI hit_span) {
        this.coord_seq = span.getExplicitAlignment();
        this.align_seq = span.getHitFeature().getExplicitAlignment();
        if (this.coord_seq != null && !this.coord_seq.equals("") && this.align_seq != null && !this.align_seq.equals("")) {
            this.coord_seq = DNAUtils.reverseComplement((String)this.coord_seq);
            this.align_seq = DNAUtils.reverseComplement((String)this.align_seq);
            this.rollCigar(span);
        }
    }

    public void extendWith(SeqFeatureI to, SeqFeatureI from) {
        if (to.getStrand() != from.getStrand()) {
            System.err.println("Error: spans do not agree on direction.\n " + to.getStart() + "," + to.getEnd() + " - " + from.getStart() + "," + from.getEnd());
            return;
        }
        if (from.getLow() < to.getLow()) {
            to.setLow(from.getLow());
        }
        if (from.getHigh() > to.getHigh()) {
            to.setHigh(from.getHigh());
        }
    }

    private void thisIsOdd(FeatureSetI match) {
        String value;
        SequenceI aligned_seq = match.getHitSequence();
        String string = !this.complement && this.introns_reverse ? "nocomp_rev" : (value = this.complement && this.introns_forward ? "comp_forward" : "comp_either");
        if (!match.getProperty("ODD").equals("")) {
            match.removeProperty("ODD");
        } else {
            match.addProperty("ODD", value);
        }
    }

    public String debugName(SeqFeatureI sf) {
        String name = null;
        name = sf instanceof FeaturePairI ? ((FeaturePairI)sf).getHitSequence().getName() : (sf instanceof FeatureSetI ? ((FeatureSetI)sf).getHitSequence().getName() : sf.getRefSequence().getName());
        if (name == null) {
            System.out.println("Something seriously wrong with feature " + sf.toString());
        }
        return name;
    }

    private void debugFeature(SeqFeatureI sf, String prefix) {
        String name = this.debugName(sf);
        if (this.input.debugFilter(name)) {
            System.out.println(prefix + "\n\t" + name + " " + " strand=" + sf.getStrand() + " start=" + sf.getStart() + " end =" + sf.getEnd() + "\n\tlength=" + sf.length() + " expect=" + sf.getScore("expect") + " score=" + sf.getScore() + " type=" + sf.getFeatureType());
            if (sf instanceof FeatureSetI) {
                FeatureSetI fs = (FeatureSetI)sf;
                for (int i = 0; i < fs.size(); ++i) {
                    FeaturePairI fp = (FeaturePairI)fs.getFeatureAt(i);
                    System.out.println("\tSpan " + (i + 1) + " genomic range=" + fp.getStart() + "-" + fp.getEnd() + " EST range=" + fp.getHstart() + "-" + fp.getHend());
                }
            }
        }
    }
}

