/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.analysis;

import apollo.analysis.filter.AnalysisInput;
import apollo.dataadapter.analysis.GeneFinderParser;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import java.io.InputStream;
import java.text.ParseException;
import java.util.StringTokenizer;

public class GenscanParser
extends GeneFinderParser {
    private double donor_score;
    private double acceptor_score;
    private double coding_potential;
    private double probability;
    private static String date_key = "Date run: ";
    private static String matrix_key = "Parameter matrix: ";
    private static String seq_key = "Sequence ";
    private static String gene_key = "Gn.Ex";
    private static String program_key = "GENSCAN";
    private static String pep_key = "Predicted peptide ";
    private static String sub_key = "Suboptimal exons";
    private static String[] comments = new String[]{program_key, date_key, matrix_key, seq_key, pep_key, sub_key, "----- ", "Predicted genes", gene_key};

    public String load(CurationSet curation, boolean new_curation, InputStream data_stream, AnalysisInput input) {
        this.initLoad(curation, new_curation, data_stream, input);
        if (this.parsed) {
            try {
                if (this.version != null) {
                    this.forward_analysis.addProperty("version", this.version);
                    this.reverse_analysis.addProperty("version", this.version);
                }
                this.parsed = this.grabGenes(curation, this.forward_analysis, this.reverse_analysis);
                this.data.close();
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
                this.parsed = false;
            }
        }
        return this.parsed ? this.getAnalysisType() : null;
    }

    protected boolean isCommentary() {
        boolean a_comment = this.line.equals("");
        for (int i = 0; i < comments.length && !a_comment; ++i) {
            boolean bl = a_comment = this.line.indexOf(comments[i]) >= 0;
            if (!a_comment) continue;
            this.comment = this.line;
        }
        return a_comment;
    }

    public boolean recognizedInput() {
        for (int i = 0; !this.parsed && i < 10; ++i) {
            this.parseLine();
            this.parsed &= this.comment.startsWith(program_key);
        }
        if (!this.parsed) {
            this.program = null;
        } else {
            this.program = program_key;
            this.version = this.parseVersion();
        }
        return this.parsed;
    }

    protected String parseVersion() {
        String version = this.comment.substring(program_key.length());
        int index = version.indexOf(9);
        if (index >= 0) {
            version = version.substring(0, index);
        }
        return version;
    }

    protected boolean parseLine() {
        block11: {
            this.comment = "";
            this.seq_name = "";
            this.source = "";
            this.type = "";
            this.low = 0;
            this.high = 0;
            this.score = 0.0;
            this.strand = 0;
            this.phase = "";
            this.gene_id = "";
            try {
                this.readLine();
                boolean bl = this.parsed = this.line != null;
                if (this.parsed) {
                    this.line = this.line.trim();
                    if (!this.isCommentary()) {
                        String temp;
                        String strand_str;
                        StringTokenizer tokens = new StringTokenizer(this.line);
                        this.gene_id = this.parseToken(tokens, "gene_id");
                        if (this.gene_id.indexOf(".") > 0) {
                            this.gene_id = this.gene_id.substring(0, this.gene_id.indexOf("."));
                        }
                        this.type = this.parseToken(tokens, "type");
                        if (this.parsed && (this.type.equals("Init") || this.type.equals("Intr") || this.type.equals("Term") || this.type.equals("Sngl"))) {
                            this.type = "Exon";
                        }
                        this.parsed &= (strand_str = this.parseToken(tokens, "strand")).equals("+") || strand_str.equals("-") || strand_str.equals(".");
                        if (this.parsed) {
                            int n = this.strand = strand_str.equals("+") || strand_str.equals(".") ? 1 : -1;
                        }
                        if (this.parsed) {
                            this.low = this.parseInteger(tokens, "low");
                        }
                        if (this.parsed) {
                            this.high = this.parseInteger(tokens, "high");
                        }
                        String string = temp = tokens.hasMoreTokens() ? tokens.nextToken() : "";
                        if (!this.type.equals("PlyA") && !this.type.equals("Prom")) {
                            temp = tokens.hasMoreTokens() ? tokens.nextToken() : "";
                            this.phase = this.parseToken(tokens, "phase");
                            this.parsed &= this.phase.equals("0") || this.phase.equals("1") || this.phase.equals("2") || this.phase.equals(".");
                            this.acceptor_score = this.parseDouble(tokens, "acceptor_score");
                            this.donor_score = this.parseDouble(tokens, "donor_score");
                            this.coding_potential = this.parseDouble(tokens, "coding_potential");
                            this.probability = this.parseDouble(tokens, "probability") * 100.0;
                        }
                        temp = tokens.hasMoreTokens() ? tokens.nextToken() : "";
                        this.parsed &= !temp.equals("");
                        this.score = this.parseScore(temp);
                    } else {
                        this.comment = this.line;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Error parsing line " + this.line);
                e.printStackTrace();
                this.parsed = false;
                if (this.parsed) break block11;
                System.out.println("Set parsed to false because of line" + this.line);
            }
        }
        return this.parsed;
    }

    protected double parseDouble(StringTokenizer tokens, String msg) {
        try {
            return this.parseScore(this.parseToken(tokens, msg));
        }
        catch (Exception ex) {
            this.parsed = false;
            return -1.0;
        }
    }

    protected double parseScore(String value) throws ParseException {
        double score = 0.0;
        if (value.toLowerCase().equals("nan")) {
            value = "0.0001";
        }
        if (value.equals(".")) {
            value = "0";
        }
        if (this.parsed) {
            try {
                score = Double.valueOf(value);
            }
            catch (Exception ex) {
                throw new ParseException("Error when parsing double from " + value, this.line_number);
            }
        }
        return score;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean grabGenes(CurationSet curation, FeatureSetI forward_analysis, FeatureSetI reverse_analysis) {
        transcript = null;
        try {
            have_genes = false;
            while (this.parsed && !have_genes) {
                if (this.comment.indexOf(GenscanParser.date_key) >= 0) {
                    this.grabDate(forward_analysis, reverse_analysis);
                } else if (this.comment.indexOf(GenscanParser.matrix_key) >= 0) {
                    this.grabMatrix(forward_analysis, reverse_analysis);
                } else if (this.comment.indexOf(GenscanParser.seq_key) >= 0) {
                    focal_seq = this.grabDNA();
                    this.initCuration(curation, focal_seq);
                } else {
                    have_genes = this.comment.startsWith(GenscanParser.gene_key);
                }
                this.parseLine();
            }
            while (this.parsed && have_genes) {
                if (!this.gene_id.equals("")) {
                    if (curation.getRefSequence() == null) {
                        focal_seq = this.initSequence(curation, this.seq_name, 50000000);
                        this.initCuration(curation, focal_seq);
                    }
                    if (transcript != null && !transcript.getId().equals(this.gene_id)) {
                        this.addGene((FeatureSetI)transcript, forward_analysis, reverse_analysis);
                        transcript = null;
                    }
                    if (transcript == null) {
                        transcript = this.initSet(this.gene_id, this.strand);
                        transcript.setName("genscan" + this.gene_id);
                    }
                    exon = this.initFeature();
                    exon.setScore(this.score);
                    exon.setTopLevelType(this.type);
                    transcript.setScore(transcript.getScore() + exon.getScore());
                    exon.setStrand(this.strand);
                    try {
                        exon.setStart(this.low);
                        exon.setEnd(this.high);
                        transcript.addFeature(exon, true);
                        if (this.acceptor_score > 0.0) {
                            exon.addScore("acceptor_score", this.acceptor_score);
                        }
                        if (this.donor_score > 0.0) {
                            exon.addScore("donor_score", this.donor_score);
                        }
                        if (this.coding_potential > 0.0) {
                            exon.addScore("coding_potential", this.coding_potential);
                        }
                        if (!(this.probability > 0.0)) ** GOTO lbl60
                        exon.addScore("probability", this.probability);
                    }
                    catch (NumberFormatException ex) {
                        throw new ParseException("Error parsing low/high as number " + this.low + "/" + this.high, this.line_number);
                    }
                    catch (Exception ex) {
                        System.out.println(ex.getMessage() + "can't parse");
                        System.out.println("Set parsed to false because of low/high");
                        this.parsed = false;
                    }
                } else if (this.comment.startsWith(GenscanParser.pep_key) || this.comment.startsWith(GenscanParser.sub_key)) {
                    have_genes = false;
                } else if (!this.comment.equals("")) {
                    this.parsed = false;
                }
lbl60:
                // 7 sources

                this.parseLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            this.parsed = false;
        }
        if (transcript != null) {
            this.addGene((FeatureSetI)transcript, forward_analysis, reverse_analysis);
        }
        return this.parsed;
    }

    protected void grabSequence(FeatureSetI forward_analysis, FeatureSetI reverse_analysis) {
        String value = this.comment.substring(matrix_key.length()).trim();
        forward_analysis.addProperty("matrix", value);
        reverse_analysis.addProperty("matrix", value);
    }

    protected void grabMatrix(FeatureSetI forward_analysis, FeatureSetI reverse_analysis) {
        String value = this.comment.substring(matrix_key.length()).trim();
        forward_analysis.addProperty("matrix", value);
        reverse_analysis.addProperty("matrix", value);
    }

    protected void grabDate(FeatureSetI forward_analysis, FeatureSetI reverse_analysis) {
        Object date = null;
        String value = null;
        int index = this.comment.indexOf(date_key);
        if (index >= 0) {
            value = this.comment.substring(index + date_key.length());
            if ((index = value.indexOf("\t")) >= 0) {
                value = value.substring(0, index);
            }
            index = value.lastIndexOf(45);
            if (value.length() - (index + 1) > 2) {
                value = value.substring(0, index + 1) + value.substring(value.length() - 2);
            }
            forward_analysis.addProperty("date", value);
            reverse_analysis.addProperty("date", value);
        }
    }

    protected SequenceI grabDNA() throws ParseException {
        Sequence seq = null;
        try {
            String value = this.comment.substring(seq_key.length()).trim();
            int index = value.indexOf(" : ");
            this.seq_name = index >= 0 ? value.substring(0, index) : value;
            seq = new Sequence(this.seq_name, "");
            value = value.substring(index + " : ".length());
            index = value.indexOf(" bp : ");
            String seq_length = index >= 0 ? value.substring(0, index) : value;
            seq.setLength(Integer.parseInt(seq_length));
            value = value.substring(index + " bp : ".length());
            System.out.println(this.seq_name + " is " + seq_length + "bp");
            seq.setDescription(value);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            this.parsed = false;
            throw new ParseException("Error when parsing line " + this.comment, this.line_number);
        }
        return seq;
    }
}

