/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.analysis;

import apollo.dataadapter.analysis.AbstractParser;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeatureSetI;

public abstract class GeneFinderParser
extends AbstractParser {
    String comment;
    String seq_name;
    String source;
    String type;
    int low;
    int high;
    double score;
    int strand;
    String phase;
    String gene_id;
    String trans_id;

    protected abstract boolean grabGenes(CurationSet var1, FeatureSetI var2, FeatureSetI var3);

    protected abstract boolean isCommentary();

    protected void addGene(FeatureSetI gene, FeatureSetI forward_analysis, FeatureSetI reverse_analysis) {
        gene.setScore(gene.getScore() / (double)gene.size());
        if (gene.getStrand() == 1) {
            forward_analysis.addFeature(gene);
        } else {
            reverse_analysis.addFeature(gene);
        }
    }

    protected String parseProgram() {
        String version = null;
        if (this.comment.startsWith("##gff")) {
            this.program = this.comment.substring(2, "##gff".length());
            version = this.comment.substring("##gff-".length());
        } else {
            this.program = this.source.equals("src") ? "fgenesh" : this.source;
        }
        return version;
    }

    public String getProgram() {
        return this.program;
    }
}

