/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.analysis;

import apollo.analysis.filter.AnalysisInput;
import apollo.dataadapter.analysis.AnalysisParserI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.util.FastaHeader;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.StringTokenizer;

public abstract class AbstractParser
implements AnalysisParserI {
    String program = "";
    String version = "";
    String database = "";
    CurationSet curation;
    boolean new_curation;
    AnalysisInput input;
    int line_number = 0;
    BufferedReader data;
    String line = null;
    boolean parsed;
    FeatureSetI forward_analysis;
    FeatureSetI reverse_analysis;

    public String load(CurationSet curation, boolean new_curation, InputStream data_stream, AnalysisInput input) {
        System.err.println(this.getClass().getName() + ".load is Abstract and should never be used");
        return null;
    }

    public abstract boolean recognizedInput();

    public abstract String getProgram();

    protected void setHitScore(FeatureSetI hit, SeqFeatureI span) {
        if (hit.size() == 1 || span.getScore() > hit.getScore()) {
            hit.setScore(span.getScore());
        }
    }

    protected SequenceI initSequence(CurationSet curation, String header, int length) {
        FastaHeader fasta = new FastaHeader(header);
        String seq_id = fasta.getSeqId();
        SequenceI seq = curation.getSequence(seq_id);
        if (seq == null) {
            if (seq_id.indexOf(59) >= 0) {
                seq_id = seq_id.replace(';', ' ');
                seq_id = seq_id.trim();
                seq = curation.getSequence(seq_id);
            }
            if (seq == null) {
                seq = fasta.generateSequence();
                curation.addSequence(seq);
            }
        }
        seq.setLength(length);
        return seq;
    }

    protected FeatureSetI initSet(String id, int strand) {
        FeatureSet hit = new FeatureSet();
        hit.setStrand(strand);
        hit.setRefSequence(this.curation.getRefSequence());
        hit.setProgramName(this.program);
        hit.setDatabase(this.database);
        hit.setFeatureType(this.getAnalysisType());
        hit.setId(id);
        return hit;
    }

    protected String getAnalysisType() {
        if (this.database.equals("")) {
            return this.program;
        }
        return this.program + ":" + this.database;
    }

    protected FeatureSetI initAnalysis(StrandedFeatureSetI analyses, int strand, String type) {
        String analysis_type = this.getAnalysisType();
        String analysis_name = analysis_type + (strand == 1 ? "-plus" : (strand == -1 ? "-minus" : ""));
        FeatureSetI analysis = null;
        FeatureSetI check_analyses = strand == 1 ? analyses.getForwardSet() : analyses.getReverseSet();
        for (int i = 0; i < check_analyses.size() && analysis == null; ++i) {
            FeatureSetI sf = (FeatureSetI)analyses.getFeatureAt(i);
            String sf_type = sf.getFeatureType();
            analysis = sf_type.equals(analysis_type) ? sf : null;
        }
        if (analysis == null) {
            analysis = new FeatureSet();
            analysis.setStrand(strand);
            analysis.setFeatureType(analysis_type);
            analyses.addFeature(analysis);
        } else {
            System.out.println("Found existing analysis of type " + analysis_type);
        }
        analysis.setProgramName(this.program);
        analysis.setDatabase(this.database);
        analysis.setName(analysis_name);
        if (type != null) {
            analysis.setTopLevelType(type);
        }
        if (this.version != null) {
            analysis.addProperty("version", this.version);
        }
        return analysis;
    }

    protected SeqFeatureI initFeature() {
        SeqFeature sf = new SeqFeature();
        sf.setFeatureType(this.getAnalysisType());
        sf.setRefSequence(this.curation.getRefSequence());
        return sf;
    }

    protected void initCuration(CurationSet curation, SequenceI focal_seq) {
        boolean update = false;
        if (focal_seq != null && curation.getRefSequence() == null) {
            curation.setRefSequence(focal_seq);
            update = true;
        }
        if (focal_seq == null || focal_seq != null && focal_seq != curation.getRefSequence()) {
            focal_seq = curation.getRefSequence();
            update = true;
        }
        if (update && focal_seq != null) {
            curation.setName(focal_seq.getName());
            curation.setStrand(1);
            curation.setStart(1);
            curation.setEnd(focal_seq.getLength());
            System.out.println("initCuration: sequence range for " + focal_seq.getName() + " is " + curation.getStart() + " to " + curation.getEnd());
        }
    }

    protected void initLoad(CurationSet curation, boolean new_curation, InputStream data_stream, AnalysisInput input) {
        this.input = input;
        this.curation = curation;
        this.new_curation = new_curation;
        this.database = input.getDatabase();
        this.data = null;
        this.parsed = false;
        this.program = null;
        try {
            this.data = new BufferedReader(new InputStreamReader(data_stream));
        }
        catch (Exception e) {
            System.err.println("Unable to open data stream");
        }
        if (this.data != null) {
            this.parsed = this.recognizedInput();
        }
        if (this.parsed) {
            this.program = this.getProgram();
            if (new_curation) {
                this.initCuration(curation, null);
            }
            System.out.println("Preparing to parse " + this.program + " results...");
            StrandedFeatureSetI all_analyses = curation.getResults();
            if (all_analyses == null) {
                all_analyses = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
                all_analyses.setName("Analyses");
                curation.setResults(all_analyses);
            }
            String type = input.getType();
            this.forward_analysis = this.initAnalysis(all_analyses, 1, type);
            this.reverse_analysis = this.initAnalysis(all_analyses, -1, type);
            this.forward_analysis.setAnalogousOppositeStrandFeature(this.reverse_analysis);
            this.reverse_analysis.setAnalogousOppositeStrandFeature(this.forward_analysis);
        } else {
            this.program = null;
        }
    }

    protected void readLine() throws ParseException {
        try {
            this.line = this.data.readLine();
            ++this.line_number;
        }
        catch (Exception ex) {
            this.line = null;
            this.parsed = false;
            throw new ParseException(ex.getMessage(), this.line_number);
        }
    }

    protected String parseToken(StringTokenizer tokens, String msg) {
        String value = "";
        if (this.parsed) {
            value = tokens.hasMoreTokens() ? tokens.nextToken() : "";
            this.parsed &= !value.equals("");
        }
        return value;
    }

    protected int parseInteger(StringTokenizer tokens, String msg) {
        String value = this.parseToken(tokens, msg);
        int number = 0;
        if (this.parsed) {
            try {
                number = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                this.parsed = false;
            }
        }
        return number;
    }

    protected double parseDouble(StringTokenizer tokens, String msg) {
        String value = this.parseToken(tokens, msg);
        double number = 0.0;
        if (this.parsed) {
            try {
                if (value.equals(".")) {
                    value = "0";
                }
                number = Double.valueOf(value);
            }
            catch (NumberFormatException ex) {
                this.parsed = false;
            }
        }
        return number;
    }
}

