/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.config.Config;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.SerialAdapterGUI;
import apollo.datamodel.CompositeDataHolder;
import apollo.datamodel.CurationSet;
import apollo.util.IOUtil;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UTFDataFormatException;
import java.util.Properties;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.bdgp.io.ProgressableFileInputStream;
import org.bdgp.util.ProgressEvent;
import org.bdgp.util.ProgressListener;

public class SerialDiskAdapter
extends AbstractApolloAdapter {
    String filename;
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA, ApolloDataAdapterI.OP_WRITE_DATA, ApolloDataAdapterI.OP_READ_SEQUENCE};

    public SerialDiskAdapter() {
        this.setName("Apollo backup file");
    }

    public void init() {
    }

    public String getType() {
        return "Choose backup file";
    }

    public DataInputType getInputType() {
        return DataInputType.FILE;
    }

    public String getInput() {
        return this.filename;
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public DataAdapterUI getUI(IOOperation op) {
        if (op.equals((Object)ApolloDataAdapterI.OP_READ_DATA) || op.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
            return new SerialAdapterGUI(op);
        }
        return null;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    protected String getFilename() {
        if (this.filename == null) {
            this.filename = super.getFilename();
        }
        return this.filename;
    }

    public SerialDiskAdapter(String filename) {
        this.filename = filename;
    }

    public Properties getStateInformation() {
        Properties props = new Properties();
        props.put("filename", this.filename);
        return props;
    }

    public void setStateInformation(Properties props) {
        this.filename = props.getProperty("filename");
    }

    public void commitChanges(CurationSet curationSet) throws ApolloAdapterException {
        this.commitChanges(curationSet, this.filename);
    }

    private void commitChanges(CurationSet curationSet, String filename) throws ApolloAdapterException {
        try {
            FileOutputStream istream = new FileOutputStream(IOUtil.findFile(this.getFilename(), true));
            ObjectOutputStream p = new ObjectOutputStream(istream);
            p.writeObject(curationSet);
        }
        catch (UTFDataFormatException e) {
            System.err.println("broken string = " + e.getMessage());
            throw new ApolloAdapterException(e);
        }
        catch (Exception e) {
            throw new ApolloAdapterException(e);
        }
    }

    public void commitChanges(CompositeDataHolder cdh) throws ApolloAdapterException {
        if (!cdh.isMultiSpecies()) {
            this.commitChanges(cdh.getCurationSet(0));
        } else {
            for (int i = 0; i < cdh.getNumberOfSpecies(); ++i) {
                this.commitChanges(cdh.getCurationSet(i), this.filename + cdh.getSpecies(i));
            }
        }
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        try {
            ProgressableFileInputStream istream = new ProgressableFileInputStream(IOUtil.findFile(this.getFilename(), false));
            super.clearOldData();
            ProgressListener pl = new ProgressListener(){

                public void progressMade(ProgressEvent e) {
                    SerialDiskAdapter.this.fireProgressEvent(e);
                }
            };
            istream.addProgressListener(pl);
            ObjectInputStream p = new ObjectInputStream((InputStream)istream);
            CurationSet cs = (CurationSet)p.readObject();
            return cs;
        }
        catch (Exception e) {
            if (Config.DEBUG) {
                String m = e.getMessage();
                System.out.println("DEBUG deserialization exception msg & stack trace:" + m);
                e.printStackTrace();
            }
            throw new ApolloAdapterException(e);
        }
    }

    public void setRegion(String extId) throws ApolloAdapterException {
    }
}

