/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.config.Style;
import apollo.dataadapter.DataInput;
import apollo.dataadapter.DataInputType;
import apollo.util.GuiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public abstract class GuiTabPanel
extends JPanel {
    private String label;
    private DataInputType inputType;
    protected JComboBox comboBox;
    private Vector history;
    private JPanel innerPanel;
    private String example;
    private JComboBox dbComboBox;
    static final short DEFAULT_MAX_HISTORY_LENGTH = 10;
    private String colorScheme = "gray";
    protected ApolloGridBagConstraints constraints;

    public GuiTabPanel(String nm, String label, Color bkgnd) {
        this(nm, label, null, bkgnd);
    }

    public GuiTabPanel(String nm, String label, DataInputType type, Color bkgnd) {
        this(nm, label, type, null, bkgnd);
    }

    public GuiTabPanel(String nm, String label, DataInputType type, String example, Color bkgnd) {
        this.setName(nm);
        this.label = label;
        this.inputType = type;
        this.example = example;
        this.history = new Vector(this.getMaxHistoryLength());
        this.setLayout(new BoxLayout(this, 1));
        if (!this.colorScheme.equalsIgnoreCase("gray")) {
            this.setBackground(bkgnd);
        }
        this.buildGUI();
    }

    void addActionListener(ActionListener l) {
        if (this.comboBox != null) {
            this.comboBox.addActionListener(l);
        }
    }

    boolean isReadyForCommit() {
        if (this.comboBox == null) {
            return false;
        }
        if (this.comboBox.getEditor().getItem() == null) {
            return false;
        }
        String editItem = (String)this.comboBox.getEditor().getItem();
        return !editItem.equals("");
    }

    protected short getMaxHistoryLength() {
        return 10;
    }

    public DataInput getDataInput() {
        return new DataInput(this.getInputType(), this.getCurrentInput());
    }

    public String getCurrentInput() {
        return (String)this.comboBox.getEditor().getItem();
    }

    public void setCurrentInput(String input) {
        this.comboBox.getEditor().setItem(input);
    }

    public DataInputType getInputType() {
        return this.inputType;
    }

    private String getToolTip() {
        return this.label;
    }

    protected JPanel getPanel() {
        return this;
    }

    protected void buildGUI() {
        this.innerPanel = new JPanel(new GridBagLayout());
        if (!this.colorScheme.equalsIgnoreCase("gray")) {
            this.innerPanel.setBackground(this.getBackground());
        }
        if (this.showDatabaseList()) {
            this.innerPanel.add((Component)this.getDatabasePanel(), this.getConstraints().nextColumn());
        }
        JLabel jLabel = GuiUtil.makeJLabelWithFont(this.label, this.example);
        this.innerPanel.add((Component)jLabel, this.getConstraints().nextRow());
        JComponent editComponent = this.getEditingComponent();
        this.innerPanel.add((Component)editComponent, this.getConstraints().nextColumn());
        this.add(this.innerPanel);
    }

    protected JPanel getDatabasePanel() {
        JPanel dbPanel = new JPanel(new GridBagLayout());
        if (!this.colorScheme.equalsIgnoreCase("gray")) {
            dbPanel.setBackground(this.getBackground());
        }
        JLabel dbLabel = GuiUtil.makeJLabelWithFont("Database ");
        ApolloGridBagConstraints dbCon = this.newConstraints();
        dbPanel.add((Component)dbLabel, dbCon);
        this.dbComboBox = new JComboBox(this.getDatabaseList());
        dbPanel.add((Component)this.dbComboBox, this.nextColumn(dbCon));
        return dbPanel;
    }

    protected ApolloGridBagConstraints getConstraints() {
        if (this.constraints == null) {
            this.constraints = this.newConstraints();
        }
        return this.constraints;
    }

    protected ApolloGridBagConstraints newConstraints() {
        return new ApolloGridBagConstraints();
    }

    public GridBagConstraints nextColumn(GridBagConstraints gbc) {
        ++gbc.gridx;
        return gbc;
    }

    protected GridBagConstraints nextRow(GridBagConstraints gbc) {
        ++gbc.gridy;
        gbc.gridx = 0;
        return gbc;
    }

    protected abstract Style getAdapterStyle();

    protected JPanel getInnerPanel() {
        return this.innerPanel;
    }

    protected JComponent getEditingComponent() {
        if (this.comboBox == null) {
            this.comboBox = new JComboBox();
            this.comboBox.setPreferredSize(new Dimension(500, 25));
            this.comboBox.setEditable(true);
        }
        return this.comboBox;
    }

    private String historySizeStr() {
        return this.getName() + "Size";
    }

    private String historyItemStr(int i) {
        return this.getName() + "Item" + i;
    }

    public void putHistoryInProperties(Properties prop) {
        int s = this.history.size() > this.getMaxHistoryLength() ? this.getMaxHistoryLength() : this.history.size();
        prop.put(this.historySizeStr(), s + "");
        for (int i = 0; i < this.history.size(); ++i) {
            prop.put(this.historyItemStr(i), (String)this.history.elementAt(i));
        }
    }

    public void addSelectedToHistory() {
        this.history.removeElement(this.getCurrentInput());
        this.history.insertElementAt(this.getCurrentInput(), 0);
    }

    public void retrieveHistoryFromProperties(Properties props) {
        this.history.clear();
        String sizeString = props.getProperty(this.historySizeStr());
        if (sizeString == null) {
            return;
        }
        int sizeInt = Integer.parseInt(sizeString);
        for (int i = 0; i < sizeInt; ++i) {
            this.history.addElement(props.getProperty(this.historyItemStr(i)));
        }
        this.setEditorsHistory(this.history);
    }

    protected void setEditorsHistory(Vector history) {
        this.comboBox.setModel(new DefaultComboBoxModel(history));
    }

    public void insertIntoTabbedPane(JTabbedPane pane, int index) {
        pane.insertTab(this.getName(), null, this.getPanel(), this.getToolTip(), index);
        if (!this.colorScheme.equalsIgnoreCase("gray")) {
            pane.setBackgroundAt(index, this.getBackground());
        }
    }

    protected boolean showDatabaseList() {
        return this.numberOfDatabases() > 1;
    }

    private int numberOfDatabases() {
        return this.getDatabaseList().size();
    }

    protected Vector getDatabaseList() {
        Style style = this.getAdapterStyle();
        Vector dblist = null;
        if (style != null) {
            dblist = style.getDatabaseList();
        }
        if (dblist == null) {
            dblist = new Vector();
        }
        return dblist;
    }

    public String getDatabase() {
        if (this.numberOfDatabases() == 1) {
            return (String)this.getDatabaseList().get(0);
        }
        if (this.dbComboBox == null) {
            return null;
        }
        return (String)this.dbComboBox.getSelectedItem();
    }

    protected class ApolloGridBagConstraints
    extends GridBagConstraints {
        ApolloGridBagConstraints() {
            this.gridx = 0;
            this.gridy = 0;
        }

        public ApolloGridBagConstraints nextColumn() {
            ++this.gridx;
            return this;
        }

        public ApolloGridBagConstraints nextRow() {
            this.gridx = 0;
            ++this.gridy;
            return this;
        }
    }
}

