/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.config.FeatureProperty;
import apollo.config.PropertyScheme;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.util.QuickSort;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FeatureSetBuilder {
    public void makeSetFeatures(StrandedFeatureSet fset, Vector features, PropertyScheme pscheme) {
        Hashtable plus_fhash = new Hashtable(12);
        Hashtable minus_fhash = new Hashtable(12);
        this.buildFeaturesHash(features, plus_fhash, minus_fhash);
        this.buildFeatures(fset, plus_fhash, 1, pscheme);
        this.buildFeatures(fset, minus_fhash, -1, pscheme);
        plus_fhash = null;
        minus_fhash = null;
        System.gc();
    }

    protected void buildFeatures(StrandedFeatureSet fset, Hashtable fhash, int strand, PropertyScheme pscheme) {
        Enumeration e = fhash.keys();
        while (e.hasMoreElements()) {
            FeatureProperty fp;
            String type = (String)e.nextElement();
            Hashtable id_hash = (Hashtable)fhash.get(type);
            FeatureProperty featureProperty = fp = pscheme != null ? pscheme.getFeatureProperty(type) : null;
            if (fp != null && fp.getGroupFlag() == FeatureProperty.GRP_GENE) {
                this.makeGeneSets(fset, id_hash, type, strand);
                continue;
            }
            if (fp != null && fp.getGroupFlag() == FeatureProperty.GRP_HOMOLOGY) {
                this.makeHomolSets(fset, id_hash, type, strand);
                continue;
            }
            this.makeSingSets(fset, id_hash, type, strand);
        }
    }

    protected void buildFeaturesHash(Vector features, Hashtable plus_fhash, Hashtable minus_fhash) {
        int setSize = features.size();
        for (int i = 0; i < setSize; ++i) {
            Vector<SeqFeatureI> sf_vect;
            Hashtable fhash;
            Hashtable<String, Vector<SeqFeatureI>> id_hash;
            String ref_id;
            SeqFeatureI sf = (SeqFeatureI)features.elementAt(i);
            String type = sf.getFeatureType() == null ? "no_type" : sf.getFeatureType();
            String string = ref_id = sf.getId() == null ? "NoRefId" : sf.getId();
            if (ref_id.equals("NoRefId")) {
                System.out.println("Set ref id to " + ref_id + ". " + "For child feature  " + sf.getName() + ":" + sf.getFeatureType());
            }
            if ((id_hash = (Hashtable<String, Vector<SeqFeatureI>>)(fhash = sf.getStrand() == -1 ? minus_fhash : plus_fhash).get(type)) == null) {
                id_hash = new Hashtable<String, Vector<SeqFeatureI>>(1);
                fhash.put(type, id_hash);
            }
            if ((sf_vect = (Vector<SeqFeatureI>)id_hash.get(ref_id)) == null) {
                sf_vect = new Vector<SeqFeatureI>(1);
                id_hash.put(ref_id, sf_vect);
            }
            sf_vect.addElement(sf);
        }
    }

    public void makeGeneSets(StrandedFeatureSet fset, Hashtable id_hash, String type, int strand) {
        FeatureSet fs = new FeatureSet();
        fs.setFeatureType(type);
        fs.setStrand(strand);
        Enumeration e = id_hash.keys();
        while (e.hasMoreElements()) {
            String ref_id = (String)e.nextElement();
            Vector sf_vect = (Vector)id_hash.get(ref_id);
            FeatureSet t = new FeatureSet();
            t.setFeatureType(type);
            t.setId(ref_id);
            t.setStrand(strand);
            int sfVectSize = sf_vect.size();
            for (int i = 0; i < sfVectSize; ++i) {
                SeqFeatureI sf = (SeqFeatureI)sf_vect.elementAt(i);
                t.addFeature(sf);
            }
            fs.addFeature(t);
        }
        fset.addFeature(fs);
    }

    public void makeSingSets(StrandedFeatureSet fset, Hashtable id_hash, String type, int strand) {
        FeatureSet fs = new FeatureSet();
        fs.setFeatureType(type);
        fs.setStrand(strand);
        Enumeration e = id_hash.keys();
        while (e.hasMoreElements()) {
            String ref_id = (String)e.nextElement();
            Vector sf_vect = (Vector)id_hash.get(ref_id);
            int sfVectSize = sf_vect.size();
            for (int i = 0; i < sfVectSize; ++i) {
                FeatureSet s = new FeatureSet();
                s.setFeatureType(type);
                s.setId(ref_id);
                s.setStrand(strand);
                SeqFeatureI sf = (SeqFeatureI)sf_vect.elementAt(i);
                s.addFeature(sf);
                fs.addFeature(s);
            }
        }
        fset.addFeature(fs, false);
    }

    public void makeHomolSets(StrandedFeatureSet fset, Hashtable id_hash, String type, int strand) {
        FeatureSet fs = new FeatureSet();
        fs.setFeatureType(type);
        fs.setStrand(strand);
        Enumeration e = id_hash.keys();
        while (e.hasMoreElements()) {
            String ref_id = (String)e.nextElement();
            Vector sf_vect = (Vector)id_hash.get(ref_id);
            Vector r_vect = this.splitHomols(sf_vect, type, ref_id, strand);
            int rVectSize = r_vect.size();
            for (int i = 0; i < rVectSize; ++i) {
                FeatureSet r = (FeatureSet)r_vect.elementAt(i);
                r.setFeatureType(type);
                r.setId(ref_id);
                r.setStrand(strand);
                fs.addFeature(r);
            }
        }
        fset.addFeature(fs, false);
    }

    public Vector splitHomols(Vector sf_vect, String type, String ref_id, int strand) {
        int sfVectSize = sf_vect.size();
        long[] starts = new long[sfVectSize];
        Object[] f = new SeqFeatureI[sfVectSize];
        for (int i = 0; i < sfVectSize; ++i) {
            starts[i] = ((SeqFeatureI)sf_vect.elementAt(i)).getStart();
            f[i] = (SeqFeatureI)sf_vect.elementAt(i);
        }
        QuickSort.sort(starts, f);
        Vector<Object> fset = new Vector<Object>(sfVectSize);
        for (int i = 0; i < sfVectSize; ++i) {
            fset.addElement(f[i]);
        }
        Vector<FeatureSet> newsets = new Vector<FeatureSet>(1);
        Vector<FeatureSetI> potentialSets = new Vector<FeatureSetI>(1);
        int gap = 20;
        int maxGenGap = 1000000;
        int fsetSize = fset.size();
        for (int i = 0; i < fsetSize; ++i) {
            if (!(fset.elementAt(i) instanceof FeaturePair)) continue;
            FeaturePair sf = (FeaturePair)fset.elementAt(i);
            potentialSets.removeAllElements();
            int newSetsSize = newsets.size();
            for (int k = newSetsSize - 1; k >= 0; --k) {
                long Ggap;
                long Hgap;
                FeatureSetI tmp1 = (FeatureSetI)newsets.elementAt(k);
                FeaturePair tmp2 = (FeaturePair)tmp1.getFeatures().lastElement();
                if (tmp2.getStrand() != sf.getStrand()) continue;
                if (tmp2.getStrand() == 1) {
                    Hgap = Math.abs(tmp2.getHend() - sf.getHstart());
                    Ggap = Math.abs(tmp2.getEnd() - sf.getStart());
                    if (Hgap > (long)gap || Ggap > (long)maxGenGap || sf.getHstart() <= tmp2.getHend()) continue;
                    potentialSets.addElement(tmp1);
                    continue;
                }
                Hgap = Math.abs(tmp2.getHstart() - sf.getHend());
                Ggap = Math.abs(tmp2.getStart() - sf.getEnd());
                if (Hgap > (long)gap || Ggap > (long)maxGenGap || tmp2.getHstart() <= sf.getHend()) continue;
                potentialSets.addElement(tmp1);
            }
            FeatureSetI theSet = null;
            int potentialSetsSize = potentialSets.size();
            if (potentialSetsSize != 0) {
                theSet = (FeatureSetI)potentialSets.elementAt(0);
                double sfScore = sf.getScore();
                double smallestDiff = Math.abs(sfScore - theSet.getScore());
                for (int k = 0; k < potentialSetsSize; ++k) {
                    FeatureSetI testSet = (FeatureSetI)potentialSets.elementAt(k);
                    if (testSet.getScore() == sf.getScore()) {
                        theSet = testSet;
                        break;
                    }
                    double testDiff = Math.abs(sfScore - testSet.getScore());
                    if (!(testDiff < smallestDiff)) continue;
                    theSet = testSet;
                    smallestDiff = testDiff;
                }
            }
            if (theSet == null) {
                FeatureSet newfs = new FeatureSet();
                newfs.setFeatureType(type);
                newsets.addElement(newfs);
                theSet = newfs;
            }
            theSet.addFeature(sf);
        }
        return newsets;
    }

    public static void main(String[] args) {
        SeqFeature sf1 = new SeqFeature(100, 200, "genscan", 1);
        SeqFeature sf2 = new SeqFeature(300, 400, "genscan", 1);
        SeqFeature sf3 = new SeqFeature(500, 600, "genscan", 1);
        SeqFeature sf4 = new SeqFeature(700, 800, "genscan", 1);
        sf1.setName("gene1");
        sf2.setName("gene1");
        sf3.setName("gene2");
        sf4.setName("gene2");
        SeqFeature sf5 = new SeqFeature(100, 200, "BLASTX", 1);
        SeqFeature sf6 = new SeqFeature(101, 201, "BLASTX", -1);
        SeqFeature sf7 = new SeqFeature(300, 400, "BLASTX", 1);
        SeqFeature sf8 = new SeqFeature(202, 302, "BLASTX", -1);
        sf5.setName("query");
        sf7.setName("query");
        sf6.setName("hit");
        sf8.setName("hit");
        FeaturePair fp1 = new FeaturePair(sf5, sf6);
        FeaturePair fp2 = new FeaturePair(sf7, sf8);
        Vector<SeqFeature> features = new Vector<SeqFeature>();
        PropertyScheme ftypes = null;
        try {
            ftypes = new PropertyScheme();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        features.addElement(sf1);
        features.addElement(sf2);
        features.addElement(sf3);
        features.addElement(sf4);
        features.addElement(fp1);
        features.addElement(fp2);
        StrandedFeatureSet fset = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        FeatureSetBuilder fse = new FeatureSetBuilder();
        fse.makeSetFeatures(fset, features, ftypes);
        for (int i = 0; i < fset.size(); ++i) {
            System.out.println("Printing set feature " + i);
            System.out.println(fset.getFeatureAt(i));
        }
    }
}

