/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInput;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.GFFAdapterGUI;
import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.NotImplementedException;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.Transcript;
import apollo.seq.io.FastaFile;
import apollo.seq.io.GFFFile;
import apollo.util.IOUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.DataAdapterRegistry;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.widget.DataAdapterChooser;
import org.bdgp.util.ProgressEvent;

public class BaseGFFAdapter
extends AbstractApolloAdapter {
    String filename;
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA, ApolloDataAdapterI.OP_WRITE_DATA};
    private GFFAdapterGUI gFFAdapterGUI;
    Sequence seq;
    String seqfile;
    Properties stateInformation = new Properties();

    public void init() {
    }

    public String getType() {
        return "Ensembl GFF File";
    }

    public DataInputType getInputType() {
        return DataInputType.FILE;
    }

    public String getInput() {
        return this.filename;
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public DataAdapterUI getUI(IOOperation op) {
        this.gFFAdapterGUI = null;
        this.gFFAdapterGUI = new GFFAdapterGUI(op);
        return this.gFFAdapterGUI;
    }

    public BaseGFFAdapter(String filename) {
        this.filename = filename;
        this.setName("Ensembl GFF file format");
    }

    public BaseGFFAdapter() {
        this.setName("Ensembl GFF file format");
    }

    public void setFilename(String filename) throws ApolloAdapterException {
        try {
            if (filename.startsWith("http:")) {
                String s;
                InputStream stream = null;
                filename = filename.trim();
                stream = this.getStreamFromUrl(this.getUrlFromString(filename), "URL " + filename + " not found");
                BufferedReader br = new BufferedReader(new InputStreamReader(stream));
                File f = File.createTempFile(filename.substring(filename.lastIndexOf("/")) + ".", ".gff");
                f.deleteOnExit();
                PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(f)));
                while ((s = br.readLine()) != null) {
                    pw.println(s);
                }
                pw.close();
                this.filename = f.getAbsolutePath();
                f.deleteOnExit();
            } else {
                this.filename = filename;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ApolloAdapterException(e);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setDataInput(DataInput dataInput) {
        if (!dataInput.isFile()) {
            return;
        }
        try {
            this.setFilename(dataInput.getFilename());
        }
        catch (ApolloAdapterException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (dataInput.hasSequenceFilename()) {
            this.setSequenceFilename(dataInput.getSequenceFilename());
        }
    }

    private InputStream getStreamFromUrl(URL url, String notFoundMessage) throws ApolloAdapterException {
        InputStream stream = null;
        if (url == null) {
            String message = "Couldn't find url for " + this.filename;
            System.err.println(message);
            throw new ApolloAdapterException(message);
        }
        if (url != null) {
            try {
                stream = url.openStream();
            }
            catch (IOException e) {
                e.printStackTrace();
                stream = null;
                throw new ApolloAdapterException(e);
            }
        }
        return stream;
    }

    private URL getUrlFromString(String urlString) throws ApolloAdapterException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            throw new ApolloAdapterException(ex);
        }
        return url;
    }

    public Properties getStateInformation() {
        Properties props = new Properties();
        props.put("dataFileName", this.filename);
        props.put("sequenceFileName", this.getSequenceFilename());
        return props;
    }

    public void setStateInformation(Properties props) {
        System.out.println("GFF adapter - set state info - props: " + props);
        this.stateInformation.putAll((Map<?, ?>)props);
        String name = props.getProperty("dataFileName");
        if (name != null && name.trim().length() > 0) {
            try {
                this.setFilename(name);
            }
            catch (ApolloAdapterException exception) {
                throw new NonFatalDataAdapterException(exception.getMessage());
            }
        }
        if ((name = props.getProperty("sequenceFileName")) != null && name.trim().length() > 0) {
            this.setSequenceFilename(name);
        }
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        try {
            CurationSet curationSet = new CurationSet();
            curationSet.setAnnots(this.getAnnotRegion());
            curationSet.setResults(this.getAnalysisRegion());
            curationSet.setName(this.filename);
            curationSet.setStart(curationSet.getResults().getLow());
            curationSet.setEnd(curationSet.getResults().getHigh());
            if (this.getSequenceFilename() != null && this.getSequenceFilename().trim().length() > 0) {
                String file = this.findFile(this.getSequenceFilename());
                if (file != null) {
                    this.setSequenceFilename(file);
                    try {
                        this.readSequence(file, curationSet);
                    }
                    catch (Exception e) {
                        String message = "Couldn't parse sequence file " + file + "\nAre you sure it's in FASTA format?\n";
                        System.err.println(message);
                        JOptionPane.showMessageDialog(null, message, "WARNING", 2);
                    }
                } else {
                    throw new ApolloAdapterException("couldn t find file for name: " + file);
                }
            }
            return curationSet;
        }
        catch (DataAdapterException exception) {
            throw new ApolloAdapterException(exception.getMessage(), (Exception)((Object)exception));
        }
    }

    protected GFFFile getGFFFile() throws DataAdapterException {
        try {
            String fullFilePath;
            this.filename = fullFilePath = this.findFile(this.filename);
            return new GFFFile(fullFilePath, "File");
        }
        catch (IOException e) {
            throw new DataAdapterException((Throwable)e, "Can't read file " + this.filename + " " + e);
        }
    }

    protected String findFile(String name) throws DataAdapterException {
        try {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(1.0), "Finding file..."));
            File input = new File(name);
            if (input == null || !input.canRead()) {
                String rootdir = System.getProperty("APOLLO_ROOT");
                if (!(name.startsWith("/") || name.startsWith("\\") || name.startsWith(rootdir))) {
                    String absolute = rootdir + "/" + name;
                    input = new File(absolute);
                    if (input != null && input.canRead()) {
                        name = absolute;
                    } else {
                        absolute = rootdir + "/data/" + name;
                        input = new File(absolute);
                        if (input != null && input.canRead()) {
                            name = absolute;
                        } else {
                            throw new DataAdapterException("Error: could not open file " + name + " for reading.");
                        }
                    }
                }
            }
            super.clearOldData();
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(1.0), "Beginning parse..."));
            return name;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataAdapterException((Throwable)e, e.getMessage());
        }
    }

    public StrandedFeatureSetI getAnalysisRegion() throws DataAdapterException {
        try {
            GFFFile gff = this.getGFFFile();
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(50.0), "Populating data structures..."));
            StrandedFeatureSet fset = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
            Vector features = gff.seqs;
            for (int i = 0; i < features.size(); ++i) {
                fset.addFeature((SeqFeatureI)features.get(i));
            }
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(100.0), "Done..."));
            return fset;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataAdapterException((Throwable)e, e.getMessage());
        }
    }

    public StrandedFeatureSetI getAnnotRegion() {
        StrandedFeatureSet annotations = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        return annotations;
    }

    public static void main(String[] args) throws Exception {
        DataAdapterRegistry registry = new DataAdapterRegistry();
        registry.installDataAdapter("apollo.dataadapter.GFFAdapter");
        registry.installDataAdapter("apollo.dataadapter.SerialDiskAdapter");
        registry.installDataAdapter("apollo.dataadapter.gamexml.GAMEAdapter");
        DataAdapterChooser chooser = new DataAdapterChooser(registry, ApolloDataAdapterI.OP_READ_DATA, "Load data", null, false);
        chooser.setPropertiesFile(new File("/mnt/Users/jrichter/cvs/apollo/src/java/apollo/dataadapter/junk.history"));
        chooser.show();
    }

    public FeatureSetI getAnnotatedRegion() throws DataAdapterException {
        return this.getAnnotRegion();
    }

    public SequenceI getSequence(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref, int start, int end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref, int[] start, int[] end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public String getRawAnalysisResults(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public void commitChanges(CurationSet curation) throws ApolloAdapterException {
        FileOutputStream fos = null;
        try {
            SequenceI seq;
            if (!this.filename.startsWith("/")) {
                String rootdir = System.getProperty("APOLLO_ROOT");
                this.filename = this.filename.startsWith("data/") ? rootdir + "/" + this.filename : rootdir + "/data/" + this.filename;
            }
            if ((fos = new FileOutputStream(this.filename)) != null) {
                this.writeGFF(curation, fos);
                System.out.println("Saved GFF to " + this.filename);
            }
            if (this.seqfile != null && (seq = curation.getRefSequence()) != null) {
                this.saveSequence(seq);
            }
        }
        catch (Exception ex) {
            System.err.println("caught exception opening " + this.filename);
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            throw new ApolloAdapterException("caught exception opening " + ex.getMessage(), ex);
        }
        try {
            fos.close();
        }
        catch (Exception ex) {
            System.err.println("caught exception closing " + this.filename);
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            throw new ApolloAdapterException("caught exception closing " + ex.getMessage(), ex);
        }
    }

    public void writeGFF(CurationSet curation, OutputStream os) {
        DataOutputStream dos = os instanceof DataOutputStream ? (DataOutputStream)os : new DataOutputStream(os);
        try {
            dos.writeBytes(this.writeAnnotations(curation));
            dos.writeBytes(this.writeAnalyses(curation));
        }
        catch (Exception ex) {
            System.err.println("caught exception committing GFF");
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public String writeAnnotations(CurationSet curation) {
        StringBuffer buf = new StringBuffer();
        StrandedFeatureSetI annots = curation.getAnnots();
        if (annots != null) {
            FeatureSetI forward = annots.getForwardSet();
            for (int i = 0; i < forward.size(); ++i) {
                if (!(forward.getFeatureAt(i) instanceof AnnotatedFeatureI)) continue;
                AnnotatedFeatureI sf = (AnnotatedFeatureI)forward.getFeatureAt(i);
                buf.append(this.writeAnnotation(sf));
            }
            FeatureSetI reverse = annots.getReverseSet();
            for (int i = 0; i < reverse.size(); ++i) {
                if (!(reverse.getFeatureAt(i) instanceof AnnotatedFeatureI)) continue;
                AnnotatedFeatureI sf = (AnnotatedFeatureI)reverse.getFeatureAt(i);
                buf.append(this.writeAnnotation(sf));
            }
        }
        return buf.toString();
    }

    public String writeAnnotation(AnnotatedFeatureI sf) {
        StringBuffer buf = new StringBuffer();
        boolean isa_gene = sf.isProteinCodingGene();
        Vector transcripts = sf.getFeatures();
        for (int i = 0; i < transcripts.size(); ++i) {
            Transcript fs = (Transcript)transcripts.elementAt(i);
            buf.append(this.writeTranscript(fs, isa_gene));
        }
        return buf.toString();
    }

    public String writeTranscript(Transcript trans, boolean isa_gene) {
        StringBuffer buf = new StringBuffer();
        buf.append(GFFFile.print(trans));
        return buf.toString();
    }

    public String writeAnalyses(CurationSet curation) {
        StringBuffer buf = new StringBuffer();
        StrandedFeatureSetI analyses = curation.getResults();
        if (analyses != null) {
            FeatureSetI forward_analyses = analyses.getForwardSet();
            for (int i = 0; i < forward_analyses.size(); ++i) {
                FeatureSetI analysis = (FeatureSetI)forward_analyses.getFeatureAt(i);
                buf.append(this.writeAnalysis(analysis));
            }
            FeatureSetI reverse_analyses = analyses.getReverseSet();
            for (int i = 0; i < reverse_analyses.size(); ++i) {
                FeatureSetI analysis = (FeatureSetI)reverse_analyses.getFeatureAt(i);
                buf.append(this.writeAnalysis(analysis));
            }
        }
        return buf.toString();
    }

    public String writeAnalysis(FeatureSetI sf) {
        StringBuffer buf = new StringBuffer();
        buf.append(GFFFile.print(sf));
        return buf.toString();
    }

    public Sequence getSequence() {
        return this.seq;
    }

    public void readSequence(String file, CurationSet curation) throws DataAdapterException {
        try {
            FastaFile ff = new FastaFile(file, "File", curation);
            this.seq = (Sequence)ff.getSeqs().elementAt(0);
        }
        catch (IOException e) {
            throw new DataAdapterException((Throwable)e, "Error reading sequencefile " + file + " " + e);
        }
    }

    public void setSequenceFilename(String seqfile) {
        this.seqfile = seqfile;
    }

    public String getSequenceFilename() {
        return this.seqfile;
    }

    public void saveSequence(SequenceI seq) throws DataAdapterException {
        try {
            String filename = IOUtil.findFile(this.seqfile, true);
            if (filename == null || filename.equals("")) {
                return;
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(filename);
            }
            catch (Exception ex) {
                System.err.println("Couldn't write to " + this.seqfile);
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
            if (fos == null) {
                return;
            }
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            PrintStream ps = new PrintStream(bos);
            SequenceI[] sa = new SequenceI[]{seq};
            if (seq.getDescription() != null) {
                seq.setName(seq.getName() + " " + seq.getDescription());
            }
            ps.print(FastaFile.print(sa));
            ps.flush();
            ps.close();
            System.out.println("Saved sequence to " + filename);
        }
        catch (Exception e) {
            System.out.println("Exception trying to save sequence to " + this.seqfile);
            e.printStackTrace();
        }
    }

    public void clearStateInformation() {
        this.stateInformation = new Properties();
    }
}

