/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.config.Config;
import java.lang.reflect.InvocationTargetException;
import org.bdgp.io.DataAdapterException;

public class ApolloAdapterException
extends DataAdapterException {
    Exception parentException;

    public ApolloAdapterException(String desc) {
        this(desc, null);
    }

    public ApolloAdapterException(String desc, Exception parentException) {
        super(desc);
        this.parentException = parentException;
    }

    public ApolloAdapterException(Exception parentException) {
        super("Exception from " + parentException.getClass().getName());
        this.parentException = parentException;
    }

    public Exception getParentException() {
        return this.parentException;
    }

    public static Throwable getRealException(ApolloAdapterException e) {
        Exception child = e.getParentException();
        if (child instanceof ApolloAdapterException) {
            return ApolloAdapterException.getRealException((ApolloAdapterException)((Object)child));
        }
        if (child instanceof InvocationTargetException) {
            return ApolloAdapterException.getRealException((InvocationTargetException)child);
        }
        return child;
    }

    public static Throwable getRealException(InvocationTargetException e) {
        Throwable child = e.getTargetException();
        if (child instanceof ApolloAdapterException) {
            return ApolloAdapterException.getRealException((ApolloAdapterException)((Object)child));
        }
        if (child instanceof InvocationTargetException) {
            return ApolloAdapterException.getRealException((InvocationTargetException)child);
        }
        return child;
    }

    public String toString() {
        String s = super.toString();
        if (this.getParentException() != null) {
            s = s + "\nParent Exception:\n" + this.getParentException().toString();
            if (Config.DEBUG) {
                this.getParentException().printStackTrace();
            }
        }
        return s;
    }
}

